/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.processing;

import com.sun.tools.javac.util.StringUtils;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.Parameterizable;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.RecordComponentElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleAnnotationValueVisitor14;
import javax.lang.model.util.SimpleElementVisitor14;

@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_22)
public class PrintingProcessor
extends AbstractProcessor {
    PrintWriter writer = new PrintWriter(System.out);

    public void setWriter(Writer w) {
        this.writer = new PrintWriter(w);
    }

    @Override
    public boolean process(Set<? extends TypeElement> tes, RoundEnvironment renv) {
        for (Element element : renv.getRootElements()) {
            this.print(element);
        }
        return true;
    }

    void print(Element element) {
        ((PrintingElementVisitor)new PrintingElementVisitor(this.writer, this.processingEnv.getElementUtils()).visit(element)).flush();
    }

    public static class PrintingElementVisitor
    extends SimpleElementVisitor14<PrintingElementVisitor, Boolean> {
        int indentation;
        final PrintWriter writer;
        final Elements elementUtils;
        private static final String[] spaces = new String[]{"", "  ", "    ", "      ", "        ", "          ", "            ", "              ", "                ", "                  ", "                    "};

        public PrintingElementVisitor(Writer w, Elements elementUtils) {
            this.writer = new PrintWriter(w);
            this.elementUtils = elementUtils;
            this.indentation = 0;
        }

        @Override
        protected PrintingElementVisitor defaultAction(Element e, Boolean newLine) {
            if (newLine != null && newLine.booleanValue()) {
                this.writer.println();
            }
            this.printDocComment(e);
            this.printModifiers(e);
            return this;
        }

        @Override
        public PrintingElementVisitor visitRecordComponent(RecordComponentElement e, Boolean p) {
            return this;
        }

        @Override
        public PrintingElementVisitor visitExecutable(ExecutableElement e, Boolean p) {
            ElementKind kind = e.getKind();
            if (kind != ElementKind.STATIC_INIT && kind != ElementKind.INSTANCE_INIT) {
                Element enclosing = e.getEnclosingElement();
                if (kind == ElementKind.CONSTRUCTOR && enclosing != null && NestingKind.ANONYMOUS == new SimpleElementVisitor14<NestingKind, Void>(){

                    @Override
                    public NestingKind visitType(TypeElement e, Void p) {
                        return e.getNestingKind();
                    }
                }.visit(enclosing)) {
                    return this;
                }
                this.defaultAction((Element)e, true);
                this.printFormalTypeParameters(e, true);
                switch (kind) {
                    case CONSTRUCTOR: {
                        this.writer.print(e.getEnclosingElement().getSimpleName());
                        break;
                    }
                    case METHOD: {
                        this.writer.print(e.getReturnType().toString());
                        this.writer.print(" ");
                        this.writer.print(e.getSimpleName().toString());
                    }
                }
                this.writer.print("(");
                this.printParameters(e);
                this.writer.print(")");
                AnnotationValue defaultValue = e.getDefaultValue();
                if (defaultValue != null) {
                    this.writer.print(" default " + defaultValue);
                }
                this.printThrows(e);
                this.writer.println(";");
            }
            return this;
        }

        @Override
        public PrintingElementVisitor visitType(TypeElement e, Boolean p) {
            TypeMirror supertype;
            ElementKind kind = e.getKind();
            NestingKind nestingKind = e.getNestingKind();
            if (NestingKind.ANONYMOUS == nestingKind) {
                Object constructors;
                TypeElement superClass;
                supertype = e.getSuperclass();
                if (supertype.getKind() != TypeKind.NONE && (superClass = (TypeElement)((DeclaredType)supertype).asElement()).getKind() == ElementKind.ENUM) {
                    return this;
                }
                this.writer.print("new ");
                List<? extends TypeMirror> interfaces = e.getInterfaces();
                if (!interfaces.isEmpty()) {
                    this.writer.print(interfaces.get(0));
                } else {
                    this.writer.print(e.getSuperclass());
                }
                this.writer.print("(");
                if (interfaces.isEmpty() && !(constructors = ElementFilter.constructorsIn(e.getEnclosedElements())).isEmpty()) {
                    this.printParameters(constructors.get(0));
                }
                this.writer.print(")");
            } else {
                TypeElement e2;
                PackageElement pkg;
                if (nestingKind == NestingKind.TOP_LEVEL && !(pkg = this.elementUtils.getPackageOf(e)).isUnnamed()) {
                    this.writer.print("package " + pkg.getQualifiedName() + ";\n");
                }
                this.defaultAction((Element)e, true);
                switch (kind) {
                    case ANNOTATION_TYPE: {
                        this.writer.print("@interface");
                        break;
                    }
                    default: {
                        this.writer.print(StringUtils.toLowerCase(kind.toString()));
                    }
                }
                this.writer.print(" ");
                this.writer.print(e.getSimpleName());
                this.printFormalTypeParameters(e, false);
                if (kind == ElementKind.RECORD) {
                    this.writer.print("(");
                    this.writer.print(e.getRecordComponents().stream().map(recordDes -> this.annotationsToString((Element)recordDes) + recordDes.asType().toString() + " " + recordDes.getSimpleName()).collect(Collectors.joining(", ")));
                    this.writer.print(")");
                }
                if (kind == ElementKind.CLASS && (supertype = e.getSuperclass()).getKind() != TypeKind.NONE && (e2 = (TypeElement)((DeclaredType)supertype).asElement()).getSuperclass().getKind() != TypeKind.NONE) {
                    this.writer.print(" extends " + supertype);
                }
                this.printInterfaces(e);
                this.printPermittedSubclasses(e);
            }
            this.writer.println(" {");
            ++this.indentation;
            if (kind == ElementKind.ENUM) {
                ArrayList<? extends Element> enclosedElements = new ArrayList<Element>(e.getEnclosedElements());
                ArrayList<Element> enumConstants = new ArrayList<Element>();
                for (Element element : enclosedElements) {
                    if (element.getKind() != ElementKind.ENUM_CONSTANT) continue;
                    enumConstants.add(element);
                }
                if (!enumConstants.isEmpty()) {
                    int i;
                    for (i = 0; i < enumConstants.size() - 1; ++i) {
                        this.visit((Element)enumConstants.get(i), true);
                        this.writer.print(",");
                    }
                    this.visit((Element)enumConstants.get(i), true);
                    this.writer.println(";\n");
                    enclosedElements.removeAll(enumConstants);
                }
                for (Element element : enclosedElements) {
                    this.visit(element);
                }
            } else {
                for (Element element : kind != ElementKind.RECORD ? e.getEnclosedElements() : e.getEnclosedElements().stream().filter(elt -> this.elementUtils.getOrigin((Element)elt) == Elements.Origin.EXPLICIT).collect(Collectors.toList())) {
                    this.visit(element);
                }
            }
            --this.indentation;
            this.indent();
            this.writer.println("}");
            return this;
        }

        @Override
        public PrintingElementVisitor visitVariable(VariableElement e, Boolean newLine) {
            ElementKind kind = e.getKind();
            this.defaultAction((Element)e, newLine);
            if (kind == ElementKind.ENUM_CONSTANT) {
                this.writer.print(e.getSimpleName());
            } else {
                this.writer.print(e.asType().toString() + " " + (e.getSimpleName().length() == 0 ? "_" : e.getSimpleName()));
                Object constantValue = e.getConstantValue();
                if (constantValue != null) {
                    this.writer.print(" = ");
                    this.writer.print(this.elementUtils.getConstantExpression(constantValue));
                }
                this.writer.println(";");
            }
            return this;
        }

        @Override
        public PrintingElementVisitor visitTypeParameter(TypeParameterElement e, Boolean p) {
            this.writer.print(e.getSimpleName());
            return this;
        }

        @Override
        public PrintingElementVisitor visitPackage(PackageElement e, Boolean p) {
            this.defaultAction((Element)e, false);
            if (!e.isUnnamed()) {
                this.writer.println("package " + e.getQualifiedName() + ";");
            } else {
                this.writer.println("// Unnamed package");
            }
            return this;
        }

        @Override
        public PrintingElementVisitor visitModule(ModuleElement e, Boolean p) {
            this.defaultAction((Element)e, false);
            if (!e.isUnnamed()) {
                if (e.isOpen()) {
                    this.writer.print("open ");
                }
                this.writer.println("module " + e.getQualifiedName() + " {");
                ++this.indentation;
                for (ModuleElement.Directive directive : e.getDirectives()) {
                    this.printDirective(directive);
                }
                --this.indentation;
                this.writer.println("}");
            } else {
                this.writer.println("// Unnamed module");
            }
            return this;
        }

        private void printDirective(ModuleElement.Directive directive) {
            this.indent();
            new PrintDirective(this.writer).visit(directive);
            this.writer.println(";");
        }

        public void flush() {
            this.writer.flush();
        }

        private void printDocComment(Element e) {
            String docComment = this.elementUtils.getDocComment(e);
            if (docComment != null) {
                StringTokenizer st = new StringTokenizer(docComment, "\n\r");
                this.indent();
                this.writer.println("/**");
                while (st.hasMoreTokens()) {
                    this.indent();
                    this.writer.print(" *");
                    this.writer.println(st.nextToken());
                }
                this.indent();
                this.writer.println(" */");
            }
        }

        private void printModifiers(Element e) {
            ElementKind kind = e.getKind();
            if (kind == ElementKind.PARAMETER || kind == ElementKind.RECORD_COMPONENT) {
                this.writer.print(this.annotationsToString(e));
            } else {
                this.printAnnotations(e);
                this.indent();
            }
            if (kind == ElementKind.ENUM_CONSTANT || kind == ElementKind.RECORD_COMPONENT) {
                return;
            }
            LinkedHashSet<Modifier> modifiers = new LinkedHashSet<Modifier>();
            modifiers.addAll(e.getModifiers());
            switch (kind) {
                case ANNOTATION_TYPE: 
                case INTERFACE: {
                    modifiers.remove((Object)Modifier.ABSTRACT);
                    break;
                }
                case ENUM: {
                    modifiers.remove((Object)Modifier.FINAL);
                    modifiers.remove((Object)Modifier.ABSTRACT);
                    modifiers.remove((Object)Modifier.SEALED);
                    break;
                }
                case RECORD: {
                    modifiers.remove((Object)Modifier.FINAL);
                    break;
                }
                case METHOD: 
                case FIELD: {
                    Element enclosingElement = e.getEnclosingElement();
                    if (enclosingElement == null || !enclosingElement.getKind().isInterface()) break;
                    modifiers.remove((Object)Modifier.PUBLIC);
                    modifiers.remove((Object)Modifier.ABSTRACT);
                    modifiers.remove((Object)Modifier.STATIC);
                    modifiers.remove((Object)Modifier.FINAL);
                }
            }
            if (!modifiers.isEmpty()) {
                this.writer.print(modifiers.stream().map(Modifier::toString).collect(Collectors.joining(" ", "", " ")));
            }
        }

        private void printFormalTypeParameters(Parameterizable e, boolean pad) {
            List<? extends TypeParameterElement> typeParams = e.getTypeParameters();
            if (!typeParams.isEmpty()) {
                this.writer.print(typeParams.stream().map(tpe -> this.annotationsToString((Element)tpe) + tpe.toString()).collect(Collectors.joining(", ", "<", ">")));
                if (pad) {
                    this.writer.print(" ");
                }
            }
        }

        private String annotationsToString(Element e) {
            List<? extends AnnotationMirror> annotations = e.getAnnotationMirrors();
            return annotations.isEmpty() ? "" : annotations.stream().map((Function<AnnotationMirror, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Ljavax/lang/model/element/AnnotationMirror;)Ljava/lang/String;)()).collect(Collectors.joining(" ", "", " "));
        }

        private void printAnnotations(Element e) {
            List<? extends AnnotationMirror> annots = e.getAnnotationMirrors();
            for (AnnotationMirror annotationMirror : annots) {
                if (this.printedContainerAnnotation(e, annotationMirror)) continue;
                this.indent();
                this.writer.println(annotationMirror);
            }
        }

        private boolean printedContainerAnnotation(Element e, AnnotationMirror annotationMirror) {
            Set<Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>> entries;
            if (this.elementUtils.getOrigin(e, annotationMirror) == Elements.Origin.MANDATED && (entries = annotationMirror.getElementValues().entrySet()).size() == 1) {
                List<ExecutableElement> annotationMethods;
                DeclaredType annotationType = annotationMirror.getAnnotationType();
                Element annotationTypeAsElement = annotationType.asElement();
                Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry = entries.iterator().next();
                AnnotationValue annotationElements = entry.getValue();
                if (annotationTypeAsElement.getKind() == ElementKind.ANNOTATION_TYPE && (annotationMethods = ElementFilter.methodsIn(annotationTypeAsElement.getEnclosedElements())).size() == 1) {
                    ExecutableElement valueMethod = annotationMethods.get(0);
                    TypeMirror returnType = valueMethod.getReturnType();
                    if ("value".equals(valueMethod.getSimpleName().toString()) && returnType.getKind() == TypeKind.ARRAY) {
                        return (Boolean)new SimpleAnnotationValueVisitor14<Boolean, Void>(Boolean.valueOf(false)){

                            @Override
                            public Boolean visitArray(List<? extends AnnotationValue> vals, Void p) {
                                if (vals.size() < 2) {
                                    return false;
                                }
                                for (AnnotationValue annotationValue : vals) {
                                    this.indent();
                                    writer.println(annotationValue.toString());
                                }
                                return true;
                            }
                        }.visit(annotationElements);
                    }
                }
            }
            return false;
        }

        private void printParameters(ExecutableElement e) {
            List<? extends VariableElement> parameters = e.getParameters();
            int size = parameters.size();
            switch (size) {
                case 0: {
                    break;
                }
                case 1: {
                    for (VariableElement variableElement : parameters) {
                        this.printModifiers(variableElement);
                        if (e.isVarArgs()) {
                            TypeMirror typeMirror = variableElement.asType();
                            if (typeMirror.getKind() != TypeKind.ARRAY) {
                                throw new AssertionError((Object)("Var-args parameter is not an array type: " + typeMirror));
                            }
                            this.writer.print(((ArrayType)ArrayType.class.cast(typeMirror)).getComponentType());
                            this.writer.print("...");
                        } else {
                            this.writer.print(variableElement.asType());
                        }
                        this.writer.print(" " + variableElement.getSimpleName());
                    }
                    break;
                }
                default: {
                    int i = 1;
                    for (VariableElement variableElement : parameters) {
                        if (i == 2) {
                            ++this.indentation;
                        }
                        if (i > 1) {
                            this.indent();
                        }
                        this.printModifiers(variableElement);
                        if (i == size && e.isVarArgs()) {
                            TypeMirror tm = variableElement.asType();
                            if (tm.getKind() != TypeKind.ARRAY) {
                                throw new AssertionError((Object)("Var-args parameter is not an array type: " + tm));
                            }
                            this.writer.print(((ArrayType)ArrayType.class.cast(tm)).getComponentType());
                            this.writer.print("...");
                        } else {
                            this.writer.print(variableElement.asType());
                        }
                        this.writer.print(" " + variableElement.getSimpleName());
                        if (i < size) {
                            this.writer.println(",");
                        }
                        ++i;
                    }
                    if (parameters.size() < 2) break;
                    --this.indentation;
                }
            }
        }

        private void printInterfaces(TypeElement e) {
            List<? extends TypeMirror> interfaces;
            ElementKind kind = e.getKind();
            if (kind != ElementKind.ANNOTATION_TYPE && !(interfaces = e.getInterfaces()).isEmpty()) {
                this.writer.print(kind.isClass() ? " implements " : " extends ");
                this.writer.print(interfaces.stream().map(TypeMirror::toString).collect(Collectors.joining(", ")));
            }
        }

        private void printPermittedSubclasses(TypeElement e) {
            if (e.getKind() == ElementKind.ENUM) {
                return;
            }
            List<? extends TypeMirror> subtypes = e.getPermittedSubclasses();
            if (!subtypes.isEmpty()) {
                this.writer.print(" permits ");
                this.writer.print(subtypes.stream().map(subtype -> subtype.toString()).collect(Collectors.joining(", ")));
            }
        }

        private void printThrows(ExecutableElement e) {
            List<? extends TypeMirror> thrownTypes = e.getThrownTypes();
            int size = thrownTypes.size();
            if (size != 0) {
                this.writer.print(" throws");
                int i = 1;
                for (TypeMirror typeMirror : thrownTypes) {
                    if (i == 1) {
                        this.writer.print(" ");
                    }
                    if (i == 2) {
                        ++this.indentation;
                    }
                    if (i >= 2) {
                        this.indent();
                    }
                    this.writer.print(typeMirror);
                    if (i != size) {
                        this.writer.println(", ");
                    }
                    ++i;
                }
                if (size >= 2) {
                    --this.indentation;
                }
            }
        }

        private void indent() {
            int indentation = this.indentation;
            if (indentation < 0) {
                return;
            }
            int maxIndex = spaces.length - 1;
            while (indentation > maxIndex) {
                this.writer.print(spaces[maxIndex]);
                indentation -= maxIndex;
            }
            this.writer.print(spaces[indentation]);
        }

        private static class PrintDirective
        implements ModuleElement.DirectiveVisitor<Void, Void> {
            private final PrintWriter writer;

            PrintDirective(PrintWriter writer) {
                this.writer = writer;
            }

            @Override
            public Void visitExports(ModuleElement.ExportsDirective d, Void p) {
                this.writer.print("exports ");
                this.writer.print(d.getPackage().getQualifiedName());
                this.printModuleList(d.getTargetModules());
                return null;
            }

            @Override
            public Void visitOpens(ModuleElement.OpensDirective d, Void p) {
                this.writer.print("opens ");
                this.writer.print(d.getPackage().getQualifiedName());
                this.printModuleList(d.getTargetModules());
                return null;
            }

            @Override
            public Void visitProvides(ModuleElement.ProvidesDirective d, Void p) {
                this.writer.print("provides ");
                this.writer.print(d.getService().getQualifiedName());
                this.writer.print(" with ");
                this.printNameableList(d.getImplementations());
                return null;
            }

            @Override
            public Void visitRequires(ModuleElement.RequiresDirective d, Void p) {
                this.writer.print("requires ");
                if (d.isStatic()) {
                    this.writer.print("static ");
                }
                if (d.isTransitive()) {
                    this.writer.print("transitive ");
                }
                this.writer.print(d.getDependency().getQualifiedName());
                return null;
            }

            @Override
            public Void visitUses(ModuleElement.UsesDirective d, Void p) {
                this.writer.print("uses ");
                this.writer.print(d.getService().getQualifiedName());
                return null;
            }

            private void printModuleList(List<? extends ModuleElement> modules) {
                if (modules != null) {
                    this.writer.print(" to ");
                    this.printNameableList(modules);
                }
            }

            private void printNameableList(List<? extends QualifiedNameable> nameables) {
                this.writer.print(nameables.stream().map(QualifiedNameable::getQualifiedName).collect(Collectors.joining(", ")));
            }
        }
    }
}

