/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.source.tree.ModuleTree;
import com.sun.tools.javac.code.DeferredLintHandler;
import com.sun.tools.javac.code.Directive;
import com.sun.tools.javac.code.Flags;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.ModuleFinder;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.TypeEnvs;
import com.sun.tools.javac.jvm.ClassWriter;
import com.sun.tools.javac.jvm.JNIWriter;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.SourceVersion;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import nbjavac.ModuleWrapper;

public class Modules
extends JCTree.Visitor {
    private static final String ALL_SYSTEM = "ALL-SYSTEM";
    private static final String ALL_MODULE_PATH = "ALL-MODULE-PATH";
    private final Lint lint;
    private final Log log;
    private final Names names;
    private final Symtab syms;
    private final Attr attr;
    private final Check chk;
    private final DeferredLintHandler deferredLintHandler;
    private final TypeEnvs typeEnvs;
    private final Types types;
    private final JavaFileManager fileManager;
    private final ModuleFinder moduleFinder;
    private final Source source;
    private final Target target;
    private final boolean allowModules;
    private final boolean allowAccessIntoSystem;
    public final boolean multiModuleMode;
    private final Name java_se;
    private final Name java_;
    Symbol.ModuleSymbol defaultModule;
    private final String addExportsOpt;
    private Map<Symbol.ModuleSymbol, Set<Directive.ExportsDirective>> addExports;
    private final String addReadsOpt;
    private Map<Symbol.ModuleSymbol, Set<Directive.RequiresDirective>> addReads;
    private final String addModsOpt;
    private final Set<String> extraAddMods = new HashSet<String>();
    private final String limitModsOpt;
    private final Set<String> extraLimitMods = new HashSet<String>();
    private final String moduleVersionOpt;
    private final boolean sourceLauncher;
    private final boolean lintOptions;
    private Set<Symbol.ModuleSymbol> rootModules = null;
    private final Set<Symbol.ModuleSymbol> warnedMissing = new HashSet<Symbol.ModuleSymbol>();
    public PackageNameFinder findPackageInFile;
    int depth = -1;
    boolean inInitModules;
    private final Symbol.Completer mainCompleter = new Symbol.Completer(){

        @Override
        public void complete(Symbol sym) throws Symbol.CompletionFailure {
            Symbol.ModuleSymbol msym = Modules.this.moduleFinder.findModule((Symbol.ModuleSymbol)sym);
            if (msym.kind == Kinds.Kind.ERR) {
                this.initErrModule(msym);
            } else if ((msym.flags_field & 0x10000000000000L) != 0L) {
                Modules.this.setupAutomaticModule(msym);
            } else {
                try {
                    msym.module_info.complete();
                }
                catch (Symbol.CompletionFailure cf) {
                    msym.kind = Kinds.Kind.ERR;
                    this.initErrModule(msym);
                    Modules.this.completeModule(msym);
                    throw cf;
                }
            }
            if (msym.module_info.classfile == null || msym.module_info.classfile.getKind() == JavaFileObject.Kind.CLASS) {
                Modules.this.completeModule(msym);
            }
        }

        private void initErrModule(Symbol.ModuleSymbol msym) {
            msym.directives = List.nil();
            msym.exports = List.nil();
            msym.provides = List.nil();
            msym.requires = List.nil();
            msym.uses = List.nil();
        }

        public String toString() {
            return "mainCompleter";
        }
    };
    private Set<Symbol.ModuleSymbol> allModules;
    private static final Predicate<Symbol.ModuleSymbol> IS_AUTOMATIC = m -> (m.flags_field & 0x10000000000000L) != 0L;
    private final Map<Symbol.ModuleSymbol, Set<Symbol.ModuleSymbol>> requiresTransitiveCache = new HashMap<Symbol.ModuleSymbol, Set<Symbol.ModuleSymbol>>();

    public static Modules instance(Context context) {
        Modules instance = context.get(Modules.class);
        if (instance == null) {
            instance = new Modules(context);
        }
        return instance;
    }

    protected Modules(Context context) {
        context.put(Modules.class, this);
        this.log = Log.instance(context);
        this.lint = Lint.instance(context);
        this.names = Names.instance(context);
        this.syms = Symtab.instance(context);
        this.attr = Attr.instance(context);
        this.chk = Check.instance(context);
        this.deferredLintHandler = DeferredLintHandler.instance(context);
        this.typeEnvs = TypeEnvs.instance(context);
        this.moduleFinder = ModuleFinder.instance(context);
        this.types = Types.instance(context);
        this.fileManager = context.get(JavaFileManager.class);
        this.source = Source.instance(context);
        this.target = Target.instance(context);
        this.allowModules = Source.Feature.MODULES.allowedInSource(this.source);
        Options options = Options.instance(context);
        this.allowAccessIntoSystem = options.isUnset(Option.RELEASE);
        this.lintOptions = options.isUnset(Option.XLINT_CUSTOM, "-" + Lint.LintCategory.OPTIONS.option);
        this.multiModuleMode = this.fileManager.hasLocation(StandardLocation.MODULE_SOURCE_PATH);
        ClassWriter classWriter = ClassWriter.instance(context);
        classWriter.multiModuleMode = this.multiModuleMode;
        JNIWriter jniWriter = JNIWriter.instance(context);
        jniWriter.multiModuleMode = this.multiModuleMode;
        this.java_se = this.names.fromString("java.se");
        this.java_ = this.names.fromString("java.");
        this.addExportsOpt = options.get(Option.ADD_EXPORTS);
        this.addReadsOpt = options.get(Option.ADD_READS);
        this.addModsOpt = options.get(Option.ADD_MODULES);
        this.limitModsOpt = options.get(Option.LIMIT_MODULES);
        this.moduleVersionOpt = options.get(Option.MODULE_VERSION);
        this.sourceLauncher = options.isSet("sourceLauncher");
    }

    public void addExtraAddModules(String ... extras) {
        this.extraAddMods.addAll(Arrays.asList(extras));
    }

    public void initModules(List<JCTree.JCCompilationUnit> trees) {
        Assert.check(!this.inInitModules);
        try {
            this.inInitModules = true;
            Assert.checkNull(this.rootModules);
            this.enter(trees, modules -> {
                Assert.checkNull(this.rootModules);
                Assert.checkNull(this.allModules);
                this.rootModules = modules;
                this.setupAllModules();
                Assert.checkNonNull(this.allModules);
                this.inInitModules = false;
            }, null);
        }
        finally {
            this.inInitModules = false;
        }
    }

    public boolean enter(List<JCTree.JCCompilationUnit> trees, Symbol.ClassSymbol c) {
        Assert.check(this.rootModules != null || this.inInitModules || !this.allowModules);
        return this.enter(trees, modules -> {}, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean enter(List<JCTree.JCCompilationUnit> trees, Consumer<Set<Symbol.ModuleSymbol>> init, Symbol.ClassSymbol c) {
        if (!this.allowModules) {
            for (JCTree.JCCompilationUnit tree : trees) {
                tree.modle = this.syms.noModule;
            }
            this.defaultModule = this.syms.noModule;
            return true;
        }
        int startErrors = this.log.nerrors;
        ++this.depth;
        try {
            Set<Symbol.ModuleSymbol> roots = this.enterModules(trees, c);
            this.setCompilationUnitModules(trees, roots, c);
            init.accept(roots);
            for (Symbol.ModuleSymbol msym : roots) {
                msym.complete();
            }
        }
        catch (Symbol.CompletionFailure ex) {
            this.chk.completionError(null, ex);
        }
        finally {
            --this.depth;
        }
        return this.log.nerrors == startErrors;
    }

    public Symbol.Completer getCompleter() {
        return this.mainCompleter;
    }

    public Symbol.ModuleSymbol getDefaultModule() {
        return this.defaultModule;
    }

    public boolean modulesInitialized() {
        return this.allModules != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Symbol.ModuleSymbol> enterModules(List<JCTree.JCCompilationUnit> trees, Symbol.ClassSymbol c) {
        LinkedHashSet<Symbol.ModuleSymbol> modules = new LinkedHashSet<Symbol.ModuleSymbol>();
        for (JCTree.JCCompilationUnit tree : trees) {
            JavaFileObject prev = this.log.useSource(tree.sourcefile);
            try {
                this.enterModule(tree, c, modules);
            }
            finally {
                this.log.useSource(prev);
            }
        }
        return modules;
    }

    private void enterModule(JCTree.JCCompilationUnit toplevel, Symbol.ClassSymbol c, Set<Symbol.ModuleSymbol> modules) {
        boolean isModuleDecl;
        boolean isModuleInfo = toplevel.sourcefile.isNameCompatible("module-info", JavaFileObject.Kind.SOURCE);
        boolean bl = isModuleDecl = toplevel.getModuleDecl() != null;
        if (isModuleDecl) {
            Symbol.ModuleSymbol sym;
            JCTree.JCModuleDecl decl = toplevel.getModuleDecl();
            if (!isModuleInfo) {
                this.log.error(decl.pos(), CompilerProperties.Errors.ModuleDeclSbInModuleInfoJava);
            }
            Name name = TreeInfo.fullName(decl.qualId);
            if (c != null) {
                sym = (Symbol.ModuleSymbol)c.owner;
                Assert.checkNonNull(sym.name);
                Name treeName = TreeInfo.fullName(decl.qualId);
                if (sym.name != treeName) {
                    this.log.error(decl.pos(), CompilerProperties.Errors.ModuleNameMismatch(name, sym.name));
                }
            } else {
                sym = this.syms.enterModule(name);
                if (sym.module_info.sourcefile != null && sym.module_info.sourcefile != toplevel.sourcefile) {
                    this.log.error(decl.pos(), CompilerProperties.Errors.DuplicateModule(sym));
                    return;
                }
            }
            sym.completer = this.getSourceCompleter(toplevel);
            sym.module_info.classfile = sym.module_info.sourcefile = toplevel.sourcefile;
            decl.sym = sym;
            if (this.multiModuleMode || modules.isEmpty()) {
                modules.add(sym);
            } else {
                this.log.error(toplevel.pos(), CompilerProperties.Errors.TooManyModules);
            }
            Env<Object> provisionalEnv = new Env<Object>(decl, null);
            provisionalEnv.toplevel = toplevel;
            this.typeEnvs.put(sym, provisionalEnv);
        } else if (isModuleInfo && this.multiModuleMode) {
            JCTree.JCCompilationUnit tree = toplevel.defs.isEmpty() ? toplevel : (JCTree)toplevel.defs.head;
            this.log.error(tree.pos(), CompilerProperties.Errors.ExpectedModule);
        }
    }

    private void setCompilationUnitModules(List<JCTree.JCCompilationUnit> trees, Set<Symbol.ModuleSymbol> rootModules, Symbol.ClassSymbol c) {
        if (this.multiModuleMode) {
            boolean patchesAutomaticModules = false;
            for (JCTree.JCCompilationUnit tree : trees) {
                if (tree.defs.isEmpty()) {
                    tree.modle = this.syms.unnamedModule;
                    continue;
                }
                JavaFileObject prev = this.log.useSource(tree.sourcefile);
                try {
                    Symbol.ModuleSymbol msym;
                    Name name;
                    JavaFileManager.Location plocn;
                    JavaFileManager.Location msplocn = this.getModuleLocation(tree);
                    JavaFileManager.Location location = plocn = this.fileManager.hasLocation(StandardLocation.PATCH_MODULE_PATH) ? this.fileManager.getLocationForModule((JavaFileManager.Location)StandardLocation.PATCH_MODULE_PATH, tree.sourcefile) : null;
                    if (plocn != null) {
                        Name mspname;
                        name = this.names.fromString(this.fileManager.inferModuleName(plocn));
                        tree.modle = msym = this.moduleFinder.findModule(name);
                        rootModules.add(msym);
                        patchesAutomaticModules |= (msym.flags_field & 0x10000000000000L) != 0L;
                        if (msplocn == null || name == (mspname = this.names.fromString(this.fileManager.inferModuleName(msplocn)))) continue;
                        this.log.error(tree.pos(), CompilerProperties.Errors.FilePatchedAndMsp(name, mspname));
                        continue;
                    }
                    if (msplocn != null) {
                        JavaFileObject canonical;
                        if (!(tree.getModuleDecl() == null || (canonical = this.fileManager.getJavaFileForInput(msplocn, "module-info", JavaFileObject.Kind.SOURCE)) != null && this.fileManager.isSameFile(canonical, tree.sourcefile))) {
                            this.log.error(tree.pos(), CompilerProperties.Errors.ModuleNotFoundOnModuleSourcePath);
                        }
                        name = this.names.fromString(this.fileManager.inferModuleName(msplocn));
                        JCTree.JCModuleDecl decl = tree.getModuleDecl();
                        if (decl != null) {
                            msym = decl.sym;
                            if (msym.name != name) {
                                this.log.error(decl.qualId, CompilerProperties.Errors.ModuleNameMismatch(msym.name, name));
                            }
                        } else {
                            if (tree.getPackage() == null) {
                                this.log.error(tree.pos(), CompilerProperties.Errors.UnnamedPkgNotAllowedNamedModules);
                            }
                            msym = this.syms.enterModule(name);
                        }
                        if (msym.sourceLocation == null) {
                            msym.sourceLocation = msplocn;
                            if (this.fileManager.hasLocation(StandardLocation.PATCH_MODULE_PATH)) {
                                msym.patchLocation = this.fileManager.getLocationForModule((JavaFileManager.Location)StandardLocation.PATCH_MODULE_PATH, msym.name.toString());
                            }
                            if (this.fileManager.hasLocation(StandardLocation.CLASS_OUTPUT)) {
                                JavaFileManager.Location outputLocn = this.fileManager.getLocationForModule((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, msym.name.toString());
                                if (msym.patchLocation == null) {
                                    msym.classLocation = outputLocn;
                                } else {
                                    msym.patchOutputLocation = outputLocn;
                                }
                            }
                        }
                        tree.modle = msym;
                        rootModules.add(msym);
                        continue;
                    }
                    if (c != null && c.packge().modle == this.syms.unnamedModule) {
                        tree.modle = this.syms.unnamedModule;
                        continue;
                    }
                    if (tree.getModuleDecl() != null) {
                        this.log.error(tree.pos(), CompilerProperties.Errors.ModuleNotFoundOnModuleSourcePath);
                    } else {
                        this.log.error(tree.pos(), CompilerProperties.Errors.NotInModuleOnModuleSourcePath);
                    }
                    tree.modle = this.syms.errModule;
                }
                catch (IOException e) {
                    throw new Error(e);
                }
                finally {
                    this.log.useSource(prev);
                }
            }
            if (!patchesAutomaticModules) {
                this.checkNoAllModulePath();
            }
            if (this.syms.unnamedModule.sourceLocation == null) {
                this.syms.unnamedModule.completer = this.getUnnamedModuleCompleter();
                this.syms.unnamedModule.sourceLocation = StandardLocation.SOURCE_PATH;
                this.syms.unnamedModule.classLocation = StandardLocation.CLASS_PATH;
            }
            this.defaultModule = this.syms.unnamedModule;
        } else {
            Symbol.ModuleSymbol module = null;
            if (this.defaultModule == null) {
                String moduleOverride = this.singleModuleOverride(trees);
                switch (rootModules.size()) {
                    case 0: {
                        try {
                            this.defaultModule = this.moduleFinder.findSingleModule();
                        }
                        catch (Symbol.CompletionFailure cf) {
                            this.chk.completionError(null, cf);
                            this.defaultModule = this.syms.unnamedModule;
                        }
                        if (this.defaultModule == this.syms.unnamedModule) {
                            if (moduleOverride != null) {
                                this.defaultModule = this.moduleFinder.findModule(this.names.fromString(moduleOverride));
                                this.defaultModule.patchOutputLocation = StandardLocation.CLASS_OUTPUT;
                                if ((this.defaultModule.flags_field & 0x10000000000000L) == 0L) {
                                    this.checkNoAllModulePath();
                                }
                            } else {
                                this.defaultModule.completer = this.getUnnamedModuleCompleter();
                                this.defaultModule.sourceLocation = StandardLocation.SOURCE_PATH;
                                this.defaultModule.classLocation = StandardLocation.CLASS_PATH;
                            }
                        } else {
                            this.checkNoAllModulePath();
                            this.defaultModule.complete();
                            this.defaultModule.completer = sym -> this.completeModule((Symbol.ModuleSymbol)sym);
                            this.defaultModule.sourceLocation = StandardLocation.SOURCE_PATH;
                        }
                        rootModules.add(this.defaultModule);
                        break;
                    }
                    case 1: {
                        this.checkNoAllModulePath();
                        this.defaultModule = rootModules.iterator().next();
                        this.defaultModule.sourceLocation = StandardLocation.SOURCE_PATH;
                        if (this.fileManager.hasLocation(StandardLocation.PATCH_MODULE_PATH)) {
                            try {
                                this.defaultModule.patchLocation = this.fileManager.getLocationForModule((JavaFileManager.Location)StandardLocation.PATCH_MODULE_PATH, this.defaultModule.name.toString());
                            }
                            catch (IOException ex) {
                                throw new Error(ex);
                            }
                        }
                        if (this.defaultModule.patchLocation == null) {
                            this.defaultModule.classLocation = StandardLocation.CLASS_OUTPUT;
                            break;
                        }
                        this.defaultModule.patchOutputLocation = StandardLocation.CLASS_OUTPUT;
                        break;
                    }
                    default: {
                        Assert.error("too many modules");
                        break;
                    }
                }
            } else if (rootModules.size() == 1) {
                module = rootModules.iterator().next();
                module.complete();
                module.completer = sym -> this.completeModule((Symbol.ModuleSymbol)sym);
            } else {
                Assert.check(rootModules.isEmpty());
                Assert.checkNonNull(c);
                module = c.packge().modle;
                rootModules.add(module);
            }
            if (this.defaultModule != this.syms.unnamedModule) {
                this.syms.unnamedModule.completer = this.getUnnamedModuleCompleter();
                this.syms.unnamedModule.classLocation = StandardLocation.CLASS_PATH;
            }
            if (module == null) {
                module = this.defaultModule;
            }
            for (JCTree.JCCompilationUnit tree : trees) {
                if (this.defaultModule != this.syms.unnamedModule && this.defaultModule.sourceLocation == StandardLocation.SOURCE_PATH && this.fileManager.hasLocation(StandardLocation.SOURCE_PATH)) {
                    this.checkSourceLocation(tree, module);
                }
                tree.modle = module;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSourceLocation(JCTree.JCCompilationUnit tree, Symbol.ModuleSymbol msym) {
        try {
            JavaFileObject fo = tree.sourcefile;
            if (this.fileManager.contains(msym.sourceLocation, fo)) {
                return;
            }
            if (msym.patchLocation != null && this.fileManager.contains(msym.patchLocation, fo)) {
                return;
            }
            if (this.fileManager.hasLocation(StandardLocation.SOURCE_OUTPUT) ? this.fileManager.contains(StandardLocation.SOURCE_OUTPUT, fo) : this.fileManager.contains(StandardLocation.CLASS_OUTPUT, fo)) {
                return;
            }
        }
        catch (IOException e) {
            throw new Error(e);
        }
        JavaFileObject prev = this.log.useSource(tree.sourcefile);
        try {
            this.log.error(tree.pos(), CompilerProperties.Errors.FileSbOnSourceOrPatchPathForModule);
        }
        finally {
            this.log.useSource(prev);
        }
    }

    private String singleModuleOverride(List<JCTree.JCCompilationUnit> trees) {
        if (!this.fileManager.hasLocation(StandardLocation.PATCH_MODULE_PATH)) {
            return null;
        }
        LinkedHashSet<String> override = new LinkedHashSet<String>();
        for (JCTree.JCCompilationUnit tree : trees) {
            JavaFileObject fo = tree.sourcefile;
            try {
                JavaFileManager.Location loc = this.fileManager.getLocationForModule((JavaFileManager.Location)StandardLocation.PATCH_MODULE_PATH, fo);
                if (loc == null) continue;
                override.add(this.fileManager.inferModuleName(loc));
            }
            catch (IOException ex) {
                throw new Error(ex);
            }
        }
        switch (override.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (String)override.iterator().next();
            }
        }
        this.log.error(CompilerProperties.Errors.TooManyPatchedModules(override));
        return null;
    }

    private JavaFileManager.Location getModuleLocation(JCTree.JCCompilationUnit tree) throws IOException {
        JavaFileObject fo = tree.sourcefile;
        JavaFileManager.Location loc = this.fileManager.getLocationForModule((JavaFileManager.Location)StandardLocation.MODULE_SOURCE_PATH, fo);
        if (loc == null) {
            StandardLocation sourceOutput = this.fileManager.hasLocation(StandardLocation.SOURCE_OUTPUT) ? StandardLocation.SOURCE_OUTPUT : StandardLocation.CLASS_OUTPUT;
            loc = this.fileManager.getLocationForModule((JavaFileManager.Location)sourceOutput, fo);
        }
        return loc;
    }

    private void checkNoAllModulePath() {
        if (this.addModsOpt != null && Arrays.asList(this.addModsOpt.split(",")).contains(ALL_MODULE_PATH)) {
            this.log.error(CompilerProperties.Errors.AddmodsAllModulePathInvalid);
        }
    }

    private void setupAutomaticModule(Symbol.ModuleSymbol msym) throws Symbol.CompletionFailure {
        try {
            ListBuffer<Directive.ExportsDirective> directives = new ListBuffer<Directive.ExportsDirective>();
            ListBuffer<Directive.ExportsDirective> exports = new ListBuffer<Directive.ExportsDirective>();
            HashSet<String> seenPackages = new HashSet<String>();
            for (JavaFileObject clazz : this.fileManager.list(msym.classLocation, "", EnumSet.of(JavaFileObject.Kind.CLASS), true)) {
                String binName = this.fileManager.inferBinaryName(msym.classLocation, clazz);
                String pack = binName.lastIndexOf(46) != -1 ? binName.substring(0, binName.lastIndexOf(46)) : "";
                if (!seenPackages.add(pack)) continue;
                Directive.ExportsDirective d = new Directive.ExportsDirective(this.syms.enterPackage(msym, this.names.fromString(pack)), null);
                directives.add(d);
                exports.add(d);
            }
            msym.exports = exports.toList();
            msym.provides = List.nil();
            msym.requires = List.nil();
            msym.uses = List.nil();
            msym.directives = directives.toList();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private void completeAutomaticModule(Symbol.ModuleSymbol msym) throws Symbol.CompletionFailure {
        ListBuffer<Directive> directives = new ListBuffer<Directive>();
        directives.addAll((Collection<Directive>)msym.directives);
        ListBuffer<Directive.RequiresDirective> requires = new ListBuffer<Directive.RequiresDirective>();
        for (Symbol.ModuleSymbol ms : this.allModules()) {
            if (ms == this.syms.unnamedModule || ms == msym) continue;
            EnumSet<Directive.RequiresFlag> flags = (ms.flags_field & 0x10000000000000L) != 0L ? EnumSet.of(Directive.RequiresFlag.TRANSITIVE) : EnumSet.noneOf(Directive.RequiresFlag.class);
            Directive.RequiresDirective d = new Directive.RequiresDirective(ms, flags);
            directives.add(d);
            requires.add(d);
        }
        Directive.RequiresDirective requiresUnnamed = new Directive.RequiresDirective(this.syms.unnamedModule);
        directives.add(requiresUnnamed);
        requires.add(requiresUnnamed);
        msym.requires = requires.toList();
        msym.directives = directives.toList();
    }

    private Symbol.Completer getSourceCompleter(final JCTree.JCCompilationUnit tree) {
        return new Symbol.Completer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void complete(Symbol sym) throws Symbol.CompletionFailure {
                Symbol.ModuleSymbol msym = (Symbol.ModuleSymbol)sym;
                msym.flags_field |= 0x10000000L;
                ModuleVisitor v = new ModuleVisitor();
                JavaFileObject prev = Modules.this.log.useSource(tree.sourcefile);
                JCTree.JCModuleDecl moduleDecl = tree.getModuleDecl();
                JCDiagnostic.DiagnosticPosition prevLintPos = Modules.this.deferredLintHandler.setPos(moduleDecl.pos());
                try {
                    moduleDecl.accept(v);
                    Modules.this.completeModule(msym);
                    Modules.this.checkCyclicDependencies(moduleDecl);
                }
                finally {
                    Modules.this.log.useSource(prev);
                    Modules.this.deferredLintHandler.setPos(prevLintPos);
                    msym.flags_field &= 0xFFFFFFFFEFFFFFFFL;
                }
            }

            public String toString() {
                return "SourceCompleter: " + tree.sourcefile.getName();
            }
        };
    }

    public boolean isRootModule(Symbol.ModuleSymbol module) {
        Assert.checkNonNull(this.rootModules);
        return this.rootModules.contains(module);
    }

    public Set<Symbol.ModuleSymbol> getRootModules() {
        Assert.checkNonNull(this.rootModules);
        return this.rootModules;
    }

    public Symbol.Completer getUsesProvidesCompleter() {
        return sym -> {
            Symbol.ModuleSymbol msym = (Symbol.ModuleSymbol)sym;
            msym.complete();
            Env<AttrContext> env = this.typeEnvs.get(msym);
            UsesProvidesVisitor v = new UsesProvidesVisitor(msym, env);
            JavaFileObject prev = this.log.useSource(env.toplevel.sourcefile);
            JCTree.JCModuleDecl decl = env.toplevel.getModuleDecl();
            JCDiagnostic.DiagnosticPosition prevLintPos = this.deferredLintHandler.setPos(decl.pos());
            try {
                decl.accept(v);
            }
            finally {
                this.log.useSource(prev);
                this.deferredLintHandler.setPos(prevLintPos);
            }
        };
    }

    public Set<Symbol.ModuleSymbol> allModules() {
        Assert.checkNonNull(this.allModules);
        return this.allModules;
    }

    private void setupAllModules() {
        String incubatingModules;
        Object noIncubatorPred;
        Set<Symbol.ModuleSymbol> observable;
        Assert.checkNonNull(this.rootModules);
        Assert.checkNull(this.allModules);
        this.syms.java_base.complete();
        if (this.limitModsOpt == null && this.extraLimitMods.isEmpty()) {
            observable = null;
        } else {
            HashSet<Symbol.ModuleSymbol> limitMods = new HashSet<Symbol.ModuleSymbol>();
            if (this.limitModsOpt != null) {
                for (String limit : this.limitModsOpt.split(",")) {
                    if (!this.isValidName(limit)) continue;
                    limitMods.add(this.syms.enterModule(this.names.fromString(limit)));
                }
            }
            for (String limit : this.extraLimitMods) {
                limitMods.add(this.syms.enterModule(this.names.fromString(limit)));
            }
            observable = this.computeTransitiveClosure(limitMods, this.rootModules, null);
            observable.addAll(this.rootModules);
            if (this.lintOptions) {
                for (Symbol.ModuleSymbol msym2 : limitMods) {
                    if (observable.contains(msym2)) continue;
                    this.log.warning(Lint.LintCategory.OPTIONS, CompilerProperties.Warnings.ModuleForOptionNotFound(Option.LIMIT_MODULES, msym2));
                }
            }
        }
        Predicate<Symbol.ModuleSymbol> observablePred = sym -> observable == null ? this.moduleFinder.findModule((Symbol.ModuleSymbol)sym).kind != Kinds.Kind.ERR : observable.contains(sym);
        Predicate<Symbol.ModuleSymbol> systemModulePred = sym -> (sym.flags() & 0x20000000000000L) != 0L;
        LinkedHashSet<Symbol.ModuleSymbol> enabledRoot = new LinkedHashSet<Symbol.ModuleSymbol>();
        if (this.rootModules.contains(this.syms.unnamedModule)) {
            Predicate<Symbol.ModuleSymbol> jdkModulePred;
            if (this.target.allApiModulesAreRoots()) {
                jdkModulePred = sym -> {
                    sym.complete();
                    return sym.exports.stream().anyMatch(e -> e.modules == null);
                };
            } else {
                Symbol.ModuleSymbol javaSE = this.syms.getModule(this.java_se);
                if (javaSE != null && (observable == null || observable.contains(javaSE))) {
                    jdkModulePred = sym -> {
                        sym.complete();
                        return !sym.name.startsWith(this.java_) && sym.exports.stream().anyMatch(e -> e.modules == null);
                    };
                    enabledRoot.add(javaSE);
                } else {
                    jdkModulePred = sym -> true;
                }
            }
            noIncubatorPred = sym -> {
                sym.complete();
                return !sym.resolutionFlags.contains((Object)Symbol.ModuleResolutionFlags.DO_NOT_RESOLVE_BY_DEFAULT);
            };
            for (Symbol.ModuleSymbol sym2 : new HashSet<Symbol.ModuleSymbol>(this.syms.getAllModules())) {
                try {
                    if (!systemModulePred.test(sym2) || !observablePred.test(sym2) || !jdkModulePred.test(sym2) || !noIncubatorPred.test(sym2)) continue;
                    enabledRoot.add(sym2);
                }
                catch (Symbol.CompletionFailure ex) {
                    this.chk.completionError(null, ex);
                }
            }
        }
        enabledRoot.addAll(this.rootModules);
        if (this.addModsOpt != null || !this.extraAddMods.isEmpty()) {
            HashSet<String> fullAddMods = new HashSet<String>();
            fullAddMods.addAll(this.extraAddMods);
            if (this.addModsOpt != null) {
                fullAddMods.addAll(Arrays.asList(this.addModsOpt.split(",")));
            }
            noIncubatorPred = fullAddMods.iterator();
            block14: while (noIncubatorPred.hasNext()) {
                Stream<Symbol.ModuleSymbol> modules;
                String added;
                switch (added = (String)noIncubatorPred.next()) {
                    case "ALL-SYSTEM": {
                        modules = new HashSet<Symbol.ModuleSymbol>(this.syms.getAllModules()).stream().filter(systemModulePred.and(observablePred));
                        break;
                    }
                    case "ALL-MODULE-PATH": {
                        modules = new HashSet<Symbol.ModuleSymbol>(this.syms.getAllModules()).stream().filter(systemModulePred.negate().and(observablePred));
                        break;
                    }
                    default: {
                        if (!this.isValidName(added)) continue block14;
                        modules = Stream.of(this.syms.enterModule(this.names.fromString(added)));
                    }
                }
                modules.forEach(sym -> {
                    enabledRoot.add((Symbol.ModuleSymbol)sym);
                    if (observable != null) {
                        observable.add((Symbol.ModuleSymbol)sym);
                    }
                });
            }
        }
        Set<Symbol.ModuleSymbol> result = this.computeTransitiveClosure(enabledRoot, this.rootModules, observable);
        result.add(this.syms.unnamedModule);
        boolean hasAutomatic = result.stream().anyMatch(IS_AUTOMATIC);
        if (hasAutomatic) {
            this.syms.getAllModules().stream().filter(IS_AUTOMATIC).forEach(result::add);
        }
        if (this.lint.isEnabled(Lint.LintCategory.INCUBATING) && (incubatingModules = this.filterAlreadyWarnedIncubatorModules(result.stream().filter(msym -> msym.resolutionFlags.contains((Object)Symbol.ModuleResolutionFlags.WARN_INCUBATING)).map(msym -> msym.name.toString())).collect(Collectors.joining(","))).length() != 0) {
            this.log.warning(CompilerProperties.Warnings.IncubatingModules(incubatingModules));
        }
        this.allModules = result;
        if (this.moduleVersionOpt != null) {
            Name version = this.names.fromString(this.moduleVersionOpt);
            this.rootModules.forEach(m -> {
                m.version = version;
            });
        }
    }

    private Stream<String> filterAlreadyWarnedIncubatorModules(Stream<String> incubatingModules) {
        if (!this.sourceLauncher) {
            return incubatingModules;
        }
        Set bootModules = ModuleWrapper.ModuleLayer.boot().modules().stream().map(ModuleWrapper::getName).collect(Collectors.toSet());
        return incubatingModules.filter(module -> !bootModules.contains(module));
    }

    public boolean isInModuleGraph(Symbol.ModuleSymbol msym) {
        return this.allModules == null || this.allModules.contains(msym);
    }

    /*
     * WARNING - void declaration
     */
    private Set<Symbol.ModuleSymbol> computeTransitiveClosure(Set<? extends Symbol.ModuleSymbol> base, Set<? extends Symbol.ModuleSymbol> rootModules, Set<Symbol.ModuleSymbol> observable) {
        List<Object> primaryTodo = List.nil();
        List<Object> secondaryTodo = List.nil();
        for (Symbol.ModuleSymbol moduleSymbol : base) {
            if (rootModules.contains(moduleSymbol)) {
                primaryTodo = primaryTodo.prepend(moduleSymbol);
                continue;
            }
            secondaryTodo = secondaryTodo.prepend(moduleSymbol);
        }
        LinkedHashSet<Symbol.ModuleSymbol> result = new LinkedHashSet<Symbol.ModuleSymbol>();
        result.add(this.syms.java_base);
        while (primaryTodo.nonEmpty() || secondaryTodo.nonEmpty()) {
            try {
                void var7_11;
                boolean isPrimaryTodo;
                if (primaryTodo.nonEmpty()) {
                    Symbol.ModuleSymbol moduleSymbol = (Symbol.ModuleSymbol)primaryTodo.head;
                    primaryTodo = primaryTodo.tail;
                    isPrimaryTodo = true;
                } else {
                    Symbol.ModuleSymbol moduleSymbol = (Symbol.ModuleSymbol)secondaryTodo.head;
                    secondaryTodo = secondaryTodo.tail;
                    isPrimaryTodo = false;
                }
                if (observable != null && !observable.contains(var7_11) || !result.add((Symbol.ModuleSymbol)var7_11) || var7_11 == this.syms.unnamedModule || (var7_11.flags_field & 0x10000000000000L) != 0L) continue;
                var7_11.complete();
                if (var7_11.kind == Kinds.Kind.ERR && (isPrimaryTodo || base.contains(var7_11)) && this.warnedMissing.add((Symbol.ModuleSymbol)var7_11)) {
                    this.log.error(CompilerProperties.Errors.ModuleNotFound((Symbol)var7_11));
                }
                for (Directive.RequiresDirective rd : var7_11.requires) {
                    if (rd.module == this.syms.java_base) continue;
                    if (rd.isTransitive() && isPrimaryTodo || rootModules.contains(var7_11)) {
                        primaryTodo = primaryTodo.prepend(rd.module);
                        continue;
                    }
                    secondaryTodo = secondaryTodo.prepend(rd.module);
                }
            }
            catch (Symbol.CompletionFailure completionFailure) {
                this.chk.completionError(null, completionFailure);
            }
        }
        return result;
    }

    public Symbol.ModuleSymbol getObservableModule(Name name) {
        Symbol.ModuleSymbol mod = this.syms.getModule(name);
        if (this.allModules().contains(mod)) {
            return mod;
        }
        return null;
    }

    private Symbol.Completer getUnnamedModuleCompleter() {
        this.moduleFinder.findAllModules();
        return new Symbol.Completer(){

            @Override
            public void complete(Symbol sym) throws Symbol.CompletionFailure {
                if (Modules.this.inInitModules) {
                    sym.completer = this;
                    return;
                }
                Symbol.ModuleSymbol msym = (Symbol.ModuleSymbol)sym;
                HashSet<Symbol.ModuleSymbol> allModules = new HashSet<Symbol.ModuleSymbol>(Modules.this.allModules());
                allModules.remove(((Modules)Modules.this).syms.unnamedModule);
                for (Symbol.ModuleSymbol m : allModules) {
                    m.complete();
                }
                Modules.this.initVisiblePackages(msym, allModules);
            }

            public String toString() {
                return "unnamedModule Completer";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeModule(Symbol.ModuleSymbol msym) {
        if (this.inInitModules) {
            msym.completer = sym -> this.completeModule(msym);
            return;
        }
        if ((msym.flags_field & 0x10000000000000L) != 0L) {
            this.completeAutomaticModule(msym);
        }
        Assert.checkNonNull(msym.requires);
        this.initAddReads();
        List<Directive.RequiresDirective> requires = msym.requires = msym.requires.appendList(List.from(this.addReads.getOrDefault(msym, Collections.emptySet())));
        while (requires.nonEmpty()) {
            if (!this.allModules().contains(((Directive.RequiresDirective)requires.head).module)) {
                Env<AttrContext> env = this.typeEnvs.get(msym);
                if (env != null) {
                    JavaFileObject origSource = this.log.useSource(env.toplevel.sourcefile);
                    try {
                        this.log.error(env.tree, CompilerProperties.Errors.ModuleNotFound(((Directive.RequiresDirective)requires.head).module));
                    }
                    finally {
                        this.log.useSource(origSource);
                    }
                } else {
                    Assert.check((msym.flags() & 0x10000000000000L) == 0L);
                }
                msym.requires = List.filter(msym.requires, (Directive.RequiresDirective)requires.head);
            }
            requires = requires.tail;
        }
        LinkedHashSet<Symbol.ModuleSymbol> readable = new LinkedHashSet<Symbol.ModuleSymbol>();
        HashSet<Symbol.ModuleSymbol> requiresTransitive = new HashSet<Symbol.ModuleSymbol>();
        for (Directive.RequiresDirective requiresDirective : msym.requires) {
            requiresDirective.module.complete();
            readable.add(requiresDirective.module);
            Set<Symbol.ModuleSymbol> s = this.retrieveRequiresTransitive(requiresDirective.module);
            Assert.checkNonNull(s, () -> "no entry in cache for " + d.module);
            readable.addAll(s);
            if (!requiresDirective.flags.contains((Object)Directive.RequiresFlag.TRANSITIVE)) continue;
            requiresTransitive.add(requiresDirective.module);
            requiresTransitive.addAll(s);
        }
        this.requiresTransitiveCache.put(msym, requiresTransitive);
        this.initVisiblePackages(msym, readable);
        for (Directive.ExportsDirective exportsDirective : msym.exports) {
            if (exportsDirective.packge == null) continue;
            exportsDirective.packge.modle = msym;
        }
    }

    private Set<Symbol.ModuleSymbol> retrieveRequiresTransitive(Symbol.ModuleSymbol msym) {
        Set<Symbol.ModuleSymbol> requiresTransitive = this.requiresTransitiveCache.get(msym);
        if (requiresTransitive == null) {
            requiresTransitive = new HashSet<Symbol.ModuleSymbol>();
            HashSet<Symbol.ModuleSymbol> seen = new HashSet<Symbol.ModuleSymbol>();
            List<Symbol.ModuleSymbol> todo = List.of(msym);
            while (todo.nonEmpty()) {
                Symbol.ModuleSymbol current = (Symbol.ModuleSymbol)todo.head;
                todo = todo.tail;
                if (!seen.add(current)) continue;
                requiresTransitive.add(current);
                current.complete();
                if (current != this.syms.unnamedModule) {
                    Assert.checkNonNull(current.requires, () -> current + ".requires == null; " + msym);
                    List<Directive.RequiresDirective> requires = current.requires;
                    for (Directive.RequiresDirective rd : requires) {
                        if (!rd.isTransitive()) continue;
                        todo = todo.prepend(rd.module);
                    }
                    continue;
                }
                for (Symbol.ModuleSymbol mod : this.allModules()) {
                    todo = todo.prepend(mod);
                }
            }
            requiresTransitive.remove(msym);
        }
        return requiresTransitive;
    }

    private void initVisiblePackages(Symbol.ModuleSymbol msym, Collection<Symbol.ModuleSymbol> readable) {
        this.initAddExports();
        msym.visiblePackages = new LinkedHashMap<Name, Symbol.PackageSymbol>();
        msym.readModules = new HashSet<Symbol.ModuleSymbol>(readable);
        HashMap<Name, Symbol.ModuleSymbol> seen = new HashMap<Name, Symbol.ModuleSymbol>();
        for (Symbol.ModuleSymbol rm : readable) {
            if (rm == this.syms.unnamedModule) continue;
            this.addVisiblePackages(msym, seen, rm, rm.exports);
        }
        this.addExports.forEach((exportsFrom, exports) -> {
            if (msym.readModules.contains(exportsFrom)) {
                this.addVisiblePackages(msym, (Map<Name, Symbol.ModuleSymbol>)seen, (Symbol.ModuleSymbol)exportsFrom, (Collection<Directive.ExportsDirective>)exports);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addVisiblePackages(Symbol.ModuleSymbol msym, Map<Name, Symbol.ModuleSymbol> seenPackages, Symbol.ModuleSymbol exportsFrom, Collection<Directive.ExportsDirective> exports) {
        for (Directive.ExportsDirective d : exports) {
            if (d.modules != null && !d.modules.contains(msym)) continue;
            Name packageName = d.packge.fullname;
            Symbol.ModuleSymbol previousModule = seenPackages.get(packageName);
            if (previousModule != null && previousModule != exportsFrom) {
                Env<AttrContext> env = this.typeEnvs.get(msym);
                JavaFileObject origSource = env != null ? this.log.useSource(env.toplevel.sourcefile) : null;
                JCDiagnostic.DiagnosticPosition pos = env != null ? env.tree.pos() : null;
                try {
                    if (msym.isUnnamed()) {
                        this.log.error(pos, CompilerProperties.Errors.PackageClashFromRequiresInUnnamed(packageName, previousModule, exportsFrom));
                        continue;
                    }
                    this.log.error(pos, CompilerProperties.Errors.PackageClashFromRequires(msym, packageName, previousModule, exportsFrom));
                    continue;
                }
                finally {
                    if (env != null) {
                        this.log.useSource(origSource);
                    }
                    continue;
                }
            }
            seenPackages.put(packageName, exportsFrom);
            msym.visiblePackages.put(d.packge.fullname, d.packge);
        }
    }

    private void initAddExports() {
        if (this.addExports != null) {
            return;
        }
        this.addExports = new LinkedHashMap<Symbol.ModuleSymbol, Set<Directive.ExportsDirective>>();
        HashSet<Symbol.ModuleSymbol> unknownModules = new HashSet<Symbol.ModuleSymbol>();
        if (this.addExportsOpt == null) {
            return;
        }
        Pattern ep = Pattern.compile("([^/]+)/([^=]+)=(.*)");
        for (String s : this.addExportsOpt.split("\u0000+")) {
            Symbol.ModuleSymbol msym;
            Matcher em;
            if (s.length() == 0 || !(em = ep.matcher(s)).matches()) continue;
            String moduleName = em.group(1);
            String packageName = em.group(2);
            String targetNames = em.group(3);
            if (!this.isValidName(moduleName) || !this.isKnownModule(msym = this.syms.enterModule(this.names.fromString(moduleName)), unknownModules) || !this.isValidName(packageName)) continue;
            if (!this.allowAccessIntoSystem && (msym.flags() & 0x20000000000000L) != 0L) {
                this.log.error(CompilerProperties.Errors.AddExportsWithRelease(msym));
                continue;
            }
            Symbol.PackageSymbol p = this.syms.enterPackage(msym, this.names.fromString(packageName));
            p.modle = msym;
            List<Symbol.ModuleSymbol> targetModules = List.nil();
            for (String toModule : targetNames.split("[ ,]+")) {
                Symbol.ModuleSymbol m;
                if (toModule.equals("ALL-UNNAMED")) {
                    m = this.syms.unnamedModule;
                } else if (!this.isValidName(toModule) || !this.isKnownModule(m = this.syms.enterModule(this.names.fromString(toModule)), unknownModules)) continue;
                targetModules = targetModules.prepend(m);
            }
            Set extra = this.addExports.computeIfAbsent(msym, _x -> new LinkedHashSet());
            Directive.ExportsDirective d = new Directive.ExportsDirective(p, targetModules);
            extra.add(d);
        }
    }

    private boolean isKnownModule(Symbol.ModuleSymbol msym, Set<Symbol.ModuleSymbol> unknownModules) {
        if (this.allModules.contains(msym)) {
            return true;
        }
        if (!unknownModules.contains(msym)) {
            if (this.lintOptions) {
                this.log.warning(Lint.LintCategory.OPTIONS, CompilerProperties.Warnings.ModuleForOptionNotFound(Option.ADD_EXPORTS, msym));
            }
            unknownModules.add(msym);
        }
        return false;
    }

    private void initAddReads() {
        if (this.addReads != null) {
            return;
        }
        this.addReads = new LinkedHashMap<Symbol.ModuleSymbol, Set<Directive.RequiresDirective>>();
        if (this.addReadsOpt == null) {
            return;
        }
        Pattern rp = Pattern.compile("([^=]+)=(.*)");
        for (String s : this.addReadsOpt.split("\u0000+")) {
            Matcher rm;
            if (s.length() == 0 || !(rm = rp.matcher(s)).matches()) continue;
            String sourceName = rm.group(1);
            String targetNames = rm.group(2);
            if (!this.isValidName(sourceName)) continue;
            Symbol.ModuleSymbol msym = this.syms.enterModule(this.names.fromString(sourceName));
            if (!this.allModules.contains(msym)) {
                if (!this.lintOptions) continue;
                this.log.warning(CompilerProperties.Warnings.ModuleForOptionNotFound(Option.ADD_READS, msym));
                continue;
            }
            if (!this.allowAccessIntoSystem && (msym.flags() & 0x20000000000000L) != 0L) {
                this.log.error(CompilerProperties.Errors.AddReadsWithRelease(msym));
                continue;
            }
            for (String targetName : targetNames.split("[ ,]+", -1)) {
                Symbol.ModuleSymbol targetModule;
                if (targetName.equals("ALL-UNNAMED")) {
                    targetModule = this.syms.unnamedModule;
                } else {
                    if (!this.isValidName(targetName)) continue;
                    targetModule = this.syms.enterModule(this.names.fromString(targetName));
                    if (!this.allModules.contains(targetModule)) {
                        if (!this.lintOptions) continue;
                        this.log.warning(Lint.LintCategory.OPTIONS, CompilerProperties.Warnings.ModuleForOptionNotFound(Option.ADD_READS, targetModule));
                        continue;
                    }
                }
                this.addReads.computeIfAbsent(msym, m -> new HashSet()).add(new Directive.RequiresDirective(targetModule, EnumSet.of(Directive.RequiresFlag.EXTRA)));
            }
        }
    }

    private void checkCyclicDependencies(JCTree.JCModuleDecl mod) {
        for (JCTree.JCDirective d : mod.directives) {
            if (!d.hasTag(JCTree.Tag.REQUIRES)) continue;
            JCTree.JCRequires rd = (JCTree.JCRequires)d;
            if (rd.directive == null) continue;
            HashSet<Symbol.ModuleSymbol> nonSyntheticDeps = new HashSet<Symbol.ModuleSymbol>();
            List<Symbol.ModuleSymbol> queue = List.of(rd.directive.module);
            while (queue.nonEmpty()) {
                Symbol.ModuleSymbol current = (Symbol.ModuleSymbol)queue.head;
                queue = queue.tail;
                if (!nonSyntheticDeps.add(current)) continue;
                current.complete();
                if ((current.flags() & 0x10000000000000L) != 0L) continue;
                Assert.checkNonNull(current.requires, current::toString);
                for (Directive.RequiresDirective dep : current.requires) {
                    if (dep.flags.contains((Object)Directive.RequiresFlag.EXTRA)) continue;
                    queue = queue.prepend(dep.module);
                }
            }
            if (!nonSyntheticDeps.contains(mod.sym)) continue;
            this.log.error(rd.moduleName.pos(), CompilerProperties.Errors.CyclicRequires(rd.directive.module));
        }
    }

    private boolean isValidName(CharSequence name) {
        return SourceVersion.isName(name, Source.toSourceVersion(this.source));
    }

    private String toString(Symbol.ModuleSymbol msym) {
        return msym.name + "[kind:" + (Object)((Object)msym.kind) + ";locn:" + this.toString(msym.sourceLocation) + "," + this.toString(msym.classLocation) + ";info:" + this.toString(msym.module_info.sourcefile) + "," + this.toString(msym.module_info.classfile) + "," + msym.module_info.completer + "]";
    }

    String toString(JavaFileManager.Location locn) {
        return locn == null ? "--" : locn.getName();
    }

    String toString(JavaFileObject fo) {
        return fo == null ? "--" : fo.getName();
    }

    public void newRound() {
        this.allModules = null;
        this.rootModules = null;
        this.defaultModule = null;
        this.warnedMissing.clear();
    }

    class UsesProvidesVisitor
    extends JCTree.Visitor {
        private final Symbol.ModuleSymbol msym;
        private final Env<AttrContext> env;
        private final Set<Symbol.ClassSymbol> allUses = new HashSet<Symbol.ClassSymbol>();
        private final Map<Symbol.ClassSymbol, Set<Symbol.ClassSymbol>> allProvides = new HashMap<Symbol.ClassSymbol, Set<Symbol.ClassSymbol>>();
        Map<Directive.ProvidesDirective, JCTree.JCProvides> directiveToTreeMap = new HashMap<Directive.ProvidesDirective, JCTree.JCProvides>();

        public UsesProvidesVisitor(Symbol.ModuleSymbol msym, Env<AttrContext> env) {
            this.msym = msym;
            this.env = env;
        }

        @Override
        public void visitModuleDef(JCTree.JCModuleDecl tree) {
            this.msym.directives = List.nil();
            this.msym.provides = List.nil();
            this.msym.uses = List.nil();
            tree.directives.forEach(t -> t.accept(this));
            this.msym.directives = this.msym.directives.reverse();
            this.msym.provides = this.msym.provides.reverse();
            this.msym.uses = this.msym.uses.reverse();
            if (this.msym.requires.nonEmpty() && ((Directive.RequiresDirective)this.msym.requires.head).flags.contains((Object)Directive.RequiresFlag.MANDATED)) {
                this.msym.directives = this.msym.directives.prepend((Directive)this.msym.requires.head);
            }
            this.msym.directives = this.msym.directives.appendList(List.from(Modules.this.addReads.getOrDefault(this.msym, Collections.emptySet())));
            this.checkForCorrectness();
        }

        @Override
        public void visitExports(JCTree.JCExports tree) {
            Iterable<Symbol> packageContent = tree.directive.packge.members().getSymbols();
            List<JavaFileObject> filesToCheck = List.nil();
            boolean packageNotEmpty = false;
            for (Symbol sym : packageContent) {
                if (sym.kind != Kinds.Kind.TYP) continue;
                Symbol.ClassSymbol csym = (Symbol.ClassSymbol)sym;
                if (sym.completer.isTerminal() || csym.classfile.getKind() == JavaFileObject.Kind.CLASS) {
                    packageNotEmpty = true;
                    filesToCheck = List.nil();
                    break;
                }
                if (csym.classfile.getKind() != JavaFileObject.Kind.SOURCE) continue;
                filesToCheck = filesToCheck.prepend(csym.classfile);
            }
            for (JavaFileObject jfo : filesToCheck) {
                if (Modules.this.findPackageInFile.findPackageNameOf(jfo) != tree.directive.packge.fullname) continue;
                packageNotEmpty = true;
                break;
            }
            if (!packageNotEmpty) {
                Modules.this.log.error(tree.qualid.pos(), CompilerProperties.Errors.PackageEmptyOrNotFound(tree.directive.packge));
            }
            this.msym.directives = this.msym.directives.prepend(tree.directive);
        }

        @Override
        public void visitOpens(JCTree.JCOpens tree) {
            Modules.this.chk.checkPackageExistsForOpens(tree.qualid, tree.directive.packge);
            this.msym.directives = this.msym.directives.prepend(tree.directive);
        }

        Symbol.MethodSymbol noArgsConstructor(Symbol.ClassSymbol tsym) {
            for (Symbol sym : tsym.members().getSymbolsByName(((Modules)Modules.this).names.init)) {
                Symbol.MethodSymbol mSym = (Symbol.MethodSymbol)sym;
                if (!mSym.params().isEmpty()) continue;
                return mSym;
            }
            return null;
        }

        Symbol.MethodSymbol factoryMethod(Symbol.ClassSymbol tsym) {
            for (Symbol sym2 : tsym.members().getSymbolsByName(((Modules)Modules.this).names.provider, sym -> sym.kind == Kinds.Kind.MTH)) {
                Symbol.MethodSymbol mSym = (Symbol.MethodSymbol)sym2;
                if (!mSym.isStatic() || (mSym.flags() & 1L) == 0L || !mSym.params().isEmpty()) continue;
                return mSym;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitProvides(JCTree.JCProvides tree) {
            Type st = Modules.this.attr.attribType(tree.serviceName, this.env, ((Modules)Modules.this).syms.objectType);
            Symbol.ClassSymbol service = (Symbol.ClassSymbol)st.tsym;
            if (this.allProvides.containsKey(service)) {
                Modules.this.log.error(tree.serviceName.pos(), CompilerProperties.Errors.RepeatedProvidesForService(service));
            }
            ListBuffer<Symbol.ClassSymbol> impls = new ListBuffer<Symbol.ClassSymbol>();
            for (JCTree.JCExpression implName : tree.implNames) {
                Symbol.MethodSymbol factory;
                Type it;
                boolean prevVisitingServiceImplementation = ((AttrContext)this.env.info).visitingServiceImplementation;
                try {
                    ((AttrContext)this.env.info).visitingServiceImplementation = true;
                    it = Modules.this.attr.attribType(implName, this.env, ((Modules)Modules.this).syms.objectType);
                }
                finally {
                    ((AttrContext)this.env.info).visitingServiceImplementation = prevVisitingServiceImplementation;
                }
                if (!it.hasTag(TypeTag.CLASS)) continue;
                Symbol.ClassSymbol impl = (Symbol.ClassSymbol)it.tsym;
                if ((impl.flags_field & 1L) == 0L) {
                    Modules.this.log.error(implName.pos(), CompilerProperties.Errors.NotDefPublic(impl, impl.location()));
                }
                if ((factory = this.factoryMethod(impl)) != null) {
                    Type returnType = factory.type.getReturnType();
                    if (!Modules.this.types.isSubtype(returnType, st)) {
                        Modules.this.log.error(implName.pos(), CompilerProperties.Errors.ServiceImplementationProviderReturnMustBeSubtypeOfServiceInterface);
                    }
                } else if (!Modules.this.types.isSubtype(it, st)) {
                    Modules.this.log.error(implName.pos(), CompilerProperties.Errors.ServiceImplementationMustBeSubtypeOfServiceInterface);
                } else if ((impl.flags() & 0x400L) != 0L) {
                    Modules.this.log.error(implName.pos(), CompilerProperties.Errors.ServiceImplementationIsAbstract(impl));
                } else if (impl.isInner()) {
                    Modules.this.log.error(implName.pos(), CompilerProperties.Errors.ServiceImplementationIsInner(impl));
                } else {
                    Symbol.MethodSymbol constr = this.noArgsConstructor(impl);
                    if (constr == null) {
                        Modules.this.log.error(implName.pos(), CompilerProperties.Errors.ServiceImplementationDoesntHaveANoArgsConstructor(impl));
                    } else if ((constr.flags() & 1L) == 0L) {
                        Modules.this.log.error(implName.pos(), CompilerProperties.Errors.ServiceImplementationNoArgsConstructorNotPublic(impl));
                    }
                }
                if (!it.hasTag(TypeTag.CLASS)) continue;
                if (this.allProvides.computeIfAbsent(service, s -> new HashSet()).add(impl)) {
                    impls.append(impl);
                    continue;
                }
                Modules.this.log.error(implName.pos(), CompilerProperties.Errors.DuplicateProvides(service, impl));
            }
            if (st.hasTag(TypeTag.CLASS) && !impls.isEmpty()) {
                Directive.ProvidesDirective d = new Directive.ProvidesDirective(service, impls.toList());
                this.msym.provides = this.msym.provides.prepend(d);
                this.msym.directives = this.msym.directives.prepend(d);
                this.directiveToTreeMap.put(d, tree);
            }
        }

        @Override
        public void visitRequires(JCTree.JCRequires tree) {
            if (tree.directive != null && Modules.this.allModules().contains(tree.directive.module)) {
                Modules.this.chk.checkDeprecated(tree.moduleName.pos(), (Symbol)this.msym, (Symbol)tree.directive.module);
                Modules.this.chk.checkPreview(tree.moduleName.pos(), this.msym, tree.directive.module);
                Modules.this.chk.checkModuleRequires(tree.moduleName.pos(), tree.directive);
                this.msym.directives = this.msym.directives.prepend(tree.directive);
            }
        }

        @Override
        public void visitUses(JCTree.JCUses tree) {
            Type st = Modules.this.attr.attribType(tree.qualid, this.env, ((Modules)Modules.this).syms.objectType);
            Symbol sym = TreeInfo.symbol(tree.qualid);
            if ((sym.flags() & 0x4000L) != 0L) {
                Modules.this.log.error(tree.qualid.pos(), CompilerProperties.Errors.ServiceDefinitionIsEnum(st.tsym));
            } else if (st.hasTag(TypeTag.CLASS)) {
                Symbol.ClassSymbol service = (Symbol.ClassSymbol)st.tsym;
                if (this.allUses.add(service)) {
                    Directive.UsesDirective d = new Directive.UsesDirective(service);
                    this.msym.uses = this.msym.uses.prepend(d);
                    this.msym.directives = this.msym.directives.prepend(d);
                } else {
                    Modules.this.log.error(tree.pos(), CompilerProperties.Errors.DuplicateUses(service));
                }
            }
        }

        private void checkForCorrectness() {
            for (Directive.ProvidesDirective provides : this.msym.provides) {
                JCTree.JCProvides tree = this.directiveToTreeMap.get(provides);
                for (Symbol.ClassSymbol impl : provides.impls) {
                    boolean isInterfaceExportedFromAReadableModule;
                    Symbol.PackageSymbol implementationDefiningPackage = impl.packge();
                    if (implementationDefiningPackage.modle != this.msym) {
                        Modules.this.log.error(tree.pos(), CompilerProperties.Errors.ServiceImplementationNotInRightModule(implementationDefiningPackage.modle));
                    }
                    Symbol.PackageSymbol interfaceDeclaringPackage = provides.service.packge();
                    boolean isInterfaceDeclaredInCurrentModule = interfaceDeclaringPackage.modle == this.msym;
                    boolean bl = isInterfaceExportedFromAReadableModule = this.msym.visiblePackages.get(interfaceDeclaringPackage.fullname) == interfaceDeclaringPackage;
                    if (!isInterfaceDeclaredInCurrentModule || isInterfaceExportedFromAReadableModule) continue;
                    boolean warn = true;
                    for (Directive.ExportsDirective export : this.msym.exports) {
                        if (interfaceDeclaringPackage != export.packge) continue;
                        warn = false;
                        break;
                    }
                    if (warn) {
                        for (Directive.UsesDirective uses : this.msym.uses) {
                            if (provides.service != uses.service) continue;
                            warn = false;
                            break;
                        }
                    }
                    if (!warn) continue;
                    Modules.this.log.warning(tree.pos(), CompilerProperties.Warnings.ServiceProvidedButNotExportedOrUsed(provides.service));
                }
            }
        }
    }

    public static interface PackageNameFinder {
        public Name findPackageNameOf(JavaFileObject var1);
    }

    class ModuleVisitor
    extends JCTree.Visitor {
        private Symbol.ModuleSymbol sym;
        private final Set<Symbol.ModuleSymbol> allRequires = new HashSet<Symbol.ModuleSymbol>();
        private final Map<Symbol.PackageSymbol, List<Directive.ExportsDirective>> allExports = new HashMap<Symbol.PackageSymbol, List<Directive.ExportsDirective>>();
        private final Map<Symbol.PackageSymbol, List<Directive.OpensDirective>> allOpens = new HashMap<Symbol.PackageSymbol, List<Directive.OpensDirective>>();

        ModuleVisitor() {
        }

        @Override
        public void visitModuleDef(JCTree.JCModuleDecl tree) {
            this.sym = Assert.checkNonNull(tree.sym);
            if (tree.getModuleType() == ModuleTree.ModuleKind.OPEN) {
                this.sym.flags.add(Symbol.ModuleFlags.OPEN);
            }
            this.sym.flags_field |= tree.mods.flags & 0x20000L;
            this.sym.requires = List.nil();
            this.sym.exports = List.nil();
            this.sym.opens = List.nil();
            tree.directives.forEach(t -> t.accept(this));
            this.sym.requires = this.sym.requires.reverse();
            this.sym.exports = this.sym.exports.reverse();
            this.sym.opens = this.sym.opens.reverse();
            this.ensureJavaBase();
        }

        @Override
        public void visitRequires(JCTree.JCRequires tree) {
            Symbol.ModuleSymbol msym = this.lookupModule(tree.moduleName);
            if (msym.kind != Kinds.Kind.MDL) {
                Modules.this.log.error(tree.moduleName.pos(), CompilerProperties.Errors.ModuleNotFound(msym));
                Modules.this.warnedMissing.add(msym);
            } else if (this.allRequires.contains(msym)) {
                Modules.this.log.error(tree.moduleName.pos(), CompilerProperties.Errors.DuplicateRequires(msym));
            } else {
                Directive.RequiresDirective d;
                this.allRequires.add(msym);
                EnumSet<Directive.RequiresFlag> flags = EnumSet.noneOf(Directive.RequiresFlag.class);
                if (tree.isTransitive) {
                    if (msym == ((Modules)Modules.this).syms.java_base && Modules.this.source.compareTo(Source.JDK10) >= 0) {
                        Modules.this.log.error(tree.pos(), CompilerProperties.Errors.ModifierNotAllowedHere(((Modules)Modules.this).names.transitive));
                    } else {
                        flags.add(Directive.RequiresFlag.TRANSITIVE);
                    }
                }
                if (tree.isStaticPhase) {
                    if (msym == ((Modules)Modules.this).syms.java_base && Modules.this.source.compareTo(Source.JDK10) >= 0) {
                        Modules.this.log.error(tree.pos(), CompilerProperties.Errors.ModNotAllowedHere(EnumSet.of(Flags.Flag.STATIC)));
                    } else {
                        flags.add(Directive.RequiresFlag.STATIC_PHASE);
                    }
                }
                tree.directive = d = new Directive.RequiresDirective(msym, flags);
                this.sym.requires = this.sym.requires.prepend(d);
            }
        }

        @Override
        public void visitExports(JCTree.JCExports tree) {
            Name name = TreeInfo.fullName(tree.qualid);
            Symbol.PackageSymbol packge = Modules.this.syms.enterPackage(this.sym, name);
            Modules.this.attr.setPackageSymbols(tree.qualid, packge);
            List exportsForPackage = this.allExports.computeIfAbsent(packge, p -> List.nil());
            for (Directive.ExportsDirective d : exportsForPackage) {
                this.reportExportsConflict(tree, packge);
            }
            List toModules = null;
            if (tree.moduleNames != null) {
                LinkedHashSet<Symbol.ModuleSymbol> to = new LinkedHashSet<Symbol.ModuleSymbol>();
                for (JCTree.JCExpression n : tree.moduleNames) {
                    Symbol.ModuleSymbol msym = this.lookupModule(n);
                    Modules.this.chk.checkModuleExists(n.pos(), msym);
                    for (Directive.ExportsDirective d : exportsForPackage) {
                        this.checkDuplicateExportsToModule(n, msym, d);
                    }
                    if (to.add(msym)) continue;
                    this.reportExportsConflictToModule(n, msym);
                }
                toModules = List.from(to);
            }
            if (toModules == null || !toModules.isEmpty()) {
                EnumSet<Directive.ExportsFlag> flags = EnumSet.noneOf(Directive.ExportsFlag.class);
                Directive.ExportsDirective d = new Directive.ExportsDirective(packge, toModules, flags);
                this.sym.exports = this.sym.exports.prepend(d);
                tree.directive = d;
                this.allExports.put(packge, exportsForPackage.prepend(d));
            }
        }

        private void reportExportsConflict(JCTree.JCExports tree, Symbol.PackageSymbol packge) {
            Modules.this.log.error(tree.qualid.pos(), CompilerProperties.Errors.ConflictingExports(packge));
        }

        private void checkDuplicateExportsToModule(JCTree.JCExpression name, Symbol.ModuleSymbol msym, Directive.ExportsDirective d) {
            if (d.modules != null) {
                for (Symbol.ModuleSymbol other : d.modules) {
                    if (msym != other) continue;
                    this.reportExportsConflictToModule(name, msym);
                }
            }
        }

        private void reportExportsConflictToModule(JCTree.JCExpression name, Symbol.ModuleSymbol msym) {
            Modules.this.log.error(name.pos(), CompilerProperties.Errors.ConflictingExportsToModule(msym));
        }

        @Override
        public void visitOpens(JCTree.JCOpens tree) {
            Name name = TreeInfo.fullName(tree.qualid);
            Symbol.PackageSymbol packge = Modules.this.syms.enterPackage(this.sym, name);
            Modules.this.attr.setPackageSymbols(tree.qualid, packge);
            if (this.sym.flags.contains((Object)Symbol.ModuleFlags.OPEN)) {
                Modules.this.log.error(tree.pos(), CompilerProperties.Errors.NoOpensUnlessStrong);
            }
            List opensForPackage = this.allOpens.computeIfAbsent(packge, p -> List.nil());
            for (Directive.OpensDirective d : opensForPackage) {
                this.reportOpensConflict(tree, packge);
            }
            List toModules = null;
            if (tree.moduleNames != null) {
                LinkedHashSet<Symbol.ModuleSymbol> to = new LinkedHashSet<Symbol.ModuleSymbol>();
                for (JCTree.JCExpression n : tree.moduleNames) {
                    Symbol.ModuleSymbol msym = this.lookupModule(n);
                    Modules.this.chk.checkModuleExists(n.pos(), msym);
                    for (Directive.OpensDirective d : opensForPackage) {
                        this.checkDuplicateOpensToModule(n, msym, d);
                    }
                    if (to.add(msym)) continue;
                    this.reportOpensConflictToModule(n, msym);
                }
                toModules = List.from(to);
            }
            if (toModules == null || !toModules.isEmpty()) {
                EnumSet<Directive.OpensFlag> flags = EnumSet.noneOf(Directive.OpensFlag.class);
                Directive.OpensDirective d = new Directive.OpensDirective(packge, toModules, flags);
                this.sym.opens = this.sym.opens.prepend(d);
                tree.directive = d;
                this.allOpens.put(packge, opensForPackage.prepend(d));
            }
        }

        private void reportOpensConflict(JCTree.JCOpens tree, Symbol.PackageSymbol packge) {
            Modules.this.log.error(tree.qualid.pos(), CompilerProperties.Errors.ConflictingOpens(packge));
        }

        private void checkDuplicateOpensToModule(JCTree.JCExpression name, Symbol.ModuleSymbol msym, Directive.OpensDirective d) {
            if (d.modules != null) {
                for (Symbol.ModuleSymbol other : d.modules) {
                    if (msym != other) continue;
                    this.reportOpensConflictToModule(name, msym);
                }
            }
        }

        private void reportOpensConflictToModule(JCTree.JCExpression name, Symbol.ModuleSymbol msym) {
            Modules.this.log.error(name.pos(), CompilerProperties.Errors.ConflictingOpensToModule(msym));
        }

        @Override
        public void visitProvides(JCTree.JCProvides tree) {
        }

        @Override
        public void visitUses(JCTree.JCUses tree) {
        }

        private void ensureJavaBase() {
            Directive.RequiresDirective d2;
            if (this.sym.name == ((Modules)Modules.this).names.java_base) {
                return;
            }
            for (Directive.RequiresDirective d2 : this.sym.requires) {
                if (d2.module.name != ((Modules)Modules.this).names.java_base) continue;
                return;
            }
            Symbol.ModuleSymbol java_base = Modules.this.syms.enterModule(((Modules)Modules.this).names.java_base);
            d2 = new Directive.RequiresDirective(java_base, EnumSet.of(Directive.RequiresFlag.MANDATED));
            this.sym.requires = this.sym.requires.prepend(d2);
        }

        private Symbol.ModuleSymbol lookupModule(JCTree.JCExpression moduleName) {
            Name name = TreeInfo.fullName(moduleName);
            Symbol.ModuleSymbol msym = Modules.this.moduleFinder.findModule(name);
            TreeInfo.setSymbol(moduleName, msym);
            return msym;
        }
    }
}

