/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.adm;

import com.oracle.bmc.adm.ApplicationDependencyManagementClient;
import com.oracle.bmc.adm.model.CreateKnowledgeBaseDetails;
import com.oracle.bmc.adm.requests.CreateKnowledgeBaseRequest;
import com.oracle.bmc.adm.responses.CreateKnowledgeBaseResponse;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.responses.BmcResponse;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Optional;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.adm.Bundle;
import org.netbeans.modules.cloud.oracle.adm.CreateKnowledgeBaseDialog;
import org.netbeans.modules.cloud.oracle.adm.ErrorUtils;
import org.netbeans.modules.cloud.oracle.compartment.CompartmentItem;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.RequestProcessor;

public class CreateKnowledgeBaseAction
implements ActionListener {
    private final CompartmentItem context;

    public CreateKnowledgeBaseAction(CompartmentItem context) {
        this.context = context;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Optional<String> result = CreateKnowledgeBaseDialog.showDialog(this.context);
        if (!result.isPresent()) {
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_KBNameIsNotFilled()));
        }
        result.ifPresent(p -> RequestProcessor.getDefault().execute(() -> {
            ProgressHandle progressHandle = ProgressHandle.createHandle((String)Bundle.MSG_CreatingKnowledgeBase(p));
            progressHandle.start();
            try (ApplicationDependencyManagementClient client = new ApplicationDependencyManagementClient((BasicAuthenticationDetailsProvider)OCIManager.getDefault().getConfigProvider());){
                CreateKnowledgeBaseDetails params = CreateKnowledgeBaseDetails.builder().compartmentId(this.context.getKey().getValue()).displayName((String)result.get()).build();
                CreateKnowledgeBaseRequest request = CreateKnowledgeBaseRequest.builder().createKnowledgeBaseDetails(params).build();
                CreateKnowledgeBaseResponse response = client.createKnowledgeBase(request);
                int resultCode = response.get__httpStatusCode__();
                if (resultCode == 202) {
                    this.context.refresh();
                    String message = Bundle.MSG_KBCreated(result.get());
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)message));
                } else {
                    ErrorUtils.processError((BmcResponse)response, Bundle.MSG_KBNotCreated(result.get()));
                }
            }
            catch (BmcException e) {
                ErrorUtils.processError(e, Bundle.MSG_KBNotCreated(result.get()));
            }
            finally {
                progressHandle.finish();
            }
        }));
    }
}

