/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.Utils;
import org.openide.util.NbBundle;

public class LocalizationSupport {
    private static Map<Language, ResourceBundle> languageToBundle = new HashMap<Language, ResourceBundle>();

    public static String localize(Language language, String text) {
        ResourceBundle bundle;
        Feature bundleFeature;
        if (text == null) {
            return null;
        }
        if (!languageToBundle.containsKey(language) && (bundleFeature = language.getFeatureList().getFeature("BUNDLE")) != null) {
            String baseName = (String)bundleFeature.getValue();
            if (baseName != null) {
                try {
                    languageToBundle.put(language, NbBundle.getBundle((String)baseName));
                }
                catch (MissingResourceException e) {
                    Utils.notify(e);
                    languageToBundle.put(language, null);
                }
            } else {
                languageToBundle.put(language, null);
            }
        }
        if ((bundle = languageToBundle.get(language)) != null) {
            try {
                return bundle.getString(text);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return text;
    }
}

