/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.glassfish.common.GlassFishLogger;
import org.netbeans.modules.glassfish.common.GlassfishInstance;
import org.netbeans.modules.glassfish.common.LogViewMgr;
import org.netbeans.modules.glassfish.common.RestartTask;
import org.netbeans.modules.glassfish.common.status.WakeUpStateListener;
import org.netbeans.modules.glassfish.tooling.GlassFishStatus;
import org.netbeans.modules.glassfish.tooling.GlassFishStatusListener;
import org.netbeans.modules.glassfish.tooling.TaskEvent;
import org.netbeans.modules.glassfish.tooling.TaskState;
import org.netbeans.modules.glassfish.tooling.TaskStateListener;
import org.netbeans.modules.glassfish.tooling.data.GlassFishServer;
import org.netbeans.modules.glassfish.tooling.data.GlassFishStatusTask;
import org.openide.util.NbBundle;

public abstract class BasicTask<V>
implements Callable<V> {
    private static final Logger LOGGER = GlassFishLogger.get(BasicTask.class);
    public static final int DELAY = 250;
    public static final int START_TIMEOUT = 300000;
    public static final int STOP_TIMEOUT = 180000;
    public static final int START_ADMIN_PORT_TIMEOUT = 120000;
    public static final int RESTART_DELAY = 5000;
    public static final int PORT_CHECK_IDLE = 500;
    public static final TimeUnit TIMEUNIT = TimeUnit.MILLISECONDS;
    GlassfishInstance instance;
    protected TaskStateListener[] stateListener;
    protected String instanceName;
    protected volatile Thread taskThread;

    @Override
    public abstract V call();

    protected BasicTask(GlassfishInstance instance, TaskStateListener ... stateListener) {
        this.instance = instance;
        this.stateListener = stateListener;
        this.instanceName = instance.getProperty("displayName");
        this.taskThread = null;
    }

    protected void setTaskThread() {
        this.taskThread = Thread.currentThread();
    }

    protected void clearTaskThread() {
        this.taskThread = null;
    }

    protected StartStateListener prepareStartMonitoring(boolean profile) {
        StartStateListener listener = new StartStateListener(profile);
        if (GlassFishStatus.start((GlassFishServer)this.instance, (boolean)false, (GlassFishStatusListener)listener, (GlassFishStatus[])new GlassFishStatus[]{GlassFishStatus.ONLINE, GlassFishStatus.SHUTDOWN})) {
            GlassFishStatus.addCheckListener((GlassFishServer)this.instance, (GlassFishStatusListener)listener);
            return listener;
        }
        GlassFishStatus.removeListener((GlassFishServer)this.instance, (GlassFishStatusListener)listener);
        return null;
    }

    protected StartStateListener forceStartMonitoring(boolean profile) {
        StartStateListener listener = new StartStateListener(profile);
        if (GlassFishStatus.start((GlassFishServer)this.instance, (boolean)true, (GlassFishStatusListener)listener, (GlassFishStatus[])new GlassFishStatus[]{GlassFishStatus.OFFLINE, GlassFishStatus.ONLINE, GlassFishStatus.SHUTDOWN, GlassFishStatus.UNKNOWN})) {
            GlassFishStatus.addCheckListener((GlassFishServer)this.instance, (GlassFishStatusListener)listener);
            return listener;
        }
        return null;
    }

    protected ShutdownStateListener prepareShutdownMonitoring() {
        ShutdownStateListener listener = new ShutdownStateListener();
        if (GlassFishStatus.addListener((GlassFishServer)this.instance, (GlassFishStatusListener)listener, (boolean)true, (GlassFishStatus[])new GlassFishStatus[]{GlassFishStatus.OFFLINE})) {
            return listener;
        }
        GlassFishStatus.removeListener((GlassFishServer)this.instance, (GlassFishStatusListener)listener);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StateChange waitStartUp(boolean force, boolean profile) {
        StartStateListener listener;
        StartStateListener startStateListener = listener = force ? this.forceStartMonitoring(profile) : this.prepareStartMonitoring(profile);
        if (listener == null) {
            return new StateChange(this, TaskState.FAILED, TaskEvent.ILLEGAL_STATE, "BasicTask.waitShutDown.listenerError", this.instanceName);
        }
        long start = System.currentTimeMillis();
        LOGGER.log(Level.FINEST, NbBundle.getMessage(RestartTask.class, (String)"BasicTask.waitShutDown.waitingTime", (Object[])new Object[]{this.instanceName, Integer.toString(300000)}));
        try {
            StartStateListener startStateListener2 = listener;
            synchronized (startStateListener2) {
                while (!listener.isWakeUp() && System.currentTimeMillis() - start < 300000L) {
                    listener.wait(System.currentTimeMillis() - start);
                }
            }
        }
        catch (InterruptedException ie) {
            LOGGER.log(Level.INFO, NbBundle.getMessage(RestartTask.class, (String)"BasicTask.waitShutDown.interruptedException", (Object[])new Object[]{this.instance.getName(), ie.getLocalizedMessage()}));
        }
        finally {
            GlassFishStatus.removeListener((GlassFishServer)this.instance, (GlassFishStatusListener)listener);
        }
        if (!listener.isWakeUp()) {
            return new StateChange(this, TaskState.FAILED, TaskEvent.CMD_FAILED, "BasicTask.waitShutDown.timeout", this.instanceName, Integer.toString(180000));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StateChange waitShutDown() {
        ShutdownStateListener listener = this.prepareShutdownMonitoring();
        if (listener == null) {
            return new StateChange(this, TaskState.FAILED, TaskEvent.ILLEGAL_STATE, "BasicTask.waitShutDown.listenerError", this.instanceName);
        }
        long start = System.currentTimeMillis();
        LOGGER.log(Level.FINEST, NbBundle.getMessage(RestartTask.class, (String)"BasicTask.waitShutDown.waitingTime", (Object[])new Object[]{this.instanceName, Integer.toString(180000)}));
        try {
            ShutdownStateListener shutdownStateListener = listener;
            synchronized (shutdownStateListener) {
                while (!listener.isWakeUp() && System.currentTimeMillis() - start < 180000L) {
                    listener.wait(System.currentTimeMillis() - start);
                }
            }
        }
        catch (InterruptedException ie) {
            LOGGER.log(Level.INFO, NbBundle.getMessage(RestartTask.class, (String)"BasicTask.waitShutDown.interruptedException", (Object[])new Object[]{this.instance.getName(), ie.getLocalizedMessage()}));
        }
        finally {
            GlassFishStatus.removeListener((GlassFishServer)this.instance, (GlassFishStatusListener)listener);
        }
        LogViewMgr.removeLog(this.instance);
        LogViewMgr logger = LogViewMgr.getInstance(this.instance.getProperty("url"));
        logger.stopReaders();
        if (!listener.isWakeUp()) {
            return new StateChange(this, TaskState.FAILED, TaskEvent.CMD_FAILED, "BasicTask.waitShutDown.timeout", this.instanceName, Integer.toString(180000));
        }
        return null;
    }

    protected final TaskState fireOperationStateChanged(TaskState stateType, TaskEvent te, String resName, String ... args) {
        if (this.stateListener != null && this.stateListener.length > 0) {
            String msg = NbBundle.getMessage(BasicTask.class, (String)resName, (Object[])args);
            for (int i = 0; i < this.stateListener.length; ++i) {
                if (this.stateListener[i] == null) continue;
                this.stateListener[i].operationStateChanged(stateType, te, new String[]{msg});
            }
        }
        return stateType;
    }

    protected static class StartStateListener
    extends WakeUpStateListener {
        private final boolean profile;
        private volatile Process process;

        protected StartStateListener(boolean profile) {
            this.profile = profile;
            this.process = null;
        }

        void setProcess(Process process) {
            this.process = process;
        }

        public void currentState(GlassFishServer server, GlassFishStatus status, GlassFishStatusTask task) {
            switch (status) {
                case OFFLINE: 
                case STARTUP: {
                    if (!this.profile || this.process == null) break;
                    this.wakeUp();
                    break;
                }
                case ONLINE: 
                case SHUTDOWN: {
                    this.wakeUp();
                }
            }
        }
    }

    protected static class ShutdownStateListener
    extends WakeUpStateListener {
        protected ShutdownStateListener() {
        }

        public void currentState(GlassFishServer server, GlassFishStatus status, GlassFishStatusTask task) {
            if (status != GlassFishStatus.SHUTDOWN) {
                this.wakeUp();
            }
        }
    }

    protected static class StateChange {
        private final BasicTask<?> task;
        private final TaskState result;
        private final TaskEvent event;
        private final String msgKey;
        private final String[] msgArgs;

        protected StateChange(BasicTask<?> task, TaskState result, TaskEvent event, String msgKey) {
            this.task = task;
            this.result = result;
            this.event = event;
            this.msgKey = msgKey;
            this.msgArgs = null;
        }

        protected StateChange(BasicTask<?> task, TaskState result, TaskEvent event, String msgKey, String ... msgArgs) {
            this.task = task;
            this.result = result;
            this.event = event;
            this.msgKey = msgKey;
            this.msgArgs = msgArgs;
        }

        protected TaskState fireOperationStateChanged() {
            return this.task.fireOperationStateChanged(this.result, this.event, this.msgKey, this.msgArgs);
        }
    }
}

