/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.identity.model.ImportStandardTagsDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ImportStandardTagsRequest
extends BmcRequest<ImportStandardTagsDetails> {
    private String opcRequestId;
    private String opcRetryToken;
    private ImportStandardTagsDetails importStandardTagsDetails;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public ImportStandardTagsDetails getImportStandardTagsDetails() {
        return this.importStandardTagsDetails;
    }

    @InternalSdk
    public ImportStandardTagsDetails getBody$() {
        return this.importStandardTagsDetails;
    }

    public Builder toBuilder() {
        return new Builder().opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken).importStandardTagsDetails(this.importStandardTagsDetails);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",importStandardTagsDetails=").append(String.valueOf((Object)this.importStandardTagsDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImportStandardTagsRequest)) {
            return false;
        }
        ImportStandardTagsRequest other = (ImportStandardTagsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals((Object)this.importStandardTagsDetails, (Object)other.importStandardTagsDetails);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.importStandardTagsDetails == null ? 43 : this.importStandardTagsDetails.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ImportStandardTagsRequest, ImportStandardTagsDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;
        private ImportStandardTagsDetails importStandardTagsDetails = null;

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder importStandardTagsDetails(ImportStandardTagsDetails importStandardTagsDetails) {
            this.importStandardTagsDetails = importStandardTagsDetails;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ImportStandardTagsRequest o) {
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.importStandardTagsDetails(o.getImportStandardTagsDetails());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ImportStandardTagsRequest build() {
            ImportStandardTagsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ImportStandardTagsDetails body) {
            this.importStandardTagsDetails(body);
            return this;
        }

        public ImportStandardTagsRequest buildWithoutInvocationCallback() {
            ImportStandardTagsRequest request = new ImportStandardTagsRequest();
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            request.importStandardTagsDetails = this.importStandardTagsDetails;
            return request;
        }
    }
}

