/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetCommitDiffRequest
extends BmcRequest<Void> {
    private String repositoryId;
    private String targetVersion;
    private String baseVersion;
    private Boolean isComparisonFromMergeBase;
    private String opcRequestId;

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getTargetVersion() {
        return this.targetVersion;
    }

    public String getBaseVersion() {
        return this.baseVersion;
    }

    public Boolean getIsComparisonFromMergeBase() {
        return this.isComparisonFromMergeBase;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().repositoryId(this.repositoryId).targetVersion(this.targetVersion).baseVersion(this.baseVersion).isComparisonFromMergeBase(this.isComparisonFromMergeBase).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",repositoryId=").append(String.valueOf(this.repositoryId));
        sb.append(",targetVersion=").append(String.valueOf(this.targetVersion));
        sb.append(",baseVersion=").append(String.valueOf(this.baseVersion));
        sb.append(",isComparisonFromMergeBase=").append(String.valueOf(this.isComparisonFromMergeBase));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetCommitDiffRequest)) {
            return false;
        }
        GetCommitDiffRequest other = (GetCommitDiffRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.repositoryId, other.repositoryId) && Objects.equals(this.targetVersion, other.targetVersion) && Objects.equals(this.baseVersion, other.baseVersion) && Objects.equals(this.isComparisonFromMergeBase, other.isComparisonFromMergeBase) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.repositoryId == null ? 43 : this.repositoryId.hashCode());
        result = result * 59 + (this.targetVersion == null ? 43 : this.targetVersion.hashCode());
        result = result * 59 + (this.baseVersion == null ? 43 : this.baseVersion.hashCode());
        result = result * 59 + (this.isComparisonFromMergeBase == null ? 43 : this.isComparisonFromMergeBase.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetCommitDiffRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String repositoryId = null;
        private String targetVersion = null;
        private String baseVersion = null;
        private Boolean isComparisonFromMergeBase = null;
        private String opcRequestId = null;

        public Builder repositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            return this;
        }

        public Builder targetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
            return this;
        }

        public Builder baseVersion(String baseVersion) {
            this.baseVersion = baseVersion;
            return this;
        }

        public Builder isComparisonFromMergeBase(Boolean isComparisonFromMergeBase) {
            this.isComparisonFromMergeBase = isComparisonFromMergeBase;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetCommitDiffRequest o) {
            this.repositoryId(o.getRepositoryId());
            this.targetVersion(o.getTargetVersion());
            this.baseVersion(o.getBaseVersion());
            this.isComparisonFromMergeBase(o.getIsComparisonFromMergeBase());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetCommitDiffRequest build() {
            GetCommitDiffRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetCommitDiffRequest buildWithoutInvocationCallback() {
            GetCommitDiffRequest request = new GetCommitDiffRequest();
            request.repositoryId = this.repositoryId;
            request.targetVersion = this.targetVersion;
            request.baseVersion = this.baseVersion;
            request.isComparisonFromMergeBase = this.isComparisonFromMergeBase;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

