/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.api.actions;

import java.awt.event.ActionEvent;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.DataLoadersBridge;
import org.netbeans.modules.html.editor.api.actions.AbstractSourceElementAction;
import org.netbeans.modules.html.editor.api.actions.Bundle;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.parsing.spi.ParseException;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class DeleteElementAction
extends AbstractSourceElementAction {
    public DeleteElementAction(FileObject file, String elementPath) {
        super(file, elementPath);
        this.putValue("Name", Bundle.action_name_delete_element());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            AbstractSourceElementAction.SourceElementHandle handle = this.createSourceElementHandle();
            if (!handle.isResolved()) {
                return;
            }
            OpenTag tag = handle.getOpenTag();
            int from = tag.from();
            int to = tag.semanticEnd();
            final int ast_from = handle.getSnapshot().getOriginalOffset(from);
            final int ast_to = handle.getSnapshot().getOriginalOffset(to);
            final BaseDocument doc = (BaseDocument)DataLoadersBridge.getDefault().getDocument(this.file);
            if (doc == null) {
                return;
            }
            doc.runAtomicAsUser(new Runnable(){

                @Override
                public void run() {
                    try {
                        doc.remove(ast_from, ast_to - ast_from);
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

