/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.sunresources.wizards;

import java.awt.Component;
import java.io.InputStream;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.sun.api.restricted.ResourceUtils;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.CPPropertiesPanelPanel;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.CPVendor;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.CommonAttributePanel;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.CommonAttributeVisualPanel;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.CommonPropertyPanel;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.ConnPoolWizard;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.ResourceConfigHelper;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.ResourceConfigHelperHolder;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.Util;
import org.netbeans.modules.j2ee.sun.sunresources.beans.Wizard;
import org.netbeans.modules.j2ee.sun.sunresources.beans.WizardConstants;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class DataSourceWizard
implements WizardDescriptor.InstantiatingIterator,
ChangeListener,
WizardConstants {
    private Project project;
    private static final String DATAFILE = "org/netbeans/modules/j2ee/sun/sunresources/beans/DSWizard.xml";
    private static final String CP_DATAFILE = "org/netbeans/modules/j2ee/sun/sunresources/beans/CPWizard.xml";
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient String[] steps;
    private ResourceConfigHelper helper;
    private Wizard wizardInfo;
    private boolean addSteps = false;
    private ResourceConfigHelper cphelper;
    private ResourceConfigHelperHolder holder;
    private Wizard cpWizardInfo;
    private transient WizardDescriptor.Panel[] morePanels = null;
    private transient WizardDescriptor.Panel[] dsPanels = null;
    private transient String[] dsSteps = null;
    private transient String[] moreSteps = null;

    public static DataSourceWizard create() {
        return new DataSourceWizard();
    }

    private WizardDescriptor.Panel[] createPanels() {
        this.morePanels = null;
        CommonAttributePanel panel = new CommonAttributePanel(this.helper, this.wizardInfo, new String[]{"general"});
        panel.addChangeListener(this);
        return new WizardDescriptor.Panel[]{panel, new CommonPropertyPanel(this.helper, this.wizardInfo)};
    }

    private String[] createSteps() {
        return new String[]{NbBundle.getMessage(DataSourceWizard.class, (String)"Choose"), NbBundle.getMessage(DataSourceWizard.class, (String)"LBL_GeneralAttributes_DS"), NbBundle.getMessage(DataSourceWizard.class, (String)"LBL_AddProperty")};
    }

    public Set instantiate() {
        try {
            if (this.holder.hasCPHelper()) {
                String poolName = this.cphelper.getData().getString("name");
                this.helper.getData().setString("pool-name", poolName);
                this.cphelper.getData().setTargetFile(poolName);
                this.cphelper.getData().setTargetFileObject(this.helper.getData().getTargetFileObject());
                ResourceUtils.saveJDBCResourceDatatoXml(this.helper.getData(), this.cphelper.getData(), Util.getBaseName(this.project));
            } else {
                ResourceUtils.saveJDBCResourceDatatoXml(this.helper.getData(), null, Util.getBaseName(this.project));
            }
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return Collections.EMPTY_SET;
    }

    public void initialize(WizardDescriptor wiz) {
        this.wizardInfo = this.getWizardInfo(DATAFILE);
        this.holder = new ResourceConfigHelperHolder();
        this.helper = this.holder.getDataSourceHelper();
        wiz.putProperty("NewFileWizard_Title", (Object)NbBundle.getMessage(ConnPoolWizard.class, (String)"Templates/SunResources/JDBC_Resource"));
        this.index = 0;
        this.project = Templates.getProject((WizardDescriptor)wiz);
        this.panels = this.createPanels();
        this.steps = this.createSteps();
        try {
            FileObject pkgLocation = this.project.getProjectDirectory();
            if (pkgLocation != null) {
                this.helper.getData().setTargetFileObject(pkgLocation);
            }
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", this.steps);
        }
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.panels = null;
    }

    public Wizard getWizardInfo(String filePath) {
        try {
            InputStream in = Wizard.class.getClassLoader().getResourceAsStream(filePath);
            this.wizardInfo = Wizard.createGraph(in);
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return this.wizardInfo;
    }

    public String name() {
        return NbBundle.getMessage(DataSourceWizard.class, (String)"Templates/SunResources/JDBC_Resource");
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public synchronized void nextPanel() {
        if (this.index + 1 == this.panels.length) {
            throw new NoSuchElementException();
        }
        if (this.index == 0) {
            ((CommonPropertyPanel)this.panels[1]).setInitialFocus();
        } else if (this.index == 1) {
            ((CPVendor)this.panels[2]).setInitialFocus();
        } else if (this.index == 2) {
            ((CPPropertiesPanelPanel)this.panels[3]).refreshFields();
        } else if (this.index == 3) {
            ((CommonAttributePanel)this.panels[4]).setPropInitialFocus();
        }
        ++this.index;
    }

    public synchronized void previousPanel() {
        if (this.index == 0) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    public void setResourceConfigHelper(ResourceConfigHelper helper) {
        this.helper = helper;
    }

    public ResourceConfigHelper getResourceConfigHelper() {
        return this.helper;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource().getClass() == CommonAttributePanel.class || e.getSource().getClass() == CommonAttributeVisualPanel.class) {
            CommonAttributePanel commonPane = (CommonAttributePanel)this.current();
            CommonAttributeVisualPanel visPane = (CommonAttributeVisualPanel)commonPane.getComponent();
            boolean oldVal = this.addSteps;
            this.addSteps = visPane.isNewResourceSelected();
            if (!oldVal && this.addSteps || oldVal && !this.addSteps) {
                this.holder.setHasCPHelper(this.addSteps);
                if (this.addSteps && this.morePanels == null) {
                    this.addPanels();
                    this.addSteps();
                    for (int i = 0; i < this.panels.length; ++i) {
                        Component c = this.panels[i].getComponent();
                        if (this.steps[i] == null) {
                            this.steps[i] = c.getName();
                        }
                        if (!(c instanceof JComponent)) continue;
                        JComponent jc = (JComponent)c;
                        jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
                        jc.putClientProperty("WizardPanel_contentData", this.steps);
                    }
                } else if (!this.addSteps && this.morePanels != null) {
                    if (this.dsPanels != null) {
                        this.panels = this.dsPanels;
                        this.morePanels = null;
                    } else {
                        this.panels = this.createPanels();
                    }
                    this.steps = this.dsSteps != null ? this.dsSteps : this.createSteps();
                    for (int i = 0; i < this.panels.length; ++i) {
                        Component c = this.panels[i].getComponent();
                        if (this.steps[i] == null) {
                            this.steps[i] = c.getName();
                        }
                        if (!(c instanceof JComponent)) continue;
                        JComponent jc = (JComponent)c;
                        jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
                        jc.putClientProperty("WizardPanel_contentData", this.steps);
                    }
                    ((CommonAttributePanel)this.panels[0]).setInitialFocus();
                }
            }
        }
    }

    protected void addPanels() {
        if (this.panels != null && this.morePanels == null) {
            this.cphelper = this.holder.addAssociatedHelper();
            this.cphelper.getData().setResourceName("jdbc-connection-pool");
            this.holder.setHasCPHelper(true);
            this.cpWizardInfo = this.getWizardInfo(CP_DATAFILE);
            this.cphelper.getData().setTargetFileObject(this.helper.getData().getTargetFileObject());
            this.cphelper.getData().setString("dynamicPanel", "true");
            this.morePanels = new WizardDescriptor.Panel[]{this.panels[0], this.panels[1], new CPVendor(this.cphelper, this.cpWizardInfo), new CPPropertiesPanelPanel(this.cphelper, this.cpWizardInfo), new CommonAttributePanel(this.cphelper, this.cpWizardInfo, new String[]{"pool-setting", "pool-setting-2", "pool-setting-3"})};
        }
        this.dsPanels = this.panels;
        this.panels = this.morePanels;
    }

    protected void addSteps() {
        if (this.steps != null && this.moreSteps == null) {
            this.moreSteps = new String[]{this.steps[0], this.steps[1], this.steps[2], NbBundle.getMessage(DataSourceWizard.class, (String)"TITLE_ConnPoolWizardPanel_dbConn"), NbBundle.getMessage(DataSourceWizard.class, (String)"TITLE_ConnPoolWizardPanel_properties"), NbBundle.getMessage(DataSourceWizard.class, (String)"TITLE_ConnPoolWizardPanel_optionalProps")};
        }
        this.dsSteps = this.steps;
        this.steps = this.moreSteps;
    }
}

