/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.EventSetDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.modules.form.Event;
import org.netbeans.modules.form.FormEvents;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.wizard.ConnectionWizardPanel1;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class ConnectionPanel1
extends JPanel {
    private ConnectionWizardPanel1 wizardPanel;
    private JPanel eventHandlerPanel;
    private JComboBox eventNameCombo;
    private JLabel eventNameLabel;
    private JLabel eventSelectLabel;
    private JPanel eventSelectLabelPanel;
    private JScrollPane eventSelectScroll;
    private JTree eventSelectTree;
    private JTextField sourceComponentName;
    private JPanel sourceInfoPanel;
    private JLabel sourceNameLabel;
    private JPanel sourceNamePanel;
    private JPanel sourcePanel;

    ConnectionPanel1(ConnectionWizardPanel1 wizardPanel) {
        this.wizardPanel = wizardPanel;
        this.initComponents();
        RADComponent source = wizardPanel.getSourceComponent();
        ResourceBundle bundle = NbBundle.getBundle(ConnectionPanel1.class);
        this.setName(bundle.getString("CTL_CW_Step1_Title"));
        this.sourceComponentName.setText(source.getName());
        this.eventNameCombo.setEnabled(wizardPanel.getSelectedEvent() != null);
        this.eventNameCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectionPanel1.this.wizardPanel.fireStateChanged();
            }
        });
        this.eventNameCombo.getEditor().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectionPanel1.this.wizardPanel.fireStateChanged();
            }
        });
        final Vector<EventSetNode> eventNodes = new Vector<EventSetNode>();
        TreeNode rootNode = new TreeNode(){

            @Override
            public TreeNode getChildAt(int childIndex) {
                return (TreeNode)eventNodes.elementAt(childIndex);
            }

            @Override
            public int getChildCount() {
                return eventNodes.size();
            }

            @Override
            public TreeNode getParent() {
                return null;
            }

            @Override
            public int getIndex(TreeNode node) {
                return eventNodes.indexOf(node);
            }

            @Override
            public boolean getAllowsChildren() {
                return true;
            }

            @Override
            public boolean isLeaf() {
                return false;
            }

            public Enumeration children() {
                return eventNodes.elements();
            }
        };
        EventSetDescriptor lastEventSetDesc = null;
        EventSetNode eventSetNode = null;
        ArrayList<EventNode> eventSetEvents = null;
        Event[] events = source.getAllEvents();
        for (int i = 0; i < events.length; ++i) {
            Event event = events[i];
            EventSetDescriptor eventSetDesc = event.getEventSetDescriptor();
            if (eventSetDesc != lastEventSetDesc) {
                eventSetEvents = new ArrayList<EventNode>();
                eventSetNode = new EventSetNode(eventSetDesc.getName(), eventSetEvents);
                eventNodes.add(eventSetNode);
                lastEventSetDesc = eventSetDesc;
            }
            eventSetEvents.add(new EventNode(eventSetNode, event));
        }
        Collections.sort(eventNodes);
        DefaultTreeSelectionModel treeSelectionModel = new DefaultTreeSelectionModel();
        treeSelectionModel.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                TreeNode node;
                TreePath[] paths = ConnectionPanel1.this.eventSelectTree.getSelectionPaths();
                if (paths != null && paths.length == 1 && (node = (TreeNode)paths[0].getLastPathComponent()) != null && node instanceof EventNode) {
                    ConnectionPanel1.this.setSelectedEvent(((EventNode)node).getEvent());
                    return;
                }
                ConnectionPanel1.this.setSelectedEvent(null);
            }
        });
        treeSelectionModel.setSelectionMode(1);
        this.eventSelectTree.setModel(new DefaultTreeModel(rootNode));
        this.eventSelectTree.setSelectionModel(treeSelectionModel);
        Mnemonics.setLocalizedText((JLabel)this.sourceNameLabel, (String)bundle.getString("CTL_CW_SourceComponent"));
        this.sourceComponentName.setToolTipText(bundle.getString("CTL_CW_SourceComponent_Hint"));
        Mnemonics.setLocalizedText((JLabel)this.eventSelectLabel, (String)bundle.getString("CTL_CW_Event"));
        this.eventSelectTree.setToolTipText(bundle.getString("CTL_CW_Event_Hint"));
        this.sourcePanel.setToolTipText(bundle.getString("CTL_CW_Event_Hint"));
        this.eventHandlerPanel.setBorder(new CompoundBorder(new TitledBorder(new EtchedBorder(), bundle.getString("CTL_CW_EventHandlerMethod")), new EmptyBorder(new Insets(5, 5, 5, 5))));
        Mnemonics.setLocalizedText((JLabel)this.eventNameLabel, (String)bundle.getString("CTL_CW_MethodName"));
        this.eventSelectTree.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CW_EventTree"));
        this.eventNameCombo.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CW_MethodName"));
        this.sourceComponentName.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CW_SourceComponent"));
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CW_ConnectionPanel1"));
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(0));
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(450, 300);
    }

    String getEventName() {
        return (String)this.eventNameCombo.getEditor().getItem();
    }

    private void setSelectedEvent(Event event) {
        this.eventNameCombo.removeAllItems();
        if (event != null) {
            this.eventNameCombo.setEnabled(true);
            FormEvents formEvents = this.wizardPanel.getSourceComponent().getFormModel().getFormEvents();
            String defaultName = formEvents.findFreeHandlerName(event, this.wizardPanel.getSourceComponent());
            this.eventNameCombo.addItem(defaultName);
            if (event.hasEventHandlers()) {
                String[] handlers = event.getEventHandlers();
                for (int i = 0; i < handlers.length; ++i) {
                    this.eventNameCombo.addItem(handlers[i]);
                }
            }
            this.eventNameCombo.setSelectedIndex(0);
        } else {
            this.eventNameCombo.setEnabled(false);
        }
        this.wizardPanel.setSelectedEvent(event);
    }

    private void initComponents() {
        this.sourcePanel = new JPanel();
        this.sourceInfoPanel = new JPanel();
        this.sourceNamePanel = new JPanel();
        this.sourceNameLabel = new JLabel();
        this.sourceComponentName = new JTextField();
        this.eventSelectLabelPanel = new JPanel();
        this.eventSelectLabel = new JLabel();
        this.eventSelectScroll = new JScrollPane();
        this.eventSelectTree = new JTree();
        this.eventHandlerPanel = new JPanel();
        this.eventNameLabel = new JLabel();
        this.eventNameCombo = new JComboBox();
        this.setLayout(new BorderLayout(0, 11));
        this.sourcePanel.setLayout(new BorderLayout());
        this.sourceInfoPanel.setLayout(new GridLayout(2, 1));
        this.sourceNamePanel.setLayout(new FlowLayout(0, 0, 0));
        this.sourceNameLabel.setLabelFor(this.sourceComponentName);
        this.sourceNameLabel.setText("Source Component:");
        this.sourceNameLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 6));
        this.sourceNamePanel.add(this.sourceNameLabel);
        this.sourceComponentName.setEditable(false);
        this.sourceComponentName.setColumns(30);
        this.sourceNamePanel.add(this.sourceComponentName);
        this.sourceInfoPanel.add(this.sourceNamePanel);
        this.eventSelectLabelPanel.setLayout(new FlowLayout(0, 0, 3));
        this.eventSelectLabel.setLabelFor(this.eventSelectTree);
        this.eventSelectLabel.setText("Events");
        this.eventSelectLabelPanel.add(this.eventSelectLabel);
        this.sourceInfoPanel.add(this.eventSelectLabelPanel);
        this.sourcePanel.add((Component)this.sourceInfoPanel, "North");
        this.eventSelectScroll.setMaximumSize(new Dimension(Short.MAX_VALUE, 100));
        this.eventSelectTree.setRootVisible(false);
        this.eventSelectTree.setShowsRootHandles(true);
        this.eventSelectScroll.setViewportView(this.eventSelectTree);
        this.sourcePanel.add((Component)this.eventSelectScroll, "Center");
        this.add((Component)this.sourcePanel, "Center");
        this.eventHandlerPanel.setBorder(BorderFactory.createTitledBorder("Event Handler Method"));
        this.eventHandlerPanel.setLayout(new BorderLayout(8, 0));
        this.eventNameLabel.setLabelFor(this.eventNameCombo);
        this.eventNameLabel.setText("Method Name:");
        this.eventHandlerPanel.add((Component)this.eventNameLabel, "West");
        this.eventNameCombo.setEditable(true);
        this.eventHandlerPanel.add((Component)this.eventNameCombo, "Center");
        this.add((Component)this.eventHandlerPanel, "South");
    }

    static class EventSetNode
    implements TreeNode,
    Comparable<EventSetNode> {
        private String eventSetName;
        private List<EventNode> subNodes;

        public EventSetNode(String eventSetName, List<EventNode> subNodes) {
            this.eventSetName = eventSetName;
            this.subNodes = subNodes;
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            return this.subNodes.get(childIndex);
        }

        @Override
        public int getChildCount() {
            return this.subNodes.size();
        }

        @Override
        public TreeNode getParent() {
            return null;
        }

        @Override
        public int getIndex(TreeNode node) {
            return this.subNodes.indexOf(node);
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        public Enumeration children() {
            return Collections.enumeration(this.subNodes);
        }

        public String toString() {
            return this.eventSetName;
        }

        @Override
        public int compareTo(EventSetNode o) {
            if (this.eventSetName == null) {
                return -1;
            }
            if (o.eventSetName == null) {
                return 1;
            }
            return this.eventSetName.compareTo(o.eventSetName);
        }
    }

    static class EventNode
    implements TreeNode {
        private TreeNode parent;
        private Event event;

        public EventNode(TreeNode parent, Event event) {
            this.parent = parent;
            this.event = event;
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            return null;
        }

        @Override
        public int getChildCount() {
            return 0;
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public int getIndex(TreeNode node) {
            return -1;
        }

        @Override
        public boolean getAllowsChildren() {
            return false;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        public Enumeration children() {
            return null;
        }

        public String toString() {
            if (!this.event.hasEventHandlers()) {
                return this.event.getName();
            }
            String[] handlers = this.event.getEventHandlers();
            if (handlers.length == 1) {
                return this.event.getName() + " [" + handlers[0] + "]";
            }
            return this.event.getName() + " [...]";
        }

        Event getEvent() {
            return this.event;
        }
    }
}

