/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.refactoring.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.groovy.refactoring.findusages.model.RefactoringElement;
import org.netbeans.modules.groovy.refactoring.ui.RefactoringModule;
import org.netbeans.modules.groovy.refactoring.ui.WhereUsedPanelClass;
import org.netbeans.modules.groovy.refactoring.ui.WhereUsedPanelMethod;
import org.netbeans.modules.groovy.refactoring.ui.WhereUsedPanelPackage;
import org.netbeans.modules.groovy.refactoring.ui.WhereUsedPanelVariable;
import org.netbeans.modules.groovy.support.api.GroovySources;
import org.netbeans.modules.refactoring.api.Scope;
import org.netbeans.modules.refactoring.java.api.ui.JavaScopeBuilder;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class WhereUsedPanel
extends JPanel
implements CustomRefactoringPanel {
    public static final String ELLIPSIS = "\u2026";
    private static final String PREF_SCOPE = "FindUsages-Scope";
    private static final String PACKAGE = "org/netbeans/spi/java/project/support/ui/package.gif";
    private static final int SCOPE_COMBOBOX_COLUMNS = 14;
    private final RefactoringElement element;
    private boolean enableScope;
    private Scope customScope;
    private final WhereUsedInnerPanel panel;
    private boolean initialized = false;
    private FileObject packageFolder;
    private List<FileObject> projectSources;
    private JButton btnCustomScope;
    private ButtonGroup buttonGroup;
    private JPanel innerPanel;
    private JComboBox scope;
    private JLabel scopeLabel;
    private JPanel scopePanel;

    private WhereUsedPanel(RefactoringElement element, WhereUsedInnerPanel panel) {
        this.setName(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_WhereUsed"));
        this.element = element;
        this.enableScope = true;
        this.panel = panel;
        this.initComponents();
        this.btnCustomScope.setAction(new ScopeAction(this.scope));
    }

    public static WhereUsedPanel create(RefactoringElement element, ChangeListener parent) {
        WhereUsedInnerPanel panel;
        switch (element.getKind()) {
            case CONSTRUCTOR: 
            case METHOD: {
                panel = new WhereUsedPanelMethod();
                break;
            }
            case CLASS: 
            case MODULE: 
            case INTERFACE: {
                panel = new WhereUsedPanelClass();
                break;
            }
            case PACKAGE: {
                panel = new WhereUsedPanelPackage();
                break;
            }
            default: {
                panel = new WhereUsedPanelVariable();
            }
        }
        return new WhereUsedPanel(element, panel);
    }

    public Scope getCustomScope() {
        FileObject file = this.element.getFileObject();
        Scope value = null;
        if (!this.enableScope) {
            return Scope.create(null, null, Arrays.asList(file));
        }
        switch (this.scope.getSelectedIndex()) {
            case 1: {
                value = Scope.create(this.projectSources, null, null);
                break;
            }
            case 2: {
                NonRecursiveFolder nonRecursiveFolder = new NonRecursiveFolder(){

                    public FileObject getFolder() {
                        return WhereUsedPanel.this.packageFolder;
                    }
                };
                value = Scope.create(null, Arrays.asList(nonRecursiveFolder), null);
                break;
            }
            case 3: {
                value = Scope.create(null, null, Arrays.asList(file));
                break;
            }
            case 4: {
                value = this.customScope;
                break;
            }
            default: {
                return null;
            }
        }
        return value;
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.panel.initialize(this.element);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WhereUsedPanel.this.setupProjectSources();
                WhereUsedPanel.this.setupScope();
            }
        });
        this.initialized = true;
    }

    private void setupProjectSources() {
        Project project = FileOwnerQuery.getOwner((FileObject)this.element.getFileObject());
        List sources = GroovySources.getGroovySourceGroups((Sources)ProjectUtils.getSources((Project)project));
        this.projectSources = new ArrayList<FileObject>(sources.size());
        for (SourceGroup sourceGroup : sources) {
            this.projectSources.add(sourceGroup.getRootFolder());
        }
    }

    private void setupScope() {
        JLabel allProjects;
        JLabel currentProject;
        JLabel currentPackage;
        JLabel currentFile;
        JLabel customScope;
        FileObject fo = this.element.getFileObject();
        String packageName = this.element.getOwnerNameWithoutPackage();
        Project p = FileOwnerQuery.getOwner((FileObject)fo);
        ClassPath classPath = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
        if (classPath != null) {
            this.packageFolder = packageName == null ? classPath.findOwnerRoot(fo) : classPath.findResource(packageName.replaceAll("\\.", "/"));
        }
        if (p != null) {
            ProjectInformation pi = ProjectUtils.getInformation((Project)FileOwnerQuery.getOwner((FileObject)fo));
            DataObject currentFileDo = null;
            try {
                currentFileDo = DataObject.find((FileObject)fo);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
            customScope = new JLabel(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_CustomScope"), pi.getIcon(), 2);
            currentFile = new JLabel(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_CurrentFile", (Object)fo.getNameExt()), currentFileDo != null ? new ImageIcon(currentFileDo.getNodeDelegate().getIcon(1)) : pi.getIcon(), 2);
            currentPackage = new JLabel(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_CurrentPackage", (Object)packageName), ImageUtilities.loadImageIcon((String)PACKAGE, (boolean)false), 2);
            currentProject = new JLabel(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_CurrentProject", (Object)pi.getDisplayName()), pi.getIcon(), 2);
            allProjects = new JLabel(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_AllProjects"), pi.getIcon(), 2);
        } else {
            customScope = null;
            currentFile = null;
            currentPackage = null;
            currentProject = null;
            allProjects = null;
        }
        if (this.element.getKind().equals((Object)ElementKind.VARIABLE) || this.element.getKind().equals((Object)ElementKind.PARAMETER) || this.element.getModifiers().contains(Modifier.PRIVATE)) {
            this.enableScope = false;
        }
        this.innerPanel.removeAll();
        this.innerPanel.add((Component)this.panel, "Center");
        this.panel.setVisible(true);
        if (this.enableScope && currentProject != null) {
            this.scope.setModel(new DefaultComboBoxModel<Object>(new Object[]{allProjects, currentProject, currentPackage, currentFile, customScope}));
            int defaultItem = RefactoringModule.getOption("whereUsed.scope", 0);
            this.customScope = this.readScope();
            if (defaultItem == 4 && this.customScope != null && this.customScope.getFiles().isEmpty() && this.customScope.getFolders().isEmpty() && this.customScope.getSourceRoots().isEmpty()) {
                this.scope.setSelectedIndex(0);
            } else {
                this.scope.setSelectedIndex(defaultItem);
            }
            this.scope.setRenderer(new JLabelRenderer());
        } else {
            this.scopePanel.setVisible(false);
        }
    }

    private void storeScope(Scope customScope) {
        try {
            this.storeFileList(customScope.getSourceRoots(), "sourceRoot");
            this.storeFileList(customScope.getFolders(), "folder");
            this.storeFileList(customScope.getFiles(), "file");
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private Scope readScope() {
        try {
            if (NbPreferences.forModule(JavaScopeBuilder.class).nodeExists(PREF_SCOPE)) {
                return Scope.create(this.loadFileList("sourceRoot", FileObject.class), this.loadFileList("folder", NonRecursiveFolder.class), this.loadFileList("file", FileObject.class));
            }
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    private <T> List<T> loadFileList(String basekey, Class<T> type) throws BackingStoreException {
        Preferences pref = NbPreferences.forModule(JavaScopeBuilder.class).node(PREF_SCOPE).node(basekey);
        LinkedList<Object> toRet = new LinkedList<Object>();
        for (String key : pref.keys()) {
            String url = pref.get(key, null);
            if (url == null || url.isEmpty()) continue;
            try {
                final FileObject f = URLMapper.findFileObject((URL)new URL(url));
                if (f == null || !f.isValid()) continue;
                if (type.isAssignableFrom(FileObject.class)) {
                    toRet.add(f);
                    continue;
                }
                toRet.add(new NonRecursiveFolder(){

                    public FileObject getFolder() {
                        return f;
                    }
                });
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return toRet;
    }

    private void storeFileList(Set files, String basekey) throws BackingStoreException {
        Preferences pref = NbPreferences.forModule(WhereUsedPanel.class).node(PREF_SCOPE).node(basekey);
        assert (files != null);
        pref.clear();
        int count = 0;
        for (Object next : files) {
            if (next instanceof FileObject) {
                pref.put(basekey + count++, ((FileObject)next).toURL().toExternalForm());
                continue;
            }
            pref.put(basekey + count++, ((NonRecursiveFolder)next).getFolder().toURL().toExternalForm());
        }
        pref.flush();
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.scopePanel = new JPanel();
        this.scopeLabel = new JLabel();
        this.scope = new JComboBox();
        this.btnCustomScope = new JButton();
        this.innerPanel = new JPanel();
        this.scopeLabel.setLabelFor(this.scope);
        Mnemonics.setLocalizedText((JLabel)this.scopeLabel, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_Scope"));
        ((JTextField)this.scope.getEditor().getEditorComponent()).setColumns(14);
        this.scope.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WhereUsedPanel.this.scopeActionPerformed(evt);
            }
        });
        this.btnCustomScope.setText(ELLIPSIS);
        GroupLayout scopePanelLayout = new GroupLayout(this.scopePanel);
        this.scopePanel.setLayout(scopePanelLayout);
        scopePanelLayout.setHorizontalGroup(scopePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(scopePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.scopeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scope, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCustomScope).addContainerGap()));
        scopePanelLayout.setVerticalGroup(scopePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(scopePanelLayout.createSequentialGroup().addContainerGap().addGroup(scopePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(scopePanelLayout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.scopeLabel)).addGroup(scopePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnCustomScope).addComponent(this.scope, -2, -1, -2))).addContainerGap()));
        this.scope.getAccessibleContext().setAccessibleDescription("N/A");
        this.innerPanel.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scopePanel, -1, -1, Short.MAX_VALUE).addComponent(this.innerPanel, -1, 361, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.innerPanel, -1, 45, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scopePanel, -2, -1, -2)));
    }

    private void scopeActionPerformed(ActionEvent evt) {
        RefactoringModule.setOption("whereUsed.scope", this.scope.getSelectedIndex());
    }

    public boolean isMethodFromBaseClass() {
        if (this.panel instanceof WhereUsedPanelMethod) {
            WhereUsedPanelMethod methodPanel = (WhereUsedPanelMethod)this.panel;
            return methodPanel.isMethodFromBaseClass();
        }
        return false;
    }

    public boolean isMethodOverriders() {
        if (this.panel instanceof WhereUsedPanelMethod) {
            WhereUsedPanelMethod methodPanel = (WhereUsedPanelMethod)this.panel;
            return methodPanel.isMethodOverriders();
        }
        return false;
    }

    public boolean isMethodFindUsages() {
        if (this.panel instanceof WhereUsedPanelMethod) {
            WhereUsedPanelMethod methodPanel = (WhereUsedPanelMethod)this.panel;
            return methodPanel.isMethodFindUsages();
        }
        return false;
    }

    public boolean isClassSubTypes() {
        if (this.panel instanceof WhereUsedPanelClass) {
            WhereUsedPanelClass classPanel = (WhereUsedPanelClass)this.panel;
            return classPanel.isClassSubTypes();
        }
        return false;
    }

    public boolean isClassSubTypesDirectOnly() {
        if (this.panel instanceof WhereUsedPanelClass) {
            WhereUsedPanelClass classPanel = (WhereUsedPanelClass)this.panel;
            return classPanel.isClassSubTypesDirectOnly();
        }
        return false;
    }

    public boolean isClassFindUsages() {
        if (this.panel instanceof WhereUsedPanelClass) {
            WhereUsedPanelClass classPanel = (WhereUsedPanelClass)this.panel;
            return classPanel.isClassFindUsages();
        }
        return false;
    }

    public boolean isSearchInComments() {
        return this.panel.isSearchInComments();
    }

    public Component getComponent() {
        return this;
    }

    static abstract class WhereUsedInnerPanel
    extends JPanel {
        WhereUsedInnerPanel() {
        }

        abstract boolean isSearchInComments();

        abstract void initialize(RefactoringElement var1);
    }

    private class ScopeAction
    extends AbstractAction {
        private final JComboBox scope;

        private ScopeAction(JComboBox scope) {
            this.scope = scope;
            this.putValue("Name", WhereUsedPanel.ELLIPSIS);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Scope customScope = WhereUsedPanel.this.getCustomScope();
            customScope = JavaScopeBuilder.open((String)NbBundle.getMessage(WhereUsedPanel.class, (String)"DLG_CustomScope"), (Scope)customScope);
            if (customScope != null) {
                WhereUsedPanel.this.customScope = customScope;
                this.scope.setSelectedIndex(4);
                WhereUsedPanel.this.storeScope(customScope);
            }
        }
    }

    private static class JLabelRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public JLabelRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            if (value != null) {
                this.setText(((JLabel)value).getText());
                this.setIcon(((JLabel)value).getIcon());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }
}

