/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.model.wsdl.impl;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.netbeans.modules.websvc.saas.model.wsdl.impl.WsdlErrorHandler;
import org.netbeans.modules.websvc.saas.model.wsdl.impl.WsdlModel;
import org.netbeans.modules.websvc.saas.model.wsdl.impl.WsdlModelListener;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModelFactory;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXParseException;

public class WsdlModeler {
    private volatile WsdlModel wsdlModel;
    private URL wsdlUrl;
    private URL[] bindings;
    private URL catalog;
    private EntityResolver entityResolver;
    private Set<String> bindingFiles;
    private String packageName;
    private List<WsdlModelListener> modelListeners;
    RequestProcessor.Task task;
    RequestProcessor.Task task1;
    int listenersSize;
    protected Properties properties;
    private volatile Throwable creationException;

    WsdlModeler(URL wsdlUrl) {
        this.wsdlUrl = wsdlUrl;
        this.modelListeners = Collections.synchronizedList(new ArrayList());
        this.task = RequestProcessor.getDefault().create(new Runnable(){

            @Override
            public void run() {
                WsdlModeler.this.generateWsdlModel();
                WsdlModeler.this.fireModelCreated(WsdlModeler.this.wsdlModel);
            }
        }, true);
    }

    void setWsdlUrl(URL url) {
        this.wsdlUrl = url;
    }

    public URL getWsdlUrl() {
        return this.wsdlUrl;
    }

    public WsdlModel getWsdlModel() {
        return this.wsdlModel;
    }

    public WsdlModel getAndWaitForWsdlModel() {
        if (this.getWsdlModel() == null) {
            this.generateWsdlModel();
        }
        return this.wsdlModel;
    }

    public void generateWsdlModel(WsdlModelListener listener, final WsdlErrorHandler errorHandler) {
        RequestProcessor.Task task = RequestProcessor.getDefault().create(new Runnable(){

            @Override
            public void run() {
                WsdlModeler.this.generateWsdlModel(errorHandler);
                WsdlModeler.this.fireModelCreated(WsdlModeler.this.wsdlModel);
            }
        }, true);
        this.addWsdlModelListener(listener);
        task.run();
    }

    public void generateWsdlModel(WsdlModelListener listener) {
        this.generateWsdlModel(listener, false);
    }

    public void generateWsdlModel(WsdlModelListener listener, boolean forceReload) {
        if (forceReload) {
            try {
                this.task.waitFinished(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.addWsdlModelListener(listener);
            this.task.schedule(0);
        } else {
            this.addWsdlModelListener(listener);
            if (this.task.isFinished()) {
                this.task.schedule(0);
            }
        }
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Throwable getCreationException() {
        return this.creationException;
    }

    private void generateWsdlModel() {
        this.generateWsdlModel(new CatchFirstErrorHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateWsdlModel(WsdlErrorHandler errorHandler) {
        block9: {
            try {
                FileObject wsdlFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(this.wsdlUrl.toURI())));
                ModelSource ms = Utilities.getModelSource((FileObject)wsdlFO, (boolean)false);
                WSDLModel model = WSDLModelFactory.getDefault().getModel(Utilities.getModelSource((FileObject)wsdlFO, (boolean)false));
                if (model == null) {
                    SAXParseException parseError = null;
                    if (errorHandler instanceof CatchFirstErrorHandler) {
                        parseError = ((CatchFirstErrorHandler)errorHandler).getFirstError();
                        this.creationException = parseError;
                    }
                    if (parseError == null) {
                        this.creationException = new Exception(NbBundle.getMessage(WsdlModeler.class, (String)"ERR_CannotGenerateModel", (Object)this.wsdlUrl.toExternalForm()));
                    }
                    break block9;
                }
                WsdlModeler wsdlModeler = this;
                synchronized (wsdlModeler) {
                    this.wsdlModel = new WsdlModel(model);
                }
            }
            catch (URISyntaxException ex) {
                this.wsdlModel = null;
                SAXParseException parseError = null;
                if (errorHandler instanceof CatchFirstErrorHandler) {
                    parseError = ((CatchFirstErrorHandler)errorHandler).getFirstError();
                    this.creationException = parseError;
                }
                if (parseError != null) break block9;
                this.creationException = ex;
            }
        }
    }

    private synchronized void addWsdlModelListener(WsdlModelListener listener) {
        if (listener != null) {
            this.modelListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireModelCreated(WsdlModel model) {
        Object object = this.modelListeners;
        synchronized (object) {
            for (WsdlModelListener l : this.modelListeners) {
                l.modelCreated(model);
            }
        }
        object = this;
        synchronized (object) {
            this.modelListeners.clear();
        }
    }

    private class CatchFirstErrorHandler
    implements WsdlErrorHandler {
        private SAXParseException firstError;

        private CatchFirstErrorHandler() {
        }

        @Override
        public void warning(SAXParseException ex) throws WsdlErrorHandler.AbortException {
        }

        @Override
        public void info(SAXParseException ex) {
        }

        @Override
        public void fatalError(SAXParseException ex) throws WsdlErrorHandler.AbortException {
            if (this.firstError == null) {
                this.firstError = ex;
            }
        }

        @Override
        public void error(SAXParseException ex) throws WsdlErrorHandler.AbortException {
            if (this.firstError == null) {
                this.firstError = ex;
            }
        }

        public SAXParseException getFirstError() {
            return this.firstError;
        }
    }
}

