/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jspcompiler;

import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.netbeans.modules.web.jspcompiler.SmapReader;

public class SmapResolver {
    private static final String SMAP_HEADER = "SMAP";
    private static final String DEFAULT_STRATUM = "JSP";
    private static final String STRATUM_SECTION = "*S JSP";
    private static final String LINE_SECTION = "*L";
    private static final String FILE_SECTION = "*F";
    private static final String END_SECTION = "*E";
    private static final String FID_DELIM = "#";
    private SmapReader reader = null;
    private boolean resolved = false;
    private String defaultStratum = null;
    private String outputFileName = null;
    private Map<String, String> fsection = new Hashtable<String, String>(3);
    private Map<String, String> jsp2java = new TreeMap<String, String>();
    private Map<String, String> java2jsp = new TreeMap<String, String>();

    public SmapResolver(SmapReader reader) {
        this.resolved = this.resolve(reader.readSmap());
        this.reader = reader;
    }

    public String toString() {
        return this.reader.toString();
    }

    private boolean resolve(String smap) {
        String currentSection = "";
        if (smap == null) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(smap, "\n", false);
        boolean beginning = true;
        int sectionCounter = 0;
        String fileIndex = null;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (beginning) {
                if (!SMAP_HEADER.equals(token)) {
                    return false;
                }
                beginning = false;
                currentSection = SMAP_HEADER;
                continue;
            }
            if (STRATUM_SECTION.equals(token)) {
                currentSection = STRATUM_SECTION;
                continue;
            }
            if (FILE_SECTION.equals(token)) {
                currentSection = FILE_SECTION;
                sectionCounter = 0;
                continue;
            }
            if (LINE_SECTION.equals(token)) {
                currentSection = LINE_SECTION;
                sectionCounter = 0;
                fileIndex = "0";
                continue;
            }
            if (END_SECTION.equals(token)) {
                currentSection = END_SECTION;
                break;
            }
            if (SMAP_HEADER.equals(currentSection)) {
                if (sectionCounter == 0) {
                    this.outputFileName = token;
                }
                if (sectionCounter == 1) {
                    this.defaultStratum = token;
                }
            }
            if (FILE_SECTION.equals(currentSection)) {
                if (token.startsWith("+")) {
                    ++sectionCounter;
                    String string = token;
                    token = st.nextToken();
                    this.storeFile(string, token);
                } else {
                    this.storeFile(token, null);
                }
            }
            if (LINE_SECTION.equals(currentSection)) {
                int hashPresent = token.indexOf(FID_DELIM);
                if (hashPresent > -1 && (fileIndex = token.substring(hashPresent + 1, token.indexOf(58))) != null && fileIndex.indexOf(44) > -1) {
                    fileIndex = fileIndex.substring(0, fileIndex.indexOf(44));
                }
                this.storeLine(token, fileIndex);
            }
            ++sectionCounter;
        }
        this.resolved = this.sanityCheck();
        return this.resolved;
    }

    private void storeFile(String token, String token2) {
        String id = "";
        String filename = "";
        int spaceIndex = 0;
        if (token != null && token.startsWith("+")) {
            token = token.substring(2);
            spaceIndex = token.indexOf(" ");
            id = token.substring(0, spaceIndex);
            filename = token2;
        } else {
            spaceIndex = token.indexOf(" ");
            id = token.substring(0, spaceIndex);
            filename = token.substring(spaceIndex + 1);
        }
        this.fsection.put(id, filename);
    }

    private void storeLine(String token, String fileIndex) {
        int javaIndex;
        int outputIncrement;
        int delimIndex = token.indexOf(":");
        String jspLine = token.substring(0, delimIndex);
        String javaLine = token.substring(delimIndex + 1);
        int hashPresent = jspLine.indexOf(FID_DELIM);
        int commaPresent = jspLine.indexOf(44);
        int jspIndex = 0;
        int repeatCount = 0;
        if (commaPresent != -1) {
            repeatCount = Integer.parseInt(jspLine.substring(commaPresent + 1));
            jspIndex = hashPresent == -1 ? Integer.parseInt(jspLine.substring(0, commaPresent)) : Integer.parseInt(jspLine.substring(0, hashPresent));
        } else {
            jspIndex = hashPresent == -1 ? Integer.parseInt(jspLine) : Integer.parseInt(jspLine.substring(0, hashPresent));
            repeatCount = 1;
        }
        commaPresent = javaLine.indexOf(44);
        if (commaPresent != -1) {
            outputIncrement = Integer.parseInt(javaLine.substring(commaPresent + 1));
            javaIndex = Integer.parseInt(javaLine.substring(0, commaPresent));
        } else {
            outputIncrement = 1;
            javaIndex = Integer.parseInt(javaLine);
        }
        for (int i = 0; i < repeatCount; ++i) {
            int jspL = jspIndex + i;
            int javaL = javaIndex + i * outputIncrement;
            jspLine = Integer.toString(jspL).concat(FID_DELIM).concat(fileIndex);
            javaLine = Integer.toString(javaL);
            if (!this.jsp2java.containsKey(jspLine)) {
                this.jsp2java.put(jspLine, javaLine);
            }
            jspLine = Integer.toString(jspL).concat(FID_DELIM).concat(fileIndex);
            javaLine = Integer.toString(javaL);
            if (this.java2jsp.containsKey(javaLine)) continue;
            this.java2jsp.put(javaLine, jspLine);
        }
    }

    private boolean sanityCheck() {
        if (!DEFAULT_STRATUM.equals(this.defaultStratum)) {
            return false;
        }
        if (!this.outputFileName.endsWith(".java")) {
            return false;
        }
        if (this.fsection.isEmpty()) {
            return false;
        }
        if (this.jsp2java.isEmpty()) {
            return false;
        }
        return !this.java2jsp.isEmpty();
    }

    private String getFileNameByIndex(String index) {
        return this.fsection.get(index);
    }

    private String getIndexByFileName(String fname) {
        Set<Map.Entry<String, String>> s = this.fsection.entrySet();
        for (Map.Entry<String, String> mentry : s) {
            String value = mentry.getValue();
            if (!value.equalsIgnoreCase(fname)) continue;
            return mentry.getKey().toString();
        }
        return null;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public Map<Integer, String> getFileNames() {
        Hashtable<Integer, String> h = new Hashtable<Integer, String>(this.fsection.size());
        Collection<String> c = this.fsection.values();
        Iterator<String> i = c.iterator();
        int counter = 0;
        while (i.hasNext()) {
            h.put(counter++, i.next());
        }
        return h;
    }

    public String getPrimaryJspFileName() {
        TreeMap<String, String> tm = new TreeMap<String, String>(this.fsection);
        String firstKey = tm.firstKey();
        return this.fsection.get(firstKey);
    }

    public boolean hasIncludedFiles() {
        return this.fsection.size() > 1;
    }

    public String getJavaLineType(int line, int col) {
        return null;
    }

    public boolean isEmpty() {
        return this.jsp2java.isEmpty();
    }

    public String getJspFileName(int line, int col) throws IOException {
        String key = Integer.toString(line);
        String value = this.java2jsp.get(key);
        if (value == null) {
            return null;
        }
        String index = value.substring(value.indexOf(FID_DELIM) + 1);
        return this.getFileNameByIndex(index);
    }

    public int mangle(String jspFileName, int line, int col) {
        String fileIndex = this.getIndexByFileName(jspFileName);
        if (fileIndex == null) {
            return -1;
        }
        String key = "".concat(Integer.toString(line)).concat(FID_DELIM).concat(fileIndex);
        String value = this.jsp2java.get(key);
        if (value == null) {
            return -1;
        }
        return Integer.parseInt(value);
    }

    public int unmangle(int line, int col) {
        String key = Integer.toString(line);
        String value = this.java2jsp.get(key);
        if (value == null) {
            return -1;
        }
        int jspline = Integer.parseInt(value.substring(0, value.indexOf(FID_DELIM)));
        return jspline;
    }
}

