/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.nodes;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.java.api.GradleJavaProject;
import org.netbeans.modules.gradle.java.api.GradleJavaSourceSet;
import org.netbeans.modules.gradle.java.nodes.Bundle;
import org.netbeans.modules.gradle.java.nodes.LibrariesSourceGroup;
import org.netbeans.modules.gradle.java.nodes.PathFinders;
import org.netbeans.modules.gradle.java.spi.support.JavaToolchainSupport;
import org.netbeans.modules.gradle.spi.nodes.AbstractGradleNodeList;
import org.netbeans.modules.gradle.spi.nodes.NodeUtils;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.PathFinder;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class BootCPNodeFactory
implements NodeFactory {
    public static final String ENDORSED = "classpath/endorsed";
    private static final String LIBS_BADGE = "org/netbeans/modules/gradle/java/resources/libraries-badge.png";
    private static final String PLATFORM_ICON = "org/netbeans/modules/java/api/common/project/ui/resources/platform.gif";
    private static final String ARCHIVE_ICON = "org/netbeans/modules/java/api/common/project/ui/resources/jar.gif";
    private static final String MODULE_ICON = "org/netbeans/modules/java/api/common/project/ui/resources/module.png";

    public NodeList<?> createNodes(final Project p) {
        return new AbstractGradleNodeList<Void>(){
            ChangeListener listener = evt -> this.fireChange();

            public List<Void> keys() {
                return ProjectUtils.getSources((Project)p).getSourceGroups("java").length == 0 ? Collections.emptyList() : Collections.singletonList(null);
            }

            public Node node(Void key) {
                return new BootCPNode(p);
            }

            public void addNotify() {
                Sources srcs = ProjectUtils.getSources((Project)p);
                srcs.addChangeListener(this.listener);
            }

            public void removeNotify() {
                Sources srcs = ProjectUtils.getSources((Project)p);
                srcs.removeChangeListener(this.listener);
            }
        };
    }

    private static Node jarNode(SourceGroup sg) {
        Node delegate = PackageView.createPackageView((SourceGroup)sg);
        PathFinder pathFinder = PathFinders.createDelegatingPathFinder((PathFinder)delegate.getLookup().lookup(PathFinder.class));
        ProxyLookup lkp = new ProxyLookup(new Lookup[]{Lookups.exclude((Lookup)delegate.getLookup(), (Class[])new Class[]{PathFinder.class}), Lookups.singleton((Object)pathFinder)});
        return new FilterNode(delegate, null, (Lookup)lkp){

            public Action[] getActions(boolean context) {
                return new Action[0];
            }
        };
    }

    private static class CPChildren
    extends Children.Keys<SourceGroup> {
        CPChildren() {
        }

        protected void addNotify() {
            this.setKeys(this.getKeys());
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
        }

        protected Node[] createNodes(SourceGroup sg) {
            Node[] nodeArray;
            Node afn = BootCPNodeFactory.jarNode(sg);
            if (afn == null) {
                nodeArray = new Node[]{};
            } else {
                Node[] nodeArray2 = new Node[1];
                nodeArray = nodeArray2;
                nodeArray2[0] = afn;
            }
            return nodeArray;
        }

        private List<SourceGroup> getKeys() {
            JavaPlatform platform = ((JRENode)this.getNode()).pss.platform();
            if (platform == null) {
                return List.of();
            }
            FileObject[] roots = platform.getBootstrapLibraries().getRoots();
            ArrayList<SourceGroup> result = new ArrayList<SourceGroup>(roots.length);
            for (FileObject root : roots) {
                FileObject file;
                String protocol = root.toURL().getProtocol();
                FileObject fileObject = file = "jar".equals(protocol) ? FileUtil.getArchiveRoot((FileObject)root) : root;
                if (!file.isValid()) continue;
                ImageIcon icon = switch (protocol) {
                    case "jar" -> ImageUtilities.loadImageIcon((String)BootCPNodeFactory.ARCHIVE_ICON, (boolean)false);
                    case "nbjrt" -> ImageUtilities.loadImageIcon((String)BootCPNodeFactory.MODULE_ICON, (boolean)false);
                    default -> null;
                };
                result.add(new LibrariesSourceGroup(root, file.getNameExt(), icon, icon));
            }
            return result;
        }
    }

    private static class JRENode
    extends AbstractNode {
        private final PlatformSourceSet pss;

        private JRENode(PlatformSourceSet pss) {
            super((Children)new CPChildren(), Lookups.singleton((Object)PathFinders.createPathFinder()));
            this.pss = pss;
            this.setIconBaseWithExtension(BootCPNodeFactory.PLATFORM_ICON);
        }

        public String getName() {
            return this.pss.platform() != null ? this.pss.platform().getDisplayName() : Bundle.FMT_BrokenPlatform(this.pss.javaHome());
        }

        public String getDisplayName() {
            String groups = this.pss.sourceSets.stream().map(GradleJavaSourceSet::getName).collect(Collectors.joining(", ", "[", "]"));
            return this.getName() + " " + groups;
        }

        public String getHtmlDisplayName() {
            JavaPlatform platform = JavaToolchainSupport.getDefault().platformByHome(this.pss.javaHome());
            return platform != null ? this.getDisplayName() : "<html><font color='!nb.errorForeground'>" + this.getDisplayName() + "</font>";
        }

        public boolean canCopy() {
            return false;
        }

        public String getShortDescription() {
            String groups = this.pss.sourceSets.stream().map(GradleJavaSourceSet::getName).collect(Collectors.joining(", "));
            return Bundle.TOOLTIP_Platform(this.pss.javaHome(), groups);
        }
    }

    private static class BootCPChildren
    extends ChildFactory.Detachable<PlatformSourceSet> {
        private final Project project;

        BootCPChildren(Project project) {
            this.project = project;
        }

        protected void addNotify() {
            NbGradleProject.addPropertyChangeListener((Project)this.project, this::projectChange);
        }

        protected void removeNotify() {
            NbGradleProject.removePropertyChangeListener((Project)this.project, this::projectChange);
        }

        protected boolean createKeys(List<PlatformSourceSet> keys) {
            JavaToolchainSupport toolchains = JavaToolchainSupport.getDefault();
            HashMap<File, Set> pss = new HashMap<File, Set>();
            for (GradleJavaSourceSet s : GradleJavaProject.get(this.project).getSourceSets().values()) {
                File home2 = s.getCompilerJavaHome(GradleJavaSourceSet.SourceType.JAVA);
                if (home2 == null) continue;
                Set groups2 = pss.computeIfAbsent(home2, k -> new TreeSet<GradleJavaSourceSet>(Comparator.comparing(GradleJavaSourceSet::getName)));
                groups2.add(s);
            }
            pss.forEach((home, groups) -> keys.add(new PlatformSourceSet((File)home, toolchains.platformByHome((File)home), (Set<GradleJavaSourceSet>)groups)));
            return true;
        }

        protected Node createNodeForKey(PlatformSourceSet platform) {
            return new JRENode(platform);
        }

        private void projectChange(PropertyChangeEvent evt) {
            if ("ProjectInfo".equals(evt.getPropertyName())) {
                this.refresh(false);
            }
        }
    }

    private record PlatformSourceSet(File javaHome, JavaPlatform platform, Set<GradleJavaSourceSet> sourceSets) {
    }

    private static class BootCPNode
    extends AbstractNode {
        BootCPNode(Project p) {
            super(Children.create((ChildFactory)new BootCPChildren(p), (boolean)false), Lookups.singleton((Object)PathFinders.createPathFinder()));
            this.setName("BootCPNode");
            this.setDisplayName(Bundle.BootCPNode_displayName());
        }

        public Image getIcon(int param) {
            return ImageUtilities.mergeImages((Image)NodeUtils.getTreeFolderIcon((boolean)false), (Image)ImageUtilities.loadImage((String)BootCPNodeFactory.LIBS_BADGE), (int)8, (int)8);
        }

        public Image getOpenedIcon(int param) {
            return ImageUtilities.mergeImages((Image)NodeUtils.getTreeFolderIcon((boolean)true), (Image)ImageUtilities.loadImage((String)BootCPNodeFactory.LIBS_BADGE), (int)8, (int)8);
        }
    }
}

