/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.terminal.nb.actions;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.lib.terminalemulator.ActiveTerm;
import org.netbeans.modules.terminal.ioprovider.Terminal;
import org.netbeans.modules.terminal.nb.actions.TerminalAction;
import org.openide.util.Lookup;

public class DumpSequencesAction
extends TerminalAction {
    public DumpSequencesAction(Terminal context) {
        super(context);
        this.putValue("Name", DumpSequencesAction.getMessage("CTL_DumpSequences"));
    }

    private void dump(String title, Set<String> set) {
        PrintStream ps;
        File file = new File(String.format("/tmp/term-sequences-%s", title));
        try {
            ps = new PrintStream(file);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(Terminal.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        if (set != null) {
            for (String s : set) {
                ps.printf("%s\n", s);
            }
        }
        ps.close();
    }

    @Override
    public void performAction() {
        Terminal terminal = this.getTerminal();
        ActiveTerm term = terminal.term();
        if (!terminal.isEnabled()) {
            return;
        }
        this.dump("completed", term.getCompletedSequences());
        this.dump("unrecognized", term.getUnrecognizedSequences());
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new DumpSequencesAction((Terminal)actionContext.lookup(Terminal.class));
    }
}

