/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm.visitor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.netbeans.modules.xml.xdm.XDMModel;
import org.netbeans.modules.xml.xdm.nodes.Attribute;
import org.netbeans.modules.xml.xdm.nodes.Element;
import org.netbeans.modules.xml.xdm.nodes.Node;
import org.netbeans.modules.xml.xdm.nodes.NodeImpl;
import org.netbeans.modules.xml.xdm.visitor.ChildVisitor;
import org.w3c.dom.NamedNodeMap;

public class NamespaceRefactorVisitor
extends ChildVisitor {
    private String namespace;
    private String prefix;
    private List<Node> path;
    private Set<String> prefixesUsedByAttributesForDefaultNS = new HashSet<String>();
    private XDMModel model;
    private static final Pattern p = Pattern.compile("\\s*(\\S+)\\s*");

    @Deprecated
    public NamespaceRefactorVisitor() {
        this(null);
    }

    public NamespaceRefactorVisitor(XDMModel xdmModel) {
        this.model = xdmModel;
    }

    public void refactor(NodeImpl tree, String namespace, String newPrefix, List<Node> ancestors) {
        if (this.model.getQNameValuedAttributes() == null) {
            return;
        }
        assert (namespace != null) : "Cannot refactor null namespace";
        this.namespace = namespace;
        this.prefix = newPrefix;
        this.path = ancestors;
        tree.accept(this);
    }

    @Override
    public void visit(Element e) {
        this.path.add(0, e);
        NamespaceCheck redec = new NamespaceCheck(this.prefix, this.namespace, e);
        if (redec.getPrefixRedeclaration() == null) {
            this.visitNode(e);
            if (this.namespace.equals(NodeImpl.lookupNamespace(e.getPrefix(), this.path))) {
                e.setPrefix(this.prefix);
            }
            for (Attribute sameNamespace : redec.getNamespaceRedeclaration()) {
                String prefixToRemove = sameNamespace.getLocalName();
                if (this.prefixesUsedByAttributesForDefaultNS.remove(prefixToRemove)) continue;
                e.removeAttributeNode(sameNamespace);
            }
            if (redec.getDuplicateDeclaration() != null) {
                e.removeAttributeNode(redec.getDuplicateDeclaration());
            }
        }
        this.path.remove(e);
    }

    @Override
    public void visit(Attribute attr) {
        if (attr.isXmlnsAttribute()) {
            return;
        }
        String attrPrefix = attr.getPrefix();
        if (!NamespaceRefactorVisitor.isDefaultPrefix(attrPrefix) && this.namespace.equals(NodeImpl.lookupNamespace(attrPrefix, this.path))) {
            if (NamespaceRefactorVisitor.isDefaultPrefix(this.prefix)) {
                this.prefixesUsedByAttributesForDefaultNS.add(attrPrefix);
            } else {
                attr.setPrefix(this.prefix);
            }
        }
        if (this.isQNameValued(attr)) {
            this.prefixesUsedByAttributesForDefaultNS.addAll(NamespaceRefactorVisitor.refactorAttributeValue(attr, this.namespace, this.prefix, this.path, this.model));
        }
    }

    private QName getQName(Element node) {
        String ns = NodeImpl.lookupNamespace(node.getPrefix(), this.path);
        return new QName(ns, node.getLocalName());
    }

    private QName getQName(Attribute node) {
        String p = node.getPrefix();
        String ns = p == null || p.length() == 0 ? null : NodeImpl.lookupNamespace(p, this.path);
        return new QName(ns, node.getLocalName());
    }

    private boolean isQNameValued(Attribute attr) {
        assert (this.path != null && this.path.size() > 0);
        Element e = (Element)this.path.get(0);
        QName elementQName = this.getQName(e);
        QName attrQName = this.getQName(attr);
        List<QName> attrQNames = this.model.getQNameValuedAttributes().get(elementQName);
        if (attrQNames != null) {
            return attrQNames.contains(attrQName);
        }
        return false;
    }

    public static boolean isDefaultPrefix(String prefix) {
        return prefix == null || prefix.equals("");
    }

    public static List<String> refactorAttributeValue(Attribute attr, String namespace, String prefix, List<Node> context, XDMModel model) {
        ArrayList<String> prefixesUsedForDefaultNS = new ArrayList<String>();
        String value = attr.getValue();
        StringBuilder newValue = null;
        Matcher m = p.matcher(value);
        while (m.find()) {
            String qname = m.group(1);
            String[] parts = qname.split(":");
            if (parts.length <= 1) continue;
            String valuePrefix = parts[0];
            String valueNamespace = context.size() == 1 ? context.get(0).lookupNamespaceURI(valuePrefix) : NodeImpl.lookupNamespace(valuePrefix, context);
            if (!namespace.equals(valueNamespace)) continue;
            if (NamespaceRefactorVisitor.isDefaultPrefix(prefix)) {
                prefixesUsedForDefaultNS.add(valuePrefix);
                continue;
            }
            if (newValue == null) {
                newValue = new StringBuilder();
            }
            newValue.append(prefix);
            newValue.append(":");
            newValue.append(parts[1]);
            newValue.append(" ");
        }
        if (newValue != null) {
            attr.setValue(newValue.toString().trim());
        }
        return prefixesUsedForDefaultNS;
    }

    public static class NamespaceCheck {
        Attribute duplicate;
        Attribute prefixRedeclaration;
        List<Attribute> namespaceRedeclaredAttributes = new ArrayList<Attribute>();

        public NamespaceCheck(String existingPrefix, String existingNamespace, Element e) {
            this.init(existingPrefix, existingNamespace, e);
        }

        public Attribute getPrefixRedeclaration() {
            return this.prefixRedeclaration;
        }

        public List<Attribute> getNamespaceRedeclaration() {
            return this.namespaceRedeclaredAttributes;
        }

        public Attribute getDuplicateDeclaration() {
            return this.duplicate;
        }

        private void init(String existingPrefix, String existingNamespace, Element e) {
            NamedNodeMap nnm = e.getAttributes();
            for (int i = 0; i < nnm.getLength(); ++i) {
                Attribute attr;
                if (!(nnm.item(i) instanceof Attribute) || !(attr = (Attribute)nnm.item(i)).isXmlnsAttribute()) continue;
                Attribute samePrefix = null;
                Attribute sameNamespace = null;
                String prefix = attr.getLocalName();
                if ("xmlns".equals(prefix)) {
                    prefix = "";
                }
                if (prefix.equals(existingPrefix)) {
                    samePrefix = attr;
                }
                if (existingNamespace.equals(attr.getValue())) {
                    sameNamespace = attr;
                }
                if (samePrefix != null && sameNamespace != null) {
                    this.duplicate = attr;
                    continue;
                }
                if (samePrefix != null) {
                    this.prefixRedeclaration = attr;
                    continue;
                }
                if (sameNamespace == null) continue;
                this.namespaceRedeclaredAttributes.add(attr);
            }
        }
    }
}

