/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import org.eclipse.jgit.api.errors.CanceledException;
import org.eclipse.jgit.diff.ContentSource;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.RenameDetector;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.jgit.utils.AutoCRLFComparator;
import org.netbeans.libs.git.progress.FileListener;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class ExportDiffCommand
extends GitCommand {
    private final File[] roots;
    private final ProgressMonitor monitor;
    private final OutputStream out;
    private final FileListener listener;
    private final String firstCommit;
    private final String secondCommit;

    public ExportDiffCommand(Repository repository, GitClassFactory gitFactory, File[] roots, String firstCommit, String secondCommit, OutputStream out, ProgressMonitor monitor, FileListener listener) {
        super(repository, gitFactory, monitor);
        this.roots = roots;
        this.monitor = monitor;
        this.listener = listener;
        this.firstCommit = firstCommit;
        this.secondCommit = secondCommit;
        this.out = out;
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        String workTreePath = repository.getWorkTree().getAbsolutePath();
        try (DiffFormatter formatter = new DiffFormatter(this.out);
             ObjectReader or = repository.newObjectReader();){
            List diffEntries;
            formatter.setRepository(repository);
            Collection<PathFilter> pathFilters = Utils.getPathFilters(repository.getWorkTree(), this.roots);
            if (!pathFilters.isEmpty()) {
                formatter.setPathFilter(PathFilterGroup.create(pathFilters));
            }
            if (((WorkingTreeOptions)repository.getConfig().get(WorkingTreeOptions.KEY)).getAutoCRLF() != CoreConfig.AutoCRLF.FALSE) {
                formatter.setDiffComparator((RawTextComparator)new AutoCRLFComparator());
            }
            AbstractTreeIterator firstTree = this.getIterator(this.firstCommit, or);
            AbstractTreeIterator secondTree = this.getIterator(this.secondCommit, or);
            if (secondTree instanceof WorkingTreeIterator) {
                formatter.setDetectRenames(false);
                diffEntries = formatter.scan(firstTree, secondTree);
                formatter.setDetectRenames(true);
                RenameDetector detector = formatter.getRenameDetector();
                detector.reset();
                detector.addAll((Collection)diffEntries);
                diffEntries = detector.compute(new ContentSource.Pair(ContentSource.create((ObjectReader)or), ContentSource.create((WorkingTreeIterator)((WorkingTreeIterator)secondTree))), (org.eclipse.jgit.lib.ProgressMonitor)NullProgressMonitor.INSTANCE);
            } else {
                formatter.setDetectRenames(true);
                diffEntries = formatter.scan(firstTree, secondTree);
            }
            for (DiffEntry ent : diffEntries) {
                if (this.monitor.isCanceled()) break;
                this.listener.notifyFile(new File(workTreePath + File.separator + ent.getNewPath()), ent.getNewPath());
                formatter.format(ent);
            }
            formatter.flush();
        }
        catch (IOException | CanceledException ex) {
            throw new GitException(ex);
        }
    }

    private AbstractTreeIterator getIterator(String commit, ObjectReader or) throws IOException, GitException {
        Repository repository = this.getRepository();
        switch (commit) {
            case "HEAD": {
                return this.getHeadIterator(or);
            }
            case "INDEX": {
                return new DirCacheIterator(repository.readDirCache());
            }
            case "WORKING_TREE": {
                return new FileTreeIterator(repository);
            }
        }
        CanonicalTreeParser p = new CanonicalTreeParser();
        p.reset(or, (AnyObjectId)Utils.findCommit(repository, commit).getTree());
        return p;
    }

    @Override
    protected String getCommandDescription() {
        StringBuilder sb = new StringBuilder("git diff");
        for (File root : this.roots) {
            sb.append(" ").append(root);
        }
        return sb.toString();
    }

    private AbstractTreeIterator getHeadIterator(ObjectReader or) throws IOException {
        Repository repository = this.getRepository();
        ObjectId headId = repository.resolve("HEAD");
        Object headIterator = headId != null ? new CanonicalTreeParser(null, or, (AnyObjectId)new RevWalk(repository).parseTree((AnyObjectId)headId).getId()) : new EmptyTreeIterator();
        return headIterator;
    }
}

