/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.openide.awt.CloseButtonFactory;
import org.openide.util.NbPreferences;
import org.openide.util.WeakListeners;

public class NodeSelectionProjectPanel
extends JPanel
implements PreferenceChangeListener {
    public static final Preferences prefs = NbPreferences.forModule(NodeSelectionProjectPanel.class);
    public static final String KEY_ACTUALSELECTIONPROJECT = "enable.actualselectionproject";
    private boolean enabled;
    private boolean isMinimized;
    public static final int COMPONENT_HEIGHT = 22;
    private static final int BORDER_WIDTH = 1;

    public NodeSelectionProjectPanel() {
        super(new BorderLayout());
        JButton closeButton = CloseButtonFactory.createBigCloseButton();
        prefs.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this, (Object)prefs));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                prefs.putBoolean(NodeSelectionProjectPanel.KEY_ACTUALSELECTIONPROJECT, false);
            }
        });
        this.add((Component)closeButton, "East");
        this.setBorder(new SeparatorBorder());
        this.preferenceChange(null);
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt == null || KEY_ACTUALSELECTIONPROJECT.equals(evt.getKey())) {
            this.enabled = prefs.getBoolean(KEY_ACTUALSELECTIONPROJECT, false);
            this.updatePreferredSize();
        }
    }

    private void updatePreferredSize() {
        if (this.enabled) {
            this.setPreferredSize(new Dimension(Integer.MAX_VALUE, 23));
            this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
            this.isMinimized = false;
        } else {
            this.setPreferredSize(new Dimension(0, 0));
            this.setMaximumSize(new Dimension(0, 0));
            this.isMinimized = true;
        }
        this.revalidate();
    }

    void minimize() {
        this.setPreferredSize(new Dimension(0, 0));
        this.setMaximumSize(new Dimension(0, 0));
        this.isMinimized = true;
        this.revalidate();
    }

    void maximize() {
        this.setPreferredSize(new Dimension(Integer.MAX_VALUE, 23));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.isMinimized = false;
        this.revalidate();
    }

    public boolean isMinimized() {
        return this.isMinimized;
    }

    private static final class SeparatorBorder
    implements Border {
        private static final int BORDER_WIDTH = 1;
        private final Insets INSETS = new Insets(1, 0, 0, 0);

        private SeparatorBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color originalColor = g.getColor();
            g.setColor(UIManager.getColor("controlShadow"));
            g.drawLine(0, 0, c.getWidth(), 0);
            g.setColor(originalColor);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.INSETS;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }
}

