/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.htmlui;

import java.net.URL;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import org.netbeans.api.htmlui.HTMLDialog;
import org.netbeans.modules.htmlui.ContextAccessor;
import org.openide.util.Lookup;

public interface HTMLViewerSpi<HtmlView, HtmlButton> {
    public HtmlView newView(Context var1);

    public <C> C component(HtmlView var1, Class<C> var2);

    public HtmlButton createButton(HtmlView var1, String var2);

    public String getId(HtmlView var1, HtmlButton var2);

    public void setText(HtmlView var1, HtmlButton var2, String var3);

    public void setEnabled(HtmlView var1, HtmlButton var2, boolean var3);

    public void runLater(HtmlView var1, Runnable var2);

    public static final class Context {
        private final ClassLoader loader;
        private final URL url;
        private final String[] resources;
        private final String[] techIds;
        private final HTMLDialog.OnSubmit onSubmit;
        private final Consumer<String> lifeCycleCallback;
        private final Callable<Lookup> onPageLoad;
        private final Class<?> component;

        private Context(ClassLoader loader, URL url, String[] resources, String[] techIds, HTMLDialog.OnSubmit onSubmit, Consumer<String> lifeCycleCallback, Callable<Lookup> onPageLoad, Class<?> component) {
            this.loader = loader;
            this.url = url;
            this.resources = resources;
            this.techIds = techIds;
            this.onSubmit = onSubmit;
            this.lifeCycleCallback = lifeCycleCallback;
            this.onPageLoad = onPageLoad;
            this.component = component;
        }

        public boolean isWindow() {
            return this.component == null && this.lifeCycleCallback == null;
        }

        public boolean isDialog() {
            return this.component == null && this.lifeCycleCallback != null;
        }

        public boolean isBlocking() {
            return this.isDialog() && this.onSubmit == null;
        }

        public boolean onSubmit(String id) {
            if (this.onSubmit != null && id != null && !this.onSubmit.onSubmit(id)) {
                return false;
            }
            if (this.lifeCycleCallback != null) {
                this.lifeCycleCallback.accept(id);
            }
            return true;
        }

        public Lookup onPageLoad() {
            if (this.onPageLoad != null) {
                try {
                    return this.onPageLoad.call();
                }
                catch (Exception ex) {
                    throw Context.raise(RuntimeException.class, ex);
                }
            }
            return null;
        }

        public URL getPage() {
            return this.url;
        }

        public ClassLoader getClassLoader() {
            return this.loader;
        }

        public String[] getResources() {
            return (String[])this.resources.clone();
        }

        public String[] getTechIds() {
            return (String[])this.techIds.clone();
        }

        private static <T extends Exception> T raise(Class<T> aClass, Exception ex) throws T {
            throw ex;
        }

        static {
            new ContextAccessor(){

                @Override
                public Context newContext(ClassLoader loader, URL url, String[] resources, String[] techIds, HTMLDialog.OnSubmit onSubmit, Consumer<String> lifeCycleCallback, Callable<Lookup> onPageLoad, Class<?> component) {
                    return new Context(loader, url, resources, techIds, onSubmit, lifeCycleCallback, onPageLoad, component);
                }
            };
        }
    }
}

