/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.db;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.java.lsp.server.protocol.CodeActionsProvider;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.protocol.UpdateConfigParams;
import org.netbeans.modules.parsing.api.ResultIterator;

public class DBSetEnvCommand
extends CodeActionsProvider {
    private static final String COMMAND_SET_DB_ENV = "java.db.set.env";
    private static final String CONFIG_SECTION = "java+.runConfig";
    private static final Set<String> COMMANDS = new HashSet<String>(Arrays.asList("java.db.set.env"));

    @Override
    public List<CodeAction> getCodeActions(ResultIterator resultIterator, CodeActionParams params) throws Exception {
        return Collections.emptyList();
    }

    @Override
    public CompletableFuture<Object> processCommand(NbCodeLanguageClient client, String command, List<Object> arguments) {
        if (!COMMAND_SET_DB_ENV.equals(command)) {
            return null;
        }
        DatabaseConnection conn = ConnectionManager.getDefault().getPreferredConnection(true);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("DATASOURCES_DEFAULT_URL", conn.getDatabaseURL());
        props.put("DATASOURCES_DEFAULT_USERNAME", conn.getUser());
        props.put("DATASOURCES_DEFAULT_PASSWORD", conn.getPassword());
        props.put("DATASOURCES_DEFAULT_DRIVER_CLASS_NAME", conn.getDriverClass());
        String values = props.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(","));
        client.configurationUpdate(new UpdateConfigParams(CONFIG_SECTION, "env", values));
        return CompletableFuture.completedFuture(props);
    }

    @Override
    public Set<String> getCommands() {
        return COMMANDS;
    }
}

