/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.views.debugging;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.netbeans.modules.debugger.ui.views.debugging.SwitcherTable;
import org.netbeans.modules.debugger.ui.views.debugging.SwitcherTableItem;
import org.netbeans.modules.debugger.ui.views.debugging.ThreadsHistoryAction;
import org.openide.awt.StatusDisplayer;
import org.openide.windows.WindowManager;

public final class KeyboardPopupSwitcher
implements WindowFocusListener {
    private static final int TIME_TO_SHOW = 300;
    private static KeyboardPopupSwitcher instance;
    private static JDialog popup;
    private static boolean shown;
    private static Timer invokerTimer;
    private static AWTListener awtListener;
    private static boolean invokerTimerRunning;
    private static int hits;
    private static SwitcherTableItem[] items;
    private SwitcherTable pTable;
    private static int triggerKey;
    private static int reverseKey;
    private static int releaseKey;
    private static boolean cancelOnFocusLost;
    private int x;
    private int y;
    private boolean fwd = true;

    public static boolean processShortcut(KeyEvent kev) {
        boolean isCtrlShiftTab;
        boolean isCtrlTab = kev.getKeyCode() == 9 && kev.getModifiers() == 2;
        boolean bl = isCtrlShiftTab = kev.getKeyCode() == 9 && kev.getModifiers() == 3;
        if (KeyboardPopupSwitcher.isShown()) {
            assert (instance != null);
            instance.processKeyEvent(kev);
            kev.consume();
            return true;
        }
        if (isCtrlTab || isCtrlShiftTab) {
            if (KeyboardPopupSwitcher.isAlive()) {
                KeyboardPopupSwitcher.processInterruption(kev);
            }
            kev.consume();
            return true;
        }
        if (kev.getKeyCode() == 17 && KeyboardPopupSwitcher.isAlive()) {
            KeyboardPopupSwitcher.processInterruption(kev);
            return true;
        }
        return false;
    }

    public static void selectItem(SwitcherTableItem[] items, int releaseKey, int triggerKey, boolean forward) {
        KeyboardPopupSwitcher.selectItem(items, releaseKey, triggerKey, forward, true);
    }

    public static void selectItem(SwitcherTableItem[] items, int releaseKey, int triggerKey, boolean forward, boolean cancelOnFocusLost) {
        if (invokerTimerRunning) {
            return;
        }
        KeyboardPopupSwitcher.items = items;
        KeyboardPopupSwitcher.releaseKey = releaseKey;
        KeyboardPopupSwitcher.triggerKey = triggerKey;
        KeyboardPopupSwitcher.cancelOnFocusLost = cancelOnFocusLost;
        invokerTimer = new Timer(300, new PopupInvoker(forward));
        invokerTimer.setRepeats(false);
        invokerTimer.start();
        invokerTimerRunning = true;
        awtListener = new AWTListener();
        Toolkit.getDefaultToolkit().addAWTEventListener(awtListener, 8L);
    }

    private static void cleanupInterrupter() {
        invokerTimerRunning = false;
        if (invokerTimer != null) {
            invokerTimer.stop();
        }
    }

    public static boolean isShown() {
        return shown;
    }

    private static boolean isAlive() {
        return invokerTimerRunning || shown;
    }

    private KeyboardPopupSwitcher(int initialSelection, boolean forward) {
        this.fwd = forward;
        this.pTable = new SwitcherTable(items);
        Dimension popupDim = this.pTable.getPreferredSize();
        Rectangle screen = WindowManager.getDefault().getMainWindow().getBounds();
        this.x = screen.x + (screen.width / 2 - popupDim.width / 2);
        this.y = screen.y + (screen.height / 2 - popupDim.height / 2);
        int cols = this.pTable.getColumnCount();
        int rows = this.pTable.getRowCount();
        assert (cols > 0) : "There aren't any columns in the KeyboardPopupSwitcher's table";
        assert (rows > 0) : "There aren't any rows in the KeyboardPopupSwitcher's table";
        this.changeTableSelection(rows > initialSelection && initialSelection >= 0 ? initialSelection : rows - 1, 0);
    }

    private void showPopup() {
        if (!KeyboardPopupSwitcher.isShown()) {
            InputMap inputMap = this.pTable.getInputMap(2);
            inputMap.put(KeyStroke.getKeyStroke(27, 512, true), "escape");
            inputMap.put(KeyStroke.getKeyStroke(27, 576, true), "escape");
            inputMap.put(KeyStroke.getKeyStroke(releaseKey, 0, true), "close");
            inputMap.put(KeyStroke.getKeyStroke(10, 0, false), "close");
            inputMap.put(KeyStroke.getKeyStroke(releaseKey, 64, true), "close");
            inputMap.put(KeyStroke.getKeyStroke(triggerKey, 512), "triggerKeyPressed");
            inputMap.put(KeyStroke.getKeyStroke(triggerKey, 576), "triggerKeyPressed");
            inputMap.put(KeyStroke.getKeyStroke(reverseKey, 512, true), "reverseKeyReleased");
            inputMap.put(KeyStroke.getKeyStroke(reverseKey, 512, false), "reverseKeyPressed");
            inputMap.put(KeyStroke.getKeyStroke(reverseKey, 576, false), "reverseKeyPressed");
            this.pTable.setInputMap(2, inputMap);
            this.pTable.setInputMap(0, inputMap);
            AbstractAction closeAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KeyboardPopupSwitcher.processShortcut(new KeyEvent((JComponent)e.getSource(), 402, e.getWhen(), e.getModifiers(), releaseKey, '\u0000'));
                }
            };
            AbstractAction escapeAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KeyboardPopupSwitcher.processShortcut(new KeyEvent((JComponent)e.getSource(), 402, e.getWhen(), e.getModifiers(), 27, '\u0000'));
                }
            };
            AbstractAction nextAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KeyboardPopupSwitcher.processShortcut(new KeyEvent((JComponent)e.getSource(), 401, e.getWhen(), e.getModifiers(), triggerKey, '\u0000'));
                }
            };
            AbstractAction previous2Action = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KeyboardPopupSwitcher.processShortcut(new KeyEvent((JComponent)e.getSource(), 402, e.getWhen(), e.getModifiers(), reverseKey, '\u0000'));
                }
            };
            AbstractAction previousAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KeyboardPopupSwitcher.processShortcut(new KeyEvent((JComponent)e.getSource(), 401, e.getWhen(), e.getModifiers(), reverseKey, '\u0000'));
                }
            };
            final ActionMap actionMap = this.pTable.getActionMap();
            actionMap.put("close", closeAction);
            actionMap.put("escape", escapeAction);
            actionMap.put("triggerKeyPressed", nextAction);
            actionMap.put("reverseKeyPressed", previousAction);
            actionMap.put("reverseKeyReleased", previous2Action);
            actionMap.remove("selectNextRow");
            this.pTable.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int b = e.getButton();
                    if (b == 1) {
                        actionMap.get("close").actionPerformed(new ActionEvent(e.getSource(), e.getID(), "close"));
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            });
            popup = new JDialog(WindowManager.getDefault().getMainWindow());
            popup.setUndecorated(true);
            popup.getContentPane().add(this.pTable);
            popup.setLocation(this.x, this.y);
            popup.pack();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    popup.addWindowFocusListener(KeyboardPopupSwitcher.this);
                }
            });
            popup.setVisible(true);
            shown = true;
        }
    }

    private static void processInterruption(KeyEvent kev) {
        int keyCode = kev.getKeyCode();
        if (keyCode == releaseKey && kev.getID() == 402) {
            KeyboardPopupSwitcher.cleanupInterrupter();
            hits = 0;
            ThreadsHistoryAction rva = new ThreadsHistoryAction();
            rva.actionPerformed(new ActionEvent(kev.getSource(), 1001, "immediately", kev.getModifiers()));
            kev.consume();
        } else if (keyCode == triggerKey && kev.getModifiers() == 2 && kev.getID() == 401) {
            kev.consume();
            KeyboardPopupSwitcher.cleanupInterrupter();
            instance = new KeyboardPopupSwitcher(++hits + 1, true);
            instance.showPopup();
        }
    }

    private void processKeyEvent(KeyEvent kev) {
        switch (kev.getID()) {
            case 401: {
                int code = kev.getKeyCode();
                if (code == reverseKey) {
                    this.fwd = false;
                } else if (code == triggerKey) {
                    int lastRowIdx = this.pTable.getRowCount() - 1;
                    int lastColIdx = this.pTable.getColumnCount() - 1;
                    int selRow = this.pTable.getSelectedRow();
                    int selCol = this.pTable.getSelectedColumn();
                    int row = selRow;
                    int col = selCol;
                    if (this.fwd) {
                        if (selRow >= lastRowIdx) {
                            row = 0;
                            col = selCol >= lastColIdx ? 0 : ++col;
                        } else if (this.pTable.getValueAt(++row, col) == null) {
                            row = 0;
                            col = 0;
                        }
                    } else if (selRow == 0) {
                        if (selCol == 0) {
                            col = lastColIdx;
                            row = this.pTable.getLastValidRow();
                        } else {
                            --col;
                            row = lastRowIdx;
                        }
                    } else {
                        --row;
                    }
                    if (row >= 0 && col >= 0) {
                        this.changeTableSelection(row, col);
                    }
                }
                kev.consume();
                break;
            }
            case 402: {
                int code = kev.getKeyCode();
                if (code == reverseKey) {
                    this.fwd = true;
                    kev.consume();
                    break;
                }
                if (code == 27) {
                    this.cancelSwitching();
                    break;
                }
                if (code != releaseKey) break;
                this.performSwitching();
            }
        }
    }

    private void changeTableSelection(int row, int col) {
        this.pTable.changeSelection(row, col, false, false);
        SwitcherTableItem item = this.pTable.getSelectedItem();
        if (item != null) {
            String statusText = item.getDescription();
            StatusDisplayer.getDefault().setStatusText(statusText != null ? statusText : "");
        }
    }

    private void cancelSwitching() {
        this.hideCurrentPopup();
        StatusDisplayer.getDefault().setStatusText("");
    }

    private void performSwitching() {
        SwitcherTableItem item;
        if (popup != null && (item = this.pTable.getSelectedItem()) != null) {
            item.activate();
        }
        this.cancelSwitching();
    }

    private synchronized void hideCurrentPopup() {
        if (popup != null) {
            SwingUtilities.invokeLater(new PopupHider(popup));
        }
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        if (cancelOnFocusLost && e.getOppositeWindow() != popup) {
            this.cancelSwitching();
        }
    }

    static {
        reverseKey = 16;
        cancelOnFocusLost = true;
    }

    private static class AWTListener
    implements AWTEventListener {
        private AWTListener() {
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            if (!(event instanceof KeyEvent)) {
                return;
            }
            KeyEvent keyEvent = (KeyEvent)event;
            if (keyEvent.getKeyCode() == 18) {
                Toolkit.getDefaultToolkit().removeAWTEventListener(this);
                KeyEvent kev = new KeyEvent((Component)keyEvent.getSource(), 402, keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar());
                KeyboardPopupSwitcher.processInterruption(kev);
            }
        }
    }

    private class PopupHider
    implements Runnable {
        private JDialog toHide;

        public PopupHider(JDialog popup) {
            this.toHide = popup;
        }

        @Override
        public void run() {
            this.toHide.setVisible(false);
            shown = false;
            hits = 0;
            this.toHide.removeWindowFocusListener(KeyboardPopupSwitcher.this);
        }
    }

    private static class PopupInvoker
    implements ActionListener {
        private boolean forward;

        public PopupInvoker(boolean forward) {
            this.forward = forward;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(awtListener);
            if (invokerTimerRunning) {
                KeyboardPopupSwitcher.cleanupInterrupter();
                instance = new KeyboardPopupSwitcher(this.forward ? hits + 1 : items.length - hits - 1, this.forward);
                instance.showPopup();
            }
        }
    }
}

