/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.ppoints.Bundle;
import org.netbeans.modules.profiler.ppoints.ProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.ProfilingPointsManager;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.netbeans.modules.profiler.ppoints.ui.ValidityListener;
import org.netbeans.modules.profiler.ppoints.ui.WizardPanel1UI;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public class ProfilingPointWizard
implements WizardDescriptor.Iterator {
    private static ProfilingPointWizard defaultInstance;
    private static final Dimension DEFAULT_PREFERRED_PANEL_SIZE;
    private Dimension preferredPanelSize = null;
    private ProfilingPoint profilingPoint;
    private Lookup.Provider selectedProject;
    private WizardDescriptor wizardDescriptor;
    private ProfilingPointFactory[] ppFactories;
    private WizardPanel[] wizardPanels;
    private String[] wizardSteps;
    private boolean settingsChanged;
    private int currentPanel;
    private int selectedPPFactoryIndex;

    private ProfilingPointWizard() {
    }

    public static ProfilingPointWizard getDefault() {
        return Singleton.INSTANCE;
    }

    public WizardDescriptor getWizardDescriptor() {
        return this.getWizardDescriptor(null);
    }

    public WizardDescriptor getWizardDescriptor(Lookup.Provider project) {
        ValidityAwarePanel showingCustomizer = ProfilingPointsManager.getDefault().getShowingCustomizer();
        if (showingCustomizer != null) {
            ProfilerDialogs.displayWarning((String)Bundle.ProfilingPointWizard_AnotherPpEditedMsg());
            SwingUtilities.getWindowAncestor(showingCustomizer).requestFocus();
            showingCustomizer.requestFocusInWindow();
            return null;
        }
        this.settingsChanged = true;
        this.currentPanel = 0;
        this.selectedPPFactoryIndex = 0;
        this.selectedProject = project;
        this.initWizardDescriptor();
        this.initWizardPanels();
        if (this.ppFactories.length > 0) {
            this.getCurrentWizardPanel().showing();
            return this.wizardDescriptor;
        }
        ProfilerDialogs.displayError((String)Bundle.ProfilingPointWizard_NoPpsFoundMsg());
        return null;
    }

    public synchronized void addChangeListener(ChangeListener listener) {
    }

    public WizardDescriptor.Panel current() {
        return this.getCurrentWizardPanel();
    }

    public ProfilingPoint finish(boolean cancelled) {
        ProfilingPoint result;
        ProfilingPoint profilingPoint = result = cancelled ? null : this.profilingPoint;
        if (this.wizardPanels != null) {
            this.wizardPanels[this.currentPanel].hiding(cancelled);
            for (int i = 0; i < this.wizardPanels.length; ++i) {
                this.wizardPanels[i].notifyClosed(cancelled);
            }
        }
        return result;
    }

    public boolean hasNext() {
        return this.currentPanel < this.wizardSteps.length - 1;
    }

    public boolean hasPrevious() {
        return this.currentPanel > 0;
    }

    public String name() {
        return this.getCurrentWizardPanel().getName();
    }

    public void nextPanel() {
        this.getCurrentWizardPanel().hiding(false);
        this.wizardDescriptor.putProperty("WizardPanel_contentSelectedIndex", (Object)(++this.currentPanel));
        this.getCurrentWizardPanel().showing();
    }

    public void previousPanel() {
        this.getCurrentWizardPanel().hiding(false);
        this.wizardDescriptor.putProperty("WizardPanel_contentSelectedIndex", (Object)(--this.currentPanel));
        this.getCurrentWizardPanel().showing();
    }

    public synchronized void removeChangeListener(ChangeListener listener) {
    }

    private WizardPanel getCurrentWizardPanel() {
        return this.wizardPanels[this.currentPanel];
    }

    private void initWizardDescriptor() {
        this.wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)this);
        this.wizardDescriptor.setTitle(Bundle.ProfilingPointWizard_WizardTitle());
        this.wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        this.wizardDescriptor.putProperty("WizardPanel_autoWizardStyle", (Object)Boolean.TRUE);
        this.wizardDescriptor.putProperty("WizardPanel_contentDisplayed", (Object)Boolean.TRUE);
        this.wizardDescriptor.putProperty("WizardPanel_contentNumbered", (Object)Boolean.TRUE);
        this.wizardDescriptor.putProperty("WizardPanel_contentSelectedIndex", (Object)0);
    }

    private void initWizardPanels() {
        this.ppFactories = ProfilingPointsManager.getDefault().getProfilingPointFactories();
        this.wizardPanels = new WizardPanel[]{new WizardPanel1(), new WizardPanel2()};
        this.wizardSteps = new String[this.wizardPanels.length];
        for (int i = 0; i < this.wizardPanels.length; ++i) {
            this.wizardSteps[i] = this.wizardPanels[i].getName();
        }
        this.wizardDescriptor.putProperty("WizardPanel_contentData", (Object)this.wizardSteps);
        if (this.preferredPanelSize == null) {
            this.preferredPanelSize = new Dimension(DEFAULT_PREFERRED_PANEL_SIZE);
            Dimension firstPanelSize = ((WizardPanel1UI)this.wizardPanels[0].getComponent()).getMinSize();
            this.preferredPanelSize.width = Math.max(this.preferredPanelSize.width, firstPanelSize.width);
            this.preferredPanelSize.height = Math.max(this.preferredPanelSize.height, firstPanelSize.height);
        }
    }

    static {
        DEFAULT_PREFERRED_PANEL_SIZE = new Dimension(440, 330);
    }

    private static class Singleton {
        private static final ProfilingPointWizard INSTANCE = new ProfilingPointWizard();

        private Singleton() {
        }
    }

    private abstract class WizardPanel
    implements WizardDescriptor.Panel,
    ValidityListener {
        protected boolean valid = true;
        private Component component;
        private EventListenerList listenerList = new EventListenerList();

        private WizardPanel() {
        }

        public abstract String getName();

        public Component getComponent() {
            if (this.component == null) {
                this.component = this.createComponent();
                this.component.setName(this.getName());
                this.component.setPreferredSize(ProfilingPointWizard.this.preferredPanelSize);
            }
            return this.component;
        }

        protected void resetComponent() {
            this.component = null;
        }

        public void setValid(boolean valid) {
            if (this.valid != valid) {
                this.valid = valid;
                this.fireChangeListenerStateChanged(this);
            }
        }

        public boolean isValid() {
            return this.valid;
        }

        public abstract Component createComponent();

        public synchronized void addChangeListener(ChangeListener listener) {
            this.listenerList.add(ChangeListener.class, listener);
        }

        public void hiding(boolean cancelled) {
        }

        public void notifyClosed(boolean cancelled) {
        }

        public void readSettings(Object settings) {
        }

        public synchronized void removeChangeListener(ChangeListener listener) {
            this.listenerList.remove(ChangeListener.class, listener);
        }

        public void showing() {
        }

        public void storeSettings(Object settings) {
        }

        @Override
        public void validityChanged(boolean isValid) {
            this.setValid(isValid);
        }

        protected void fireChangeListenerStateChanged(Object param) {
            ChangeEvent e = null;
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ChangeListener.class) continue;
                if (e == null) {
                    e = new ChangeEvent(param);
                }
                ((ChangeListener)listeners[i + 1]).stateChanged(e);
            }
        }
    }

    class WizardPanel2
    extends WizardPanel {
        private ValidityAwarePanel customizer;

        WizardPanel2() {
        }

        public HelpCtx getHelp() {
            if (!(this.customizer instanceof HelpCtx.Provider)) {
                return null;
            }
            return ((HelpCtx.Provider)this.customizer).getHelpCtx();
        }

        @Override
        public String getName() {
            return Bundle.ProfilingPointWizard_WizardStep2Caption();
        }

        @Override
        public Component createComponent() {
            JScrollPane customizerScrollPane = new JScrollPane(20, 30);
            customizerScrollPane.setBorder(BorderFactory.createEmptyBorder());
            customizerScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            customizerScrollPane.setOpaque(false);
            customizerScrollPane.getViewport().setOpaque(false);
            String hint = ProfilingPointWizard.this.ppFactories[ProfilingPointWizard.this.selectedPPFactoryIndex].getHint();
            if (hint != null && !hint.isEmpty()) {
                JPanel panel = new JPanel(new BorderLayout(0, 0));
                panel.setOpaque(false);
                panel.add((Component)customizerScrollPane, "Center");
                JTextArea area = new JTextArea(hint);
                area.setOpaque(false);
                area.setWrapStyleWord(true);
                area.setLineWrap(true);
                area.setEnabled(false);
                area.setFont(UIManager.getFont("Label.font"));
                area.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
                panel.add((Component)area, "South");
                return panel;
            }
            return customizerScrollPane;
        }

        @Override
        public void hiding(boolean cancelled) {
            if (!cancelled && ProfilingPointWizard.this.profilingPoint != null && this.customizer != null) {
                ProfilingPointWizard.this.profilingPoint.setValues(this.customizer);
            }
            this.unregisterCustomizerListener();
        }

        @Override
        public void notifyClosed(boolean cancelled) {
            this.releaseCurrentCustomizer();
            ProfilingPointWizard.this.profilingPoint = null;
        }

        @Override
        public void showing() {
            if (this.customizer == null || ProfilingPointWizard.this.settingsChanged) {
                this.releaseCurrentCustomizer();
                this.createNewCustomizer();
                ProfilingPointWizard.this.settingsChanged = false;
            }
            this.setValid(this.customizer.areSettingsValid());
            this.registerCustomizerListener();
        }

        private void createNewCustomizer() {
            ProfilingPointWizard.this.profilingPoint = ProfilingPointWizard.this.ppFactories[ProfilingPointWizard.this.selectedPPFactoryIndex].create(ProfilingPointWizard.this.selectedProject);
            this.customizer = ProfilingPointWizard.this.profilingPoint.getCustomizer();
            this.getContainer().setViewportView(this.customizer);
        }

        private void registerCustomizerListener() {
            if (this.customizer != null) {
                this.customizer.addValidityListener(this);
            }
        }

        private void releaseCurrentCustomizer() {
            this.resetComponent();
            this.customizer = null;
        }

        private void unregisterCustomizerListener() {
            if (this.customizer != null) {
                this.customizer.removeValidityListener(this);
            }
        }

        private JScrollPane getContainer() {
            Component container = this.getComponent();
            if (!(container instanceof JScrollPane)) {
                container = ((JComponent)container).getComponent(0);
            }
            if (!(container instanceof JScrollPane)) {
                container = ((JComponent)this.getComponent()).getComponent(1);
            }
            return (JScrollPane)container;
        }
    }

    class WizardPanel1
    extends WizardPanel {
        private Lookup.Provider selectedProjectRef;
        private int selectedPPFactoryIndexRef;

        WizardPanel1() {
        }

        public HelpCtx getHelp() {
            Component customizer = this.getComponent();
            if (!(customizer instanceof HelpCtx.Provider)) {
                return null;
            }
            return ((HelpCtx.Provider)customizer).getHelpCtx();
        }

        @Override
        public String getName() {
            return Bundle.ProfilingPointWizard_WizardStep1Caption();
        }

        @Override
        public Component createComponent() {
            WizardPanel1UI component = new WizardPanel1UI();
            component.addValidityListener(this);
            component.init(ProfilingPointWizard.this.ppFactories);
            this.setValid(component.areSettingsValid());
            if (component.hasDefaultScope()) {
                ProfilingPointWizard.this.selectedProject = component.getSelectedProject();
            }
            return component;
        }

        @Override
        public void hiding(boolean cancelled) {
            ProfilingPointWizard.this.selectedPPFactoryIndex = ((WizardPanel1UI)this.getComponent()).getSelectedIndex();
            if (ProfilingPointWizard.this.selectedPPFactoryIndex != this.selectedPPFactoryIndexRef) {
                ProfilingPointWizard.this.settingsChanged = true;
            }
            ProfilingPointWizard.this.selectedProject = ((WizardPanel1UI)this.getComponent()).getSelectedProject();
            if (ProfilingPointWizard.this.selectedProject == null || !ProfilingPointWizard.this.selectedProject.equals(this.selectedProjectRef)) {
                ProfilingPointWizard.this.settingsChanged = true;
            }
        }

        @Override
        public void showing() {
            this.selectedPPFactoryIndexRef = ProfilingPointWizard.this.selectedPPFactoryIndex;
            ((WizardPanel1UI)this.getComponent()).setSelectedIndex(ProfilingPointWizard.this.selectedPPFactoryIndex);
            this.selectedProjectRef = ProfilingPointWizard.this.selectedProject;
            if (ProfilingPointWizard.this.selectedProject == null) {
                ProfilingPointWizard.this.selectedProject = Utils.getCurrentProject();
            }
            ((WizardPanel1UI)this.getComponent()).setSelectedProject(ProfilingPointWizard.this.selectedProject);
        }
    }
}

