/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteSmtpCredentialRequest
extends BmcRequest<Void> {
    private String userId;
    private String smtpCredentialId;
    private String ifMatch;

    @ConstructorProperties(value={"userId", "smtpCredentialId", "ifMatch"})
    DeleteSmtpCredentialRequest(String userId, String smtpCredentialId, String ifMatch) {
        this.userId = userId;
        this.smtpCredentialId = smtpCredentialId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().userId(this.userId).smtpCredentialId(this.smtpCredentialId).ifMatch(this.ifMatch);
    }

    public String toString() {
        return "DeleteSmtpCredentialRequest(super=" + super.toString() + ", userId=" + this.getUserId() + ", smtpCredentialId=" + this.getSmtpCredentialId() + ", ifMatch=" + this.getIfMatch() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteSmtpCredentialRequest)) {
            return false;
        }
        DeleteSmtpCredentialRequest other = (DeleteSmtpCredentialRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$smtpCredentialId = this.getSmtpCredentialId();
        String other$smtpCredentialId = other.getSmtpCredentialId();
        if (this$smtpCredentialId == null ? other$smtpCredentialId != null : !this$smtpCredentialId.equals(other$smtpCredentialId)) {
            return false;
        }
        String this$ifMatch = this.getIfMatch();
        String other$ifMatch = other.getIfMatch();
        return !(this$ifMatch == null ? other$ifMatch != null : !this$ifMatch.equals(other$ifMatch));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeleteSmtpCredentialRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $smtpCredentialId = this.getSmtpCredentialId();
        result = result * 59 + ($smtpCredentialId == null ? 43 : $smtpCredentialId.hashCode());
        String $ifMatch = this.getIfMatch();
        result = result * 59 + ($ifMatch == null ? 43 : $ifMatch.hashCode());
        return result;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getSmtpCredentialId() {
        return this.smtpCredentialId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteSmtpCredentialRequest, Void> {
        private String userId;
        private String smtpCredentialId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteSmtpCredentialRequest o) {
            this.userId(o.getUserId());
            this.smtpCredentialId(o.getSmtpCredentialId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteSmtpCredentialRequest build() {
            DeleteSmtpCredentialRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder smtpCredentialId(String smtpCredentialId) {
            this.smtpCredentialId = smtpCredentialId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public DeleteSmtpCredentialRequest buildWithoutInvocationCallback() {
            return new DeleteSmtpCredentialRequest(this.userId, this.smtpCredentialId, this.ifMatch);
        }

        public String toString() {
            return "DeleteSmtpCredentialRequest.Builder(userId=" + this.userId + ", smtpCredentialId=" + this.smtpCredentialId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

