/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.completion.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.xml.namespace.QName;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.xml.axi.AbstractAttribute;
import org.netbeans.modules.xml.axi.Element;
import org.netbeans.modules.xml.schema.completion.spi.CompletionContext;
import org.netbeans.modules.xml.schema.completion.spi.CompletionModelProvider;
import org.netbeans.modules.xml.schema.completion.util.CompletionUtil;
import org.netbeans.modules.xml.schema.completion.util.DefaultModelProvider;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.text.api.dom.SyntaxElement;
import org.netbeans.modules.xml.text.api.dom.XMLSyntaxSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class CompletionContextImpl
extends CompletionContext {
    public static final String PREFIX = "ns";
    public static final String XSI_SCHEMALOCATION = "schemaLocation";
    public static final String XSI_NONS_SCHEMALOCATION = "noNamespaceSchemaLocation";
    private static final String XSD_TARGET_NAMESPACE = "targetNamespace";
    private static final Logger _logger = Logger.getLogger(CompletionContextImpl.class.getName());
    private XMLSyntaxSupport support;
    private int completionAtOffset = -1;
    private FileObject primaryFile;
    private String typedChars;
    private Token<XMLTokenId> token;
    private int tokenOffset;
    private SyntaxElement element;
    private String attribute;
    private CompletionUtil.DocRoot docRoot;
    private char lastTypedChar;
    private CompletionContext.CompletionType completionType = CompletionContext.CompletionType.COMPLETION_TYPE_UNKNOWN;
    private List<QName> pathFromRoot;
    private List<SyntaxElement> elementsFromRoot;
    private Map<String, String> schemaLocationMap = new HashMap<String, String>();
    private String schemaLocation;
    private String noNamespaceSchemaLocation;
    private String defaultNamespace;
    private Document document;
    private HashMap<String, CompletionModelProvider.CompletionModel> nsModelMap = new HashMap();
    private List<CompletionModelProvider.CompletionModel> noNSModels = new ArrayList<CompletionModelProvider.CompletionModel>();
    private HashMap<String, String> declaredNamespaces = new HashMap();
    private HashMap<String, String> suggestedNamespaces = new HashMap();
    private HashMap<String, String> specialNamespaceMap = new HashMap();
    private CompletionModelProvider.CompletionModel noNamespaceModel;
    private transient List<String> existingAttributes;
    private boolean specialCompletion;
    private String targetNamespace;

    public CompletionContextImpl(FileObject primaryFile, XMLSyntaxSupport support, int offset) {
        try {
            this.support = support;
            this.completionAtOffset = offset;
            this.primaryFile = primaryFile;
            this.document = support.getDocument();
            this.element = support.getElementChain(offset);
            int[] off = new int[2];
            this.token = support.getPreviousToken(offset, off);
            this.tokenOffset = off[0];
            this.docRoot = CompletionUtil.getDocRoot(this.document);
            this.lastTypedChar = support.lastTypedChar();
            this.populateNamespaces();
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, ex.getMessage());
        }
    }

    @Override
    public CompletionContext.CompletionType getCompletionType() {
        return this.completionType;
    }

    @Override
    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    @Override
    public List<QName> getPathFromRoot() {
        return this.pathFromRoot;
    }

    @Override
    public FileObject getPrimaryFile() {
        return this.primaryFile;
    }

    @Override
    public BaseDocument getBaseDocument() {
        return (BaseDocument)this.document;
    }

    @Override
    public HashMap<String, String> getDeclaredNamespaces() {
        return this.declaredNamespaces;
    }

    @Override
    public String getTypedChars() {
        return this.typedChars;
    }

    public boolean isSchemaAwareCompletion() {
        return this.schemaLocation != null || this.noNamespaceSchemaLocation != null;
    }

    public Map<String, String> getSuggestedNamespace() {
        return Collections.unmodifiableMap(this.suggestedNamespaces);
    }

    public List<URI> getSchemas() {
        ArrayList<URI> uris = new ArrayList<URI>();
        if (this.schemaLocation != null) {
            CompletionUtil.loadSchemaURIs(this.schemaLocation, uris, this.schemaLocationMap);
            return uris;
        }
        if (this.noNamespaceSchemaLocation != null) {
            CompletionUtil.loadSchemaURIs(this.noNamespaceSchemaLocation, uris, null);
            return uris;
        }
        return uris;
    }

    private String getPrefix(String tagName, boolean empty) {
        int index = tagName.indexOf(58);
        if (index == -1) {
            return empty ? "" : null;
        }
        return tagName.substring(index + 1);
    }

    private void addNamespacesFrom(SyntaxElement s) {
        Node e = s.getNode();
        NamedNodeMap attrs = e.getAttributes();
        String nodePrefix = this.getPrefix(e.getNodeName(), false);
        String version = null;
        String xsltAttrName = null;
        for (int i = attrs.getLength() - 1; i >= 0; --i) {
            Node n = attrs.item(i);
            if (n.getNodeType() != 2) continue;
            Attr a = (Attr)n;
            String attrName = a.getName();
            String value = a.getValue();
            this.addNamespace(attrName, value, nodePrefix);
            if (value.trim().equals("http://www.w3.org/1999/XSL/Transform")) {
                xsltAttrName = attrName;
            }
            if (!CompletionUtil.getLocalNameFromTag(attrName).equals("version")) continue;
            version = value.trim();
        }
        if (xsltAttrName != null && "2.0".equals(version)) {
            String prefix = this.getPrefix(xsltAttrName, false);
            if (prefix == null) {
                this.noNamespaceSchemaLocation = "http://www.w3.org/2007/schema-for-xslt20.xsd";
            } else {
                this.addSchemaLocation(prefix + " http://www.w3.org/2007/schema-for-xslt20.xsd");
            }
        }
    }

    private void addContextNamespaces(List<SyntaxElement> stack) {
        for (int i = stack.size() - 1; i >= 0; --i) {
            SyntaxElement t = stack.get(i);
            this.addNamespacesFrom(t);
        }
    }

    private void addNamespace(String attrName, String value, String nodePrefix) {
        String defNS = "xmlns";
        if (CompletionUtil.getLocalNameFromTag(attrName).equals(XSI_SCHEMALOCATION)) {
            this.schemaLocation = value.trim();
            return;
        }
        if (CompletionUtil.getLocalNameFromTag(attrName).equals(XSI_NONS_SCHEMALOCATION)) {
            this.noNamespaceSchemaLocation = value.trim();
            return;
        }
        if (CompletionUtil.getLocalNameFromTag(attrName).equals(XSD_TARGET_NAMESPACE)) {
            this.targetNamespace = value.trim();
            return;
        }
        if (!attrName.startsWith("xmlns")) {
            return;
        }
        if (attrName.equals(defNS)) {
            this.defaultNamespace = value;
        }
        this.declaredNamespaces.put(attrName, value);
    }

    private void addSchemaLocation(String s) {
        this.schemaLocation = this.schemaLocation == null ? s : this.schemaLocation + " " + s;
    }

    private void populateNamespaces() {
        if (this.docRoot == null) {
            return;
        }
        String tagName = this.docRoot.getName();
        String defNS = "xmlns";
        String temp = CompletionUtil.getPrefixFromTag(tagName);
        if (temp != null) {
            defNS = defNS + ":" + temp;
        }
        List<CompletionUtil.DocRootAttribute> attributes = this.docRoot.getAttributes();
        String version = null;
        boolean xsltDeclared = false;
        for (int index = 0; index < attributes.size(); ++index) {
            CompletionUtil.DocRootAttribute attr = attributes.get(index);
            String attrName = attr.getName();
            String value = attr.getValue();
            this.addNamespace(attrName, value, temp);
            if (attr.getValue().trim().equals("http://www.w3.org/1999/XSL/Transform")) {
                xsltDeclared = true;
            }
            if (!CompletionUtil.getLocalNameFromTag(attrName).equals("version")) continue;
            version = attr.getValue().trim();
        }
        if (this.schemaLocation == null && xsltDeclared && "2.0".equals(version)) {
            this.schemaLocation = "schema http://www.w3.org/2007/schema-for-xslt20.xsd";
        }
    }

    private TokenSequence getTokenSequence() {
        TokenSequence tokenSequence = null;
        try {
            ((AbstractDocument)this.document).readLock();
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.document);
            tokenSequence = tokenHierarchy.tokenSequence();
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, e.getMessage() == null ? e.getClass().getName() : e.getMessage(), e);
        }
        finally {
            ((AbstractDocument)this.document).readUnlock();
        }
        return tokenSequence;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isTagAttributeRequired(TokenSequence tokenSequence) {
        int caretPos = this.completionAtOffset;
        int diff = tokenSequence.move(caretPos);
        tokenSequence.moveNext();
        Token tok = tokenSequence.token();
        if (tok == null) {
            return false;
        }
        TokenId tokID = tok.id();
        if (tokID.equals(XMLTokenId.TAG) && CompletionUtil.isEndTagSuffix(tok) && tokenSequence.offset() + 1 == caretPos) {
            return false;
        }
        boolean isAttributeOrSpace = tokID.equals(XMLTokenId.ARGUMENT) || tokID.equals(XMLTokenId.WS);
        boolean isTagLastCharFound = tokID.equals(XMLTokenId.TAG) && (CompletionUtil.isTagLastChar(tok) || CompletionUtil.isEndTagSuffix(tok));
        boolean isJustBeforeTagErrorToken = false;
        if (tokID.equals(XMLTokenId.ERROR)) {
            isJustBeforeTagErrorToken = tokID.equals(XMLTokenId.ERROR);
            String tokenText = tok.text().toString();
            boolean bl = isJustBeforeTagErrorToken = tokenText.subSequence(0, diff).toString().trim().isEmpty() || diff == 0;
        }
        do {
            if (tokID.equals(XMLTokenId.TAG) || tokID.equals(XMLTokenId.TEXT)) {
                int tokOffset;
                int tagNameEndPos;
                String tagName;
                if (CompletionUtil.isEndTagPrefix(tok)) return false;
                if (tokID.equals(XMLTokenId.TAG) && (tagName = CompletionUtil.getTokenTagName(tok)) != null && (tagNameEndPos = (tokOffset = tokenSequence.offset()) + "<".length() + tagName.length()) < caretPos && (isAttributeOrSpace || isTagLastCharFound || isJustBeforeTagErrorToken)) {
                    return true;
                }
            }
            if (!tokenSequence.movePrevious()) return false;
            tok = tokenSequence.token();
            tokID = tok.id();
        } while (!CompletionUtil.isEndTagSuffix(tok) && !CompletionUtil.isTagLastChar(tok));
        return false;
    }

    public boolean initContext() {
        boolean res = this.doInitContext();
        if (this.pathFromRoot != null) {
            this.addContextNamespaces(this.elementsFromRoot);
        } else {
            this.populateNamespaces();
        }
        return res;
    }

    private boolean doInitContext() {
        TokenSequence tokenSequence = this.getTokenSequence();
        try {
            if (this.isTagAttributeRequired(tokenSequence)) {
                this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_ATTRIBUTE;
                if (this.token.id() == XMLTokenId.WS) {
                    this.typedChars = null;
                } else {
                    String str = this.token.text().toString();
                    int e = str.length();
                    int l = Math.min(this.completionAtOffset - this.tokenOffset, e);
                    this.typedChars = str.substring(0, l).trim();
                    if (this.typedChars.isEmpty()) {
                        this.typedChars = null;
                    }
                }
                this.createPathFromRoot(this.element);
                return true;
            }
            XMLTokenId id = (XMLTokenId)this.token.id();
            switch (id) {
                case TEXT: {
                    String previousTokenText;
                    String chars = this.token.text().toString().trim();
                    Token previous = this.support.getPreviousToken(this.tokenOffset);
                    String string = previousTokenText = previous == null ? "" : previous.text().toString().trim();
                    if (chars != null && chars.startsWith("&")) {
                        this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_UNKNOWN;
                        break;
                    }
                    if (chars != null && chars.equals("") && previousTokenText.endsWith(">")) {
                        this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_ELEMENT;
                        this.createPathFromRoot(this.element);
                        break;
                    }
                    if (chars != null && chars.startsWith("<")) {
                        this.typedChars = chars.substring(1);
                        this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_ELEMENT;
                        this.createPathFromRoot(this.element);
                        break;
                    }
                    if (chars != null && previousTokenText.equals(">")) {
                        if (!chars.equals("") && !chars.equals(">")) {
                            this.typedChars = chars;
                        }
                        this.createPathFromRoot(this.element);
                        this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_ELEMENT_VALUE;
                        break;
                    }
                    if (chars != null && !chars.equals("<") && previousTokenText.equals(">")) {
                        this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_UNKNOWN;
                    }
                    break;
                }
                case BLOCK_COMMENT: {
                    this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_ELEMENT;
                    this.createPathFromRoot(this.element);
                    break;
                }
                case TAG: {
                    if (this.support.isEndTag(this.element)) {
                        this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_UNKNOWN;
                        break;
                    }
                    if (this.support.isEmptyTag(this.element)) {
                        String tagName = this.element.getNode().getNodeName();
                        if (this.element.getElementOffset() + 1 == this.completionAtOffset || this.tokenOffset + this.token.length() == this.completionAtOffset) {
                            this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_ELEMENT;
                            this.createPathFromRoot(this.element.getPrevious());
                            break;
                        }
                        if (this.completionAtOffset > this.element.getElementOffset() + 1 && this.completionAtOffset <= this.element.getElementOffset() + 1 + tagName.length()) {
                            this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_ELEMENT;
                            int index = this.completionAtOffset - this.element.getElementOffset() - 1;
                            this.typedChars = index < 0 ? tagName : tagName.substring(0, index);
                            this.createPathFromRoot(this.element.getPrevious());
                        }
                        break;
                    }
                    if (this.element.getType() == 1 && this.support.isStartTag(this.element)) {
                        if (this.token != null && this.token.text().toString().trim().equals(">")) {
                            this.createPathFromRoot(this.element);
                            this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_ELEMENT_VALUE;
                            break;
                        }
                        if (this.element.getElementOffset() + 1 == this.completionAtOffset) {
                            this.typedChars = null;
                        } else {
                            String tagName = this.element.getNode().getNodeName();
                            int index = this.completionAtOffset - this.element.getElementOffset() - 1;
                            this.typedChars = index < 0 ? tagName : tagName.substring(0, index);
                        }
                    }
                    this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_ELEMENT;
                    this.createPathFromRoot(this.element.getPrevious());
                    break;
                }
                case ARGUMENT: {
                    break;
                }
                case CHARACTER: {
                    this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_UNKNOWN;
                    break;
                }
                case OPERATOR: {
                    this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_UNKNOWN;
                    break;
                }
                case VALUE: {
                    String str;
                    Token next = this.support.getNextToken(this.tokenOffset + this.token.length());
                    if (next == null) {
                        if (this.lastTypedChar == '\'' || this.lastTypedChar == '\"') {
                            this.typedChars = null;
                        } else {
                            String tt = this.token.text().toString();
                            this.typedChars = tt.substring(1, tt.indexOf(">"));
                        }
                    }
                    if (this.lastTypedChar != '\'' && this.lastTypedChar != '\"' && (str = this.token.text().toString()) != null && !str.equals("\"\"") && !str.equals("''") && (str.startsWith("\"") || str.startsWith("'")) && (str.endsWith("\"") || str.endsWith("'"))) {
                        int e = str.length() - 1;
                        int l = Math.min(this.completionAtOffset - this.tokenOffset, e);
                        this.typedChars = str.substring(1, l);
                        if (this.completionAtOffset == this.tokenOffset + 1) {
                            this.typedChars = "";
                        }
                    }
                    this.attribute = this.findAttributeName();
                    this.completionType = this.attribute == null ? CompletionContext.CompletionType.COMPLETION_TYPE_UNKNOWN : CompletionContext.CompletionType.COMPLETION_TYPE_ATTRIBUTE_VALUE;
                    this.createPathFromRoot(this.element);
                    break;
                }
                case WS: {
                    this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_UNKNOWN;
                    boolean cont = (Boolean)this.support.runWithSequence(this.tokenOffset, ts -> {
                        if (!ts.movePrevious()) {
                            return false;
                        }
                        Token prev = ts.token();
                        while (ts.movePrevious() && (prev = ts.token()).id() == XMLTokenId.WS) {
                        }
                        if (prev.id() == XMLTokenId.VALUE || prev.id() == XMLTokenId.TAG) {
                            if (prev.text().toString().startsWith("</")) {
                                return true;
                            }
                            this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_ATTRIBUTE;
                            this.createPathFromRoot(this.element);
                        }
                        return false;
                    });
                    break;
                }
                default: {
                    this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_UNKNOWN;
                    break;
                }
            }
        }
        catch (Exception e) {
            _logger.log(Level.INFO, e.getMessage() == null ? e.getClass().getName() : e.getMessage(), e);
            return false;
        }
        return true;
    }

    private String findAttributeName() {
        try {
            return (String)this.support.runWithSequence(this.tokenOffset, ts -> {
                Token item = ts.token();
                block4: while (item != null) {
                    switch ((XMLTokenId)item.id()) {
                        case TEXT: 
                        case OPERATOR: 
                        case VALUE: 
                        case WS: {
                            if (!ts.movePrevious()) {
                                return null;
                            }
                            item = ts.token();
                            continue block4;
                        }
                        case ARGUMENT: {
                            return item.text().toString();
                        }
                    }
                    return null;
                }
                return null;
            });
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public List<CompletionUtil.DocRootAttribute> getDocRootAttributes() {
        return this.docRoot.getAttributes();
    }

    public CompletionUtil.DocRoot getDocRoot() {
        return this.docRoot;
    }

    public String getAttribute() {
        return this.attribute;
    }

    private void createPathFromRoot(SyntaxElement se) {
        if (se == null) {
            return;
        }
        Stack<SyntaxElement> stack = new Stack<SyntaxElement>();
        if (this.support.isEmptyTag(se)) {
            stack.push(se);
        }
        while (se != null) {
            if (stack.isEmpty() && this.support.isStartTag(se) || this.support.isEndTag(se)) {
                stack.push(se);
                se = se.getPrevious();
                continue;
            }
            if (this.support.isStartTag(se)) {
                SyntaxElement end;
                SyntaxElement syntaxElement = end = stack.isEmpty() ? null : stack.peek();
                if (this.support.isEndTag(end)) {
                    if (end.getNode().getNodeName().equals(se.getNode().getNodeName())) {
                        stack.pop();
                    }
                } else {
                    stack.push(se);
                }
            }
            se = se.getPrevious();
        }
        this.elementsFromRoot = stack;
        this.pathFromRoot = this.createPath(stack);
    }

    private ArrayList<QName> createPath(Stack<SyntaxElement> stack) {
        ArrayList<QName> path = new ArrayList<QName>();
        ListIterator tags = stack.listIterator();
        while (tags.hasNext()) {
            SyntaxElement tag = (SyntaxElement)tags.next();
            path.add(0, this.createQName(tag));
            if (this.isRoot(tag, tags.hasNext() ? (SyntaxElement)tags.next() : null)) {
                return path;
            }
            tags.previous();
        }
        return path;
    }

    private boolean isRoot(SyntaxElement elem, SyntaxElement previousTag) {
        String namespace;
        Node thisTag = elem.getNode();
        if (previousTag == null) {
            return true;
        }
        String prefix = CompletionUtil.getPrefixFromTag(thisTag.getNodeName());
        Attr namespaceAttr = null;
        NamedNodeMap attrs = thisTag.getAttributes();
        namespaceAttr = prefix == null ? (Attr)attrs.getNamedItem("xmlns") : (Attr)attrs.getNamedItem("xmlns:" + prefix);
        if (namespaceAttr != null && !(namespace = namespaceAttr.getValue()).equals(this.defaultNamespace)) {
            String nnsl;
            String sl = this.getAttributeValue(thisTag, XSI_SCHEMALOCATION);
            if (sl != null) {
                this.schemaLocation = sl;
            }
            if ((nnsl = this.getAttributeValue(thisTag, XSI_NONS_SCHEMALOCATION)) != null) {
                this.noNamespaceSchemaLocation = nnsl;
            }
            if (prefix != null) {
                this.declaredNamespaces.put("xmlns:" + prefix, namespace);
            }
            return true;
        }
        return !this.fromSameNamespace(thisTag, previousTag.getNode());
    }

    private String getAttributeValue(Node tag, String attrName) {
        NamedNodeMap attrs = tag.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String name = attr.getNodeName();
            if (name == null || !name.contains(attrName)) continue;
            return attr.getNodeValue();
        }
        return null;
    }

    private QName createQName(SyntaxElement tag) {
        String tagName = tag.getNode().getNodeName();
        String prefix = CompletionUtil.getPrefixFromTag(tagName);
        String lName = CompletionUtil.getLocalNameFromTag(tagName);
        int index = this.elementsFromRoot.indexOf(tag);
        if (index == -1) {
            throw new IllegalStateException();
        }
        for (int i = index; i < this.elementsFromRoot.size(); ++i) {
            Attr attrNode;
            SyntaxElement s = this.elementsFromRoot.get(i);
            NamedNodeMap atts = s.getNode().getAttributes();
            if (prefix == null) {
                attrNode = (Attr)atts.getNamedItem("xmlns");
                if (attrNode == null) continue;
                return new QName(attrNode.getValue(), lName);
            }
            attrNode = (Attr)atts.getNamedItem("xmlns:" + prefix);
            if (attrNode == null) continue;
            return new QName(attrNode.getValue(), lName, prefix);
        }
        if (prefix == null) {
            return new QName(this.defaultNamespace, lName);
        }
        return new QName(null, lName, prefix);
    }

    private boolean fromSameNamespace(Node current, Node previous) {
        String prevPrefix = CompletionUtil.getPrefixFromTag(previous.getNodeName());
        String thisPrefix = CompletionUtil.getPrefixFromTag(current.getNodeName());
        String thisNS = thisPrefix == null ? this.declaredNamespaces.get("xmlns") : this.declaredNamespaces.get("xmlns:" + thisPrefix);
        String prevNS = prevPrefix == null ? this.declaredNamespaces.get("xmlns") : this.declaredNamespaces.get("xmlns:" + prevPrefix);
        return thisNS == null && prevNS == null || thisNS != null && thisNS.equals(prevNS) || prevNS != null && prevNS.equals(thisNS);
    }

    public CompletionModelProvider.CompletionModel getActiveNoNSModel() {
        return this.noNamespaceModel;
    }

    public HashMap<String, CompletionModelProvider.CompletionModel> getCompletionModelMap() {
        return this.nsModelMap;
    }

    public List<CompletionModelProvider.CompletionModel> getNoNamespaceModels() {
        return this.noNSModels;
    }

    public List<CompletionModelProvider.CompletionModel> getCompletionModels() {
        ArrayList<CompletionModelProvider.CompletionModel> models = new ArrayList<CompletionModelProvider.CompletionModel>();
        models.addAll(this.nsModelMap.values());
        models.addAll(this.noNSModels);
        return models;
    }

    public void addCompletionModel(CompletionModelProvider.CompletionModel cm) {
        String tns = cm.getTargetNamespace();
        if (tns == null && !this.noNSModels.contains(cm)) {
            this.noNSModels.add(cm);
            return;
        }
        if (this.nsModelMap.get(tns) == null) {
            this.nsModelMap.put(tns, cm);
        }
    }

    public boolean initModels() {
        Lookup.Template templ = new Lookup.Template(CompletionModelProvider.class);
        Lookup.Result result = Lookup.getDefault().lookup(templ);
        Collection impls = result.allInstances();
        if (impls == null || impls.size() == 0) {
            return false;
        }
        for (Object obj : impls) {
            CompletionModelProvider modelProvider = (CompletionModelProvider)obj;
            List<CompletionModelProvider.CompletionModel> models = modelProvider.getModels(this);
            if (models == null || models.size() == 0) continue;
            for (CompletionModelProvider.CompletionModel m : models) {
                this.populateModelMap(m);
            }
        }
        if (this.noNamespaceSchemaLocation != null && this.noNSModels.size() == 1) {
            this.noNamespaceModel = this.noNSModels.get(0);
        }
        this.specialCompletion();
        return this.nsModelMap.size() != 0 || this.noNSModels.size() != 0;
    }

    private void populateModelMap(CompletionModelProvider.CompletionModel m) {
        String tns;
        Schema schema;
        SchemaModel sm;
        if (m != null && (sm = m.getSchemaModel()) != null && (schema = sm.getSchema()) != null && (tns = schema.getTargetNamespace()) != null) {
            this.nsModelMap.put(tns, m);
            return;
        }
        this.noNSModels.add(m);
    }

    private void specialCompletion() {
        if (this.primaryFile == null) {
            return;
        }
        for (String temp : this.declaredNamespaces.values()) {
            try {
                CompletionModelProvider.CompletionModel cm;
                if (this.nsModelMap.containsKey(temp) || this.schemaLocationMap.get(temp) != null || temp.equals(this.targetNamespace) || (cm = DefaultModelProvider.getCompletionModel(new URI(temp), true, this)) == null) continue;
                this.populateModelMap(cm);
            }
            catch (Exception ex) {
                _logger.log(Level.INFO, ex.getLocalizedMessage(), ex);
            }
        }
    }

    String suggestPrefix(String tns) {
        String ns;
        String key;
        if (tns == null) {
            return null;
        }
        if (this.specialNamespaceMap.containsKey(tns)) {
            return this.specialNamespaceMap.get(tns);
        }
        for (Map.Entry<String, String> entry : this.getDeclaredNamespaces().entrySet()) {
            key = entry.getKey();
            ns = entry.getValue();
            if (!ns.equals(tns)) continue;
            return key;
        }
        for (Map.Entry<String, String> entry : this.suggestedNamespaces.entrySet()) {
            key = entry.getKey();
            ns = entry.getValue();
            if (!ns.equals(tns)) continue;
            return key;
        }
        int index = this.suggestedNamespaces.size() + 1;
        String prefix = PREFIX + index;
        String nsDecl = "xmlns:" + prefix;
        while (this.getDeclaredNamespaces().get(nsDecl) != null) {
            prefix = PREFIX + index++;
            nsDecl = "xmlns:" + prefix;
        }
        this.suggestedNamespaces.put(prefix, tns);
        return prefix;
    }

    public boolean isPrefixBeingUsed(String prefix) {
        return this.getDeclaredNamespaces().get("xmlns:" + prefix) != null;
    }

    public Boolean prefixConflicts(String prefix, String namespaceURI) {
        String n = this.getDeclaredNamespaces().get("xmlns:" + prefix);
        if (n == null) {
            return null;
        }
        return n.equals(namespaceURI);
    }

    public boolean isSpecialCompletion() {
        return this.specialCompletion;
    }

    public boolean canReplace(String text) {
        String name;
        if (this.completionType == CompletionContext.CompletionType.COMPLETION_TYPE_ELEMENT && this.element.getType() == 1 && (name = this.element.getNode().getNodeName()) != null && name.equals(this.typedChars) && text.equals(name)) {
            return false;
        }
        if (this.completionType == CompletionContext.CompletionType.COMPLETION_TYPE_ATTRIBUTE) {
            Element e = CompletionUtil.findAXIElementAtContext(this);
            for (AbstractAttribute a : e.getAttributes()) {
                if (!a.getName().equals(this.typedChars)) continue;
                return false;
            }
        }
        return true;
    }

    public String getTargetNamespaceByPrefix(String prefix) {
        for (CompletionModelProvider.CompletionModel cm : this.getCompletionModelMap().values()) {
            if (!prefix.equals(cm.getSuggestedPrefix())) continue;
            return cm.getTargetNamespace();
        }
        return null;
    }

    List<String> getExistingAttributes() {
        if (this.existingAttributes != null) {
            return this.existingAttributes;
        }
        this.existingAttributes = new ArrayList<String>();
        try {
            this.support.runWithSequence(this.tokenOffset, ts -> {
                Token item;
                if (ts.movePrevious()) {
                    return null;
                }
                while (ts.movePrevious() && (item = ts.token()).id() != XMLTokenId.TAG) {
                    if (item.id() != XMLTokenId.ARGUMENT) continue;
                    this.existingAttributes.add(item.text().toString());
                }
                return null;
            });
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return this.existingAttributes;
    }
}

