/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.FileUtils;

public class ShorterPaths
extends Task {
    private List<Replacement> replacements = new LinkedList<Replacement>();
    private Path in;
    String out;
    String extraLibs;
    File extraLibsDir;
    File testProperties;

    public Replacement createReplacement() {
        Replacement r = new Replacement();
        this.replacements.add(r);
        return r;
    }

    public void addReplacement(Replacement r) {
        this.replacements.add(r);
    }

    public void setIn(Path p) {
        if (this.in == null) {
            this.in = p.createPath();
        }
        this.in.append(p);
    }

    public Path createIn() {
        if (this.in == null) {
            this.in = new Path(this.getProject());
        }
        return this.in;
    }

    public void setinRef(Reference r) {
        this.createIn().setRefid(r);
    }

    public void setOut(String out) {
        this.out = out;
    }

    public void setExtraLibs(String extraLibs) {
        this.extraLibs = extraLibs;
    }

    public void setExtraLibsDir(File extraLibsDir) {
        this.extraLibsDir = extraLibsDir;
    }

    public void setTestProperties(File testProperties) {
        this.testProperties = testProperties;
    }

    public void execute() throws BuildException {
        block15: {
            String[] paths = this.in.list();
            StringBuffer nbLibBuff = new StringBuffer();
            StringBuffer externalLibBuf = new StringBuffer();
            try {
                for (int i = 0; i < paths.length; ++i) {
                    String path = paths[i];
                    File file = new File(path);
                    if (file.exists()) {
                        path = file.getCanonicalPath();
                        this.simplyPath(path, externalLibBuf, nbLibBuff);
                        continue;
                    }
                    this.log("Path element " + file + " doesn't exist.", 3);
                }
                if (this.out != null) {
                    this.define(this.out, nbLibBuff.toString());
                }
                if (this.extraLibs != null) {
                    this.define(this.extraLibs, externalLibBuf.toString());
                }
                if (this.testProperties == null) break block15;
                try (PrintWriter pw = new PrintWriter(this.testProperties);){
                    Hashtable properties = this.getProject().getProperties();
                    StringBuffer outProp = new StringBuffer();
                    for (Map.Entry it : properties.entrySet()) {
                        String name = (String)it.getKey();
                        if (name.matches("test-(unit|qa-functional)-sys-prop\\..+")) {
                            if (name.equals("test-unit-sys-prop.xtest.data")) continue;
                            outProp.setLength(0);
                            for (String path : ShorterPaths.tokenizePath(it.getValue().toString())) {
                                this.replacePath(path, outProp);
                            }
                            pw.println(name.replaceFirst("^test-(unit|qa-functional)-sys-prop\\.", "test-sys-prop.") + "=" + outProp);
                            continue;
                        }
                        if (name.startsWith("test.config")) {
                            pw.println(name + "=" + it.getValue());
                            continue;
                        }
                        if (!"requires.nb.javac".equals(name)) continue;
                        pw.println(name + "=" + it.getValue());
                    }
                    pw.println("extra.test.libs=" + externalLibBuf.toString());
                    pw.println("test.run.cp=" + nbLibBuff.toString());
                }
            }
            catch (IOException ex) {
                throw new BuildException((Throwable)ex);
            }
        }
    }

    private void simplyPath(String path, StringBuffer externalLibBuf, StringBuffer nbLibBuff) throws IOException {
        boolean bAppend = false;
        File file = new File(path);
        if (file.exists()) {
            String fName;
            path = file.getAbsolutePath();
            for (Replacement repl : this.replacements) {
                String dirCan = repl.dir.getCanonicalPath();
                if (!path.startsWith(dirCan) || repl.excluded != null && path.startsWith(repl.excluded.getCanonicalPath())) continue;
                if (nbLibBuff.length() > 0) {
                    nbLibBuff.append(":\\\n");
                }
                nbLibBuff.append("${").append(repl.name).append("}");
                nbLibBuff.append(path.substring(dirCan.length()).replace(File.separatorChar, '/'));
                bAppend = true;
                break;
            }
            if (!bAppend && (fName = this.copyExtraLib(file)) != null) {
                if (externalLibBuf.length() > 0) {
                    externalLibBuf.append(":\\\n");
                }
                externalLibBuf.append("${extra.test.libs.dir}/").append(fName);
            }
        } else {
            if (nbLibBuff.length() > 0) {
                nbLibBuff.append(":\\\n");
            }
            nbLibBuff.append(path);
        }
    }

    private void replacePath(String path, StringBuffer pathsBuff) throws IOException {
        File file = new File(path);
        if (file.exists()) {
            path = file.getAbsolutePath();
        }
        boolean replacementFound = false;
        if (pathsBuff.length() > 0) {
            pathsBuff.append(":\\\n");
        }
        for (Replacement repl : this.replacements) {
            String dirCan = repl.dir.getCanonicalPath();
            if (!path.startsWith(dirCan)) continue;
            pathsBuff.append("${").append(repl.name).append("}");
            pathsBuff.append(path.substring(dirCan.length()).replace(File.separatorChar, '/'));
            replacementFound = true;
            break;
        }
        if (!replacementFound) {
            pathsBuff.append(path.replace(File.separatorChar, '/'));
        }
    }

    private void define(String prop, String val) {
        this.log("Setting " + prop + "=" + val, 3);
        String old = this.getProject().getProperty(prop);
        if (old != null && !old.equals(val)) {
            this.getProject().log("Warning: " + prop + " was already set to " + old, 1);
        }
        this.getProject().setNewProperty(prop, val);
    }

    private String copyExtraLib(File file) throws IOException {
        if (this.extraLibsDir == null || !this.extraLibsDir.isDirectory() || !file.isFile()) {
            return null;
        }
        File copy = new File(this.extraLibsDir, file.getName());
        boolean wasCopied = this.copyMissing(file, copy);
        if (wasCopied && file.getName().endsWith(".jar")) {
            String cp;
            try (JarFile jf = new JarFile(file);){
                Manifest manifest = jf.getManifest();
                cp = manifest != null ? manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH) : null;
            }
            catch (IOException x) {
                this.log("Could not parse " + file + " for Class-Path", 1);
                cp = null;
            }
            if (cp != null) {
                for (String ext : cp.split(" ")) {
                    this.copyMissing(new File(file.getParentFile(), ext), new File(this.extraLibsDir, ext));
                }
            }
        }
        return copy.getName();
    }

    private boolean copyMissing(File file, File copy) throws IOException {
        if (FileUtils.getFileUtils().contentEquals(file, copy)) {
            return false;
        }
        if (copy.isFile()) {
            throw new IOException(file + " is not the same as " + copy + "; will not overwrite");
        }
        this.log("Copying " + file + " to extralibs despite " + this.replacements);
        FileUtils.getFileUtils().copyFile(file, copy);
        return true;
    }

    public static String[] tokenizePath(String path) {
        ArrayList<String> l = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(path, ":;", true);
        char dosHack = '\u0000';
        int lastDelim = 0;
        int delimCount = 0;
        while (tok.hasMoreTokens()) {
            char c;
            String s = tok.nextToken();
            if (s.length() == 0) continue;
            if (s.length() == 1 && ((c = s.charAt(0)) == ':' || c == ';')) {
                lastDelim = c;
                ++delimCount;
                continue;
            }
            if (dosHack != '\u0000') {
                if (lastDelim == 58 && delimCount == 1 && (s.charAt(0) == '\\' || s.charAt(0) == '/')) {
                    s = "" + dosHack + ':' + s;
                } else {
                    l.add(Character.toString(dosHack));
                }
                dosHack = '\u0000';
            }
            delimCount = 0;
            if (s.length() == 1 && ((c = s.charAt(0)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                dosHack = c;
                continue;
            }
            l.add(s);
        }
        if (dosHack != '\u0000') {
            l.add(Character.toString(dosHack));
        }
        return l.toArray(new String[l.size()]);
    }

    public static class Replacement {
        String name;
        File dir;
        File excluded;

        public void setName(String name) {
            this.name = name;
        }

        public void setDir(File dir) {
            this.dir = dir;
        }

        public void setExcluded(File excluded) {
            this.excluded = excluded;
        }

        public String toString() {
            return this.dir + (this.excluded != null ? " - " + this.excluded : "") + " => ${" + this.name + "}";
        }
    }
}

