/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ant;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.JPDADebugger;

public class JPDAAppReloaded
extends Task {
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.ant");

    public void execute() throws BuildException {
        DebuggerEngine debuggerEngine;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JPDAAppReloaded.execute()");
        }
        if ((debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine()) == null) {
            logger.fine("No debugging sessions was found.");
            return;
        }
        JPDADebugger debugger = (JPDADebugger)debuggerEngine.lookupFirst(null, JPDADebugger.class);
        if (debugger == null) {
            logger.fine("Current debugger is not JPDA one.");
            return;
        }
        try {
            Method fixBreakpointsMethod = debugger.getClass().getMethod("fixBreakpoints", new Class[0]);
            fixBreakpointsMethod.invoke((Object)debugger, new Object[0]);
        }
        catch (Exception ex) {
            throw new BuildException((Throwable)ex);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Breakpoints fixed.");
        }
    }
}

