/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.editor.hints.projects.support;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JComponent;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.editor.tools.storage.api.ToolPreferences;
import org.netbeans.spi.editor.hints.projects.ProjectSettings;
import org.netbeans.spi.editor.hints.projects.support.Bundle;
import org.netbeans.spi.editor.hints.projects.support.ProjectHintSettingPanel;
import org.netbeans.spi.editor.hints.projects.support.StandardProjectSettings;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

class ProjectCustomizer
implements ProjectCustomizer.CompositeCategoryProvider {
    private final String customizersFolder;

    public ProjectCustomizer(String customizersFolder) {
        this.customizersFolder = customizersFolder;
    }

    public ProjectCustomizer.Category createCategory(Lookup context) {
        Project prj = (Project)context.lookup(Project.class);
        if (prj == null) {
            return null;
        }
        StandardProjectSettings.Standard settings = ProjectCustomizer.findStandardSettings(prj.getLookup());
        if (settings == null) {
            return null;
        }
        return ProjectCustomizer.Category.create((String)"editor.hints", (String)Bundle.CAP_Hints(), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
    }

    public JComponent createComponent(ProjectCustomizer.Category category, Lookup context) {
        final Project prj = (Project)context.lookup(Project.class);
        assert (prj != null);
        final ProjectHintSettingPanel settingsPanel = new ProjectHintSettingPanel(ProjectCustomizer.findStandardSettings(prj.getLookup()), this.customizersFolder);
        final ToolPreferences[] toSave = new ToolPreferences[1];
        category.setOkButtonListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                toSave[0] = settingsPanel.commit();
            }
        });
        category.setStoreListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (toSave[0] != null) {
                        toSave[0].save();
                        toSave[0] = null;
                    }
                    ProjectManager.getDefault().saveProject(prj);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        return settingsPanel;
    }

    private static StandardProjectSettings.Standard findStandardSettings(Lookup where) {
        ProjectSettings settings = (ProjectSettings)where.lookup(ProjectSettings.class);
        return settings instanceof StandardProjectSettings.Standard ? (StandardProjectSettings.Standard)settings : null;
    }
}

