/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.tooling.server.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.netbeans.modules.glassfish.tooling.data.GlassFishLibrary;
import org.netbeans.modules.glassfish.tooling.logging.Logger;
import org.netbeans.modules.glassfish.tooling.server.config.FileSet;
import org.openide.util.BaseUtilities;

public class ConfigUtils {
    private static final String MVN_PROP_GROUP_ID = "groupId";
    private static final String MVN_PROP_ARTIFACT_ID = "artifactId";
    private static final String MVN_PROP_VERSION = "version";
    private static final Pattern MVN_PROPS_PATTERN = Pattern.compile("META-INF/maven/[^/]+/[^/]+/pom.properties");

    static URL fileToURL(File file) {
        try {
            return file != null ? BaseUtilities.normalizeURI((URI)file.toURI()).toURL() : null;
        }
        catch (MalformedURLException ex) {
            Logger.log(Level.WARNING, "Unable to convert file " + file.getAbsolutePath() + " to URL", ex);
            return null;
        }
    }

    static List<URL> processLinks(FileSet fileset) {
        List<String> links = fileset.getLinks();
        ArrayList<URL> result = new ArrayList<URL>(links.size());
        for (String urlString : links) {
            try {
                result.add(new URL(urlString));
            }
            catch (MalformedURLException mue) {
                Logger.log(Level.WARNING, "Cannot process URL: " + urlString + ".", mue);
            }
        }
        return result;
    }

    static List<File> processFileset(FileSet fileset, String rootDir) throws FileNotFoundException {
        Map<String, List<String>> filesets = fileset.getFilesets();
        List<String> paths = fileset.getPaths();
        ArrayList<File> result = new ArrayList<File>();
        for (String dir : filesets.keySet()) {
            List<Pattern> patterns;
            File d = new File(dir);
            String dirPrefix = !d.isAbsolute() ? new File(rootDir, d.getPath()).getAbsolutePath() : d.getAbsolutePath();
            File[] fileArray = new File(dirPrefix).listFiles(ConfigUtils.createFilter(patterns = ConfigUtils.compilePatterns(filesets.get(dir))));
            if (fileArray == null) continue;
            Collections.addAll(result, fileArray);
        }
        for (String path : paths) {
            File f = new File(path);
            if (!f.isAbsolute()) {
                f = new File(rootDir, f.getPath());
            }
            if (!f.exists()) {
                throw new FileNotFoundException("File with name " + path + " does not exist.");
            }
            result.add(f);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<GlassFishLibrary.Maven> processClassPath(List<File> classpath) {
        LinkedList<GlassFishLibrary.Maven> mvnList = new LinkedList<GlassFishLibrary.Maven>();
        block19: for (File jar : classpath) {
            ZipFile zip = null;
            try {
                zip = new ZipFile(jar);
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    GlassFishLibrary.Maven mvnInfo;
                    ZipEntry entry = entries.nextElement();
                    Matcher matcher = MVN_PROPS_PATTERN.matcher(entry.getName());
                    if (!matcher.matches() || (mvnInfo = ConfigUtils.getMvnInfoFromProperties(zip.getInputStream(entry))) == null) continue;
                    mvnList.add(mvnInfo);
                    continue block19;
                }
            }
            catch (ZipException ze) {
                Logger.log(Level.WARNING, "Cannot open JAR file " + jar.getAbsolutePath() + ":", ze);
            }
            catch (IOException ioe) {
                Logger.log(Level.WARNING, "Cannot process JAR file " + jar.getAbsolutePath() + ":", ioe);
            }
            catch (IllegalStateException ise) {
                Logger.log(Level.WARNING, "Cannot process JAR file " + jar.getAbsolutePath() + ":", ise);
            }
            finally {
                if (zip == null) continue;
                try {
                    zip.close();
                }
                catch (IOException ioe) {
                    Logger.log(Level.WARNING, "Cannot close JAR file " + jar.getAbsolutePath() + ":", ioe);
                }
            }
        }
        return mvnList;
    }

    private static GlassFishLibrary.Maven getMvnInfoFromProperties(InputStream propStream) throws IOException {
        Properties props = new Properties();
        props.load(propStream);
        String groupId = props.getProperty(MVN_PROP_GROUP_ID);
        String artifactId = props.getProperty(MVN_PROP_ARTIFACT_ID);
        String version = props.getProperty(MVN_PROP_VERSION);
        if (groupId != null && artifactId != null && version != null) {
            return new GlassFishLibrary.Maven(groupId, artifactId, version);
        }
        return null;
    }

    private static FilenameFilter createFilter(final List<Pattern> patterns) {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                for (Pattern p : patterns) {
                    if (!p.matcher(name).matches()) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private static List<Pattern> compilePatterns(List<String> names) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>(names.size());
        for (String name : names) {
            patterns.add(Pattern.compile(name));
        }
        return patterns;
    }
}

