/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.FontColorSettings;

class HTMLDocView
extends JEditorPane {
    private HTMLEditorKit htmlKit;

    public HTMLDocView(Color bgColor) {
        this.setEditable(false);
        this.setFocusable(true);
        this.setBackground(bgColor);
        this.setMargin(new Insets(0, 3, 3, 3));
        this.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
    }

    public static Font getFont(AttributeSet attrs) {
        Font font = null;
        if (attrs != null) {
            String fontName = (String)attrs.getAttribute(StyleConstants.FontFamily);
            Integer fontSizeInteger = (Integer)attrs.getAttribute(StyleConstants.FontSize);
            if (fontName != null && fontSizeInteger != null) {
                Boolean bold = (Boolean)attrs.getAttribute(StyleConstants.Bold);
                Boolean italic = (Boolean)attrs.getAttribute(StyleConstants.Italic);
                int fontStyle = 0;
                if (bold != null && bold.booleanValue()) {
                    fontStyle |= 1;
                }
                if (italic != null && italic.booleanValue()) {
                    fontStyle |= 2;
                }
                font = new Font(fontName, fontStyle, fontSizeInteger);
            }
        }
        return font;
    }

    public void setContent(final String content, final String reference) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StringReader in = new StringReader("<HTML><BODY>" + content + "</BODY></HTML>");
                try {
                    HTMLDocView.this.setContentType("text/html");
                    Document doc = HTMLDocView.this.getDocument();
                    doc.remove(0, doc.getLength());
                    HTMLDocView.this.getEditorKit().read(in, HTMLDocView.this.getDocument(), 0);
                    HTMLDocView.this.setCaretPosition(0);
                    if (reference != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                HTMLDocView.this.scrollToReference(reference);
                            }
                        });
                    } else {
                        HTMLDocView.this.scrollRectToVisible(new Rectangle(0, 0, 0, 0));
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
            }
        });
    }

    @Override
    protected EditorKit createDefaultEditorKit() {
        if (this.htmlKit == null) {
            AttributeSet set;
            this.htmlKit = new HTMLEditorKit();
            this.setEditorKit(this.htmlKit);
            FontColorSettings font = (FontColorSettings)MimeLookup.getLookup((String)"text/x-java").lookup(FontColorSettings.class);
            Font f = null;
            if (font != null && (f = HTMLDocView.getFont(set = font.getFontColors("default"))) != null) {
                this.setFont(f);
            }
            if (this.htmlKit.getStyleSheet().getStyleSheets() != null || f == null) {
                return this.htmlKit;
            }
            StyleSheet css = new StyleSheet();
            this.setFont(f);
            css.addRule(new StringBuffer("body { font-size: ").append(f.getSize()).append("; }").toString());
            css.addStyleSheet(this.htmlKit.getStyleSheet());
            this.htmlKit.setStyleSheet(css);
        }
        return this.htmlKit;
    }
}

