/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.codehaus.plexus.PlexusContainerException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.embedder.DependencyTreeFactory;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.queries.Bundle;
import org.netbeans.modules.maven.queries.MavenDependencyResult;
import org.netbeans.modules.project.dependency.ArtifactSpec;
import org.netbeans.modules.project.dependency.Dependency;
import org.netbeans.modules.project.dependency.DependencyResult;
import org.netbeans.modules.project.dependency.ProjectDependencies;
import org.netbeans.modules.project.dependency.ProjectOperationException;
import org.netbeans.modules.project.dependency.Scope;
import org.netbeans.modules.project.dependency.Scopes;
import org.netbeans.modules.project.dependency.spi.ProjectDependenciesImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class MavenDependenciesImplementation
implements ProjectDependenciesImplementation {
    private static final Logger LOG = Logger.getLogger(MavenDependenciesImplementation.class.getName());
    private final Project project;
    private NbMavenProject nbMavenProject;
    private static final Set<Scope> SCOPES = new HashSet<Scope>();
    static final Map<Scope, String> mavenScopes;

    public MavenDependenciesImplementation(Project project) {
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        MavenDependenciesImplementation mavenDependenciesImplementation = this;
        synchronized (mavenDependenciesImplementation) {
            if (this.nbMavenProject != null) {
                return;
            }
            this.nbMavenProject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        }
    }

    static String mavenScope(Scope s) {
        return mavenScopes.getOrDefault(s, "runtime");
    }

    private ArtifactSpec mavenToArtifactSpec(Artifact a) {
        FileObject f;
        FileObject fileObject = f = a.getFile() == null ? null : FileUtil.toFileObject((File)a.getFile());
        if (a.isSnapshot()) {
            return ArtifactSpec.createSnapshotSpec((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getType(), (String)a.getClassifier(), (String)a.getVersion(), (boolean)a.isOptional(), (FileObject)f, (Object)a);
        }
        return ArtifactSpec.createVersionSpec((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getType(), (String)a.getClassifier(), (String)a.getVersion(), (boolean)a.isOptional(), (FileObject)f, (Object)a);
    }

    public DependencyResult findDependencies(ProjectDependencies.DependencyQuery query) {
        DependencyNode n;
        MavenEmbedder embedder;
        this.init();
        Set scopes = query.getScopes();
        final Dependency.Filter filter = query.getFilter();
        MavenProject mp = this.nbMavenProject.getMavenProject();
        if (NbMavenProject.isErrorPlaceholder(mp)) {
            if (this.nbMavenProject.isMavenProjectLoaded()) {
                throw new ProjectOperationException(this.project, ProjectOperationException.State.BROKEN, Bundle.ERR_DependencyOnBrokenProject());
            }
            throw new ProjectOperationException(this.project, ProjectOperationException.State.UNINITIALIZED, Bundle.ERR_DependencyNotPrimed());
        }
        if (query.isOffline()) {
            try {
                if (query.isFlushChaches()) {
                    embedder = EmbedderFactory.createProjectLikeEmbedder();
                }
                embedder = EmbedderFactory.getProjectEmbedder();
            }
            catch (PlexusContainerException ex) {
                throw new ProjectOperationException(this.project, ProjectOperationException.State.ERROR, Bundle.ERR_DependencyGraphError(), ex.getCause());
            }
        } else {
            try {
                embedder = EmbedderFactory.getOnlineEmbedder();
            }
            catch (IllegalStateException ex) {
                throw new ProjectOperationException(this.project, ProjectOperationException.State.ERROR, Bundle.ERR_DependencyGraphError(), ex.getCause());
            }
        }
        Collection mavenScopes = scopes.stream().map(MavenDependenciesImplementation::mavenScope).collect(Collectors.toList());
        try {
            n = DependencyTreeFactory.createDependencyTree((MavenProject)mp, (MavenEmbedder)embedder, (Collection)mavenScopes);
        }
        catch (MavenExecutionException ex) {
            throw new ProjectOperationException(this.project, ProjectOperationException.State.OK, Bundle.ERR_DependencyGraphError(), ex.getCause());
        }
        catch (AssertionError e) {
            if (EmbedderFactory.isOfflineException((Throwable)((Object)e))) {
                throw new ProjectOperationException(this.project, ProjectOperationException.State.OFFLINE, Bundle.ERR_DependencyGraphOffline());
            }
            throw e;
        }
        final HashSet allScopes = new HashSet();
        ArrayDeque processScopes = new ArrayDeque(scopes);
        while (!processScopes.isEmpty()) {
            Scope s = (Scope)processScopes.poll();
            HashSet<Scope> newScopes = new HashSet<Scope>();
            newScopes.add(s);
            for (Scope t : SCOPES) {
                if (s.includes(t)) {
                    newScopes.add(t);
                    continue;
                }
                if (!t.implies(s)) continue;
                newScopes.add(t);
            }
            newScopes.removeAll(allScopes);
            allScopes.addAll(newScopes);
            processScopes.addAll(newScopes);
        }
        HashSet<ArtifactSpec> broken = new HashSet<ArtifactSpec>();
        Dependency.Filter compositeFiter = new Dependency.Filter(){

            public boolean accept(Scope s, ArtifactSpec a) {
                return allScopes.contains(s) && (filter == null || filter.accept(s, a));
            }
        };
        return new MavenDependencyResult(this.nbMavenProject.getMavenProject(), this.convert2(n, compositeFiter, broken), new ArrayList<Scope>(scopes), broken, this.project, this.nbMavenProject);
    }

    static Scope scope(Artifact a) {
        String as = a.getScope();
        if (as == null) {
            return Scopes.COMPILE;
        }
        switch (as) {
            case "compile": {
                return Scopes.COMPILE;
            }
            case "runtime": 
            case "compile+runtime": 
            case "runtime+system": {
                return Scopes.RUNTIME;
            }
            case "import": 
            case "system": {
                return Scopes.EXTERNAL;
            }
            case "test": {
                return Scopes.TEST;
            }
        }
        return Scopes.COMPILE;
    }

    private Dependency convert2(DependencyNode n, Dependency.Filter filter, Set<ArtifactSpec> broken) {
        Scope s;
        ArtifactSpec aspec;
        ArrayList<Dependency> ch = new ArrayList<Dependency>();
        for (DependencyNode c : n.getChildren()) {
            Dependency cd = this.convert2(c, filter, broken);
            if (cd == null) continue;
            ch.add(cd);
        }
        Artifact a = n.getArtifact();
        String cs = a.getClassifier();
        if ("".equals(cs)) {
            cs = null;
        }
        if ((aspec = this.mavenToArtifactSpec(a)).getLocalFile() == null) {
            broken.add(aspec);
        }
        if (!filter.accept(s = MavenDependenciesImplementation.scope(a), aspec)) {
            return null;
        }
        return Dependency.create((ArtifactSpec)aspec, (Scope)s, ch, (Object)n);
    }

    static boolean dependencyEquals(Dependency dspec, org.apache.maven.model.Dependency mavenD) {
        ArtifactSpec spec = dspec.getArtifact();
        String mavenClass = mavenD.getClassifier();
        if ("".equals(mavenClass)) {
            mavenClass = null;
        }
        if (!(Objects.equals(spec.getGroupId(), mavenD.getGroupId()) && Objects.equals(spec.getArtifactId(), mavenD.getArtifactId()) && Objects.equals(spec.getClassifier(), mavenClass) && Objects.equals(spec.getVersionSpec(), mavenD.getVersion()))) {
            return false;
        }
        if (spec.getType() != null && !Objects.equals(spec.getType(), mavenD.getType())) {
            return false;
        }
        return dspec.getScope() == null || Objects.equals(MavenDependenciesImplementation.mavenScope(dspec.getScope()), mavenD.getScope());
    }

    static boolean artifactEquals(ArtifactSpec spec, Artifact mavenA) {
        String mavenClass = mavenA.getClassifier();
        if ("".equals(mavenClass)) {
            mavenClass = null;
        }
        if (!(Objects.equals(spec.getGroupId(), mavenA.getGroupId()) && Objects.equals(spec.getArtifactId(), mavenA.getArtifactId()) && Objects.equals(spec.getClassifier(), mavenClass) && Objects.equals(spec.getVersionSpec(), mavenA.getVersion()))) {
            return false;
        }
        return spec.getType() == null || Objects.equals(spec.getType(), mavenA.getType());
    }

    static {
        SCOPES.add(Scopes.COMPILE);
        SCOPES.add(Scopes.RUNTIME);
        SCOPES.add(Scopes.EXTERNAL);
        SCOPES.add(Scopes.TEST);
        mavenScopes = new HashMap<Scope, String>();
        mavenScopes.put(Scopes.PROCESS, "compile");
        mavenScopes.put(Scopes.COMPILE, "compile");
        mavenScopes.put(Scopes.RUNTIME, "runtime");
        mavenScopes.put(Scopes.TEST, "test");
        mavenScopes.put(Scopes.EXTERNAL, "provided");
    }
}

