/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.database.model.PluggableDatabaseSummary;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListPluggableDatabasesRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String databaseId;
    private Integer limit;
    private String page;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private PluggableDatabaseSummary.LifecycleState lifecycleState;
    private String pdbName;

    @ConstructorProperties(value={"compartmentId", "databaseId", "limit", "page", "sortBy", "sortOrder", "lifecycleState", "pdbName"})
    ListPluggableDatabasesRequest(String compartmentId, String databaseId, Integer limit, String page, SortBy sortBy, SortOrder sortOrder, PluggableDatabaseSummary.LifecycleState lifecycleState, String pdbName) {
        this.compartmentId = compartmentId;
        this.databaseId = databaseId;
        this.limit = limit;
        this.page = page;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.lifecycleState = lifecycleState;
        this.pdbName = pdbName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).databaseId(this.databaseId).limit(this.limit).page(this.page).sortBy(this.sortBy).sortOrder(this.sortOrder).lifecycleState(this.lifecycleState).pdbName(this.pdbName);
    }

    public String toString() {
        return "ListPluggableDatabasesRequest(super=" + super.toString() + ", compartmentId=" + this.getCompartmentId() + ", databaseId=" + this.getDatabaseId() + ", limit=" + this.getLimit() + ", page=" + this.getPage() + ", sortBy=" + (Object)((Object)this.getSortBy()) + ", sortOrder=" + (Object)((Object)this.getSortOrder()) + ", lifecycleState=" + (Object)((Object)this.getLifecycleState()) + ", pdbName=" + this.getPdbName() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListPluggableDatabasesRequest)) {
            return false;
        }
        ListPluggableDatabasesRequest other = (ListPluggableDatabasesRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        String this$databaseId = this.getDatabaseId();
        String other$databaseId = other.getDatabaseId();
        if (this$databaseId == null ? other$databaseId != null : !this$databaseId.equals(other$databaseId)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) {
            return false;
        }
        SortBy this$sortBy = this.getSortBy();
        SortBy other$sortBy = other.getSortBy();
        if (this$sortBy == null ? other$sortBy != null : !((Object)((Object)this$sortBy)).equals((Object)other$sortBy)) {
            return false;
        }
        SortOrder this$sortOrder = this.getSortOrder();
        SortOrder other$sortOrder = other.getSortOrder();
        if (this$sortOrder == null ? other$sortOrder != null : !((Object)((Object)this$sortOrder)).equals((Object)other$sortOrder)) {
            return false;
        }
        PluggableDatabaseSummary.LifecycleState this$lifecycleState = this.getLifecycleState();
        PluggableDatabaseSummary.LifecycleState other$lifecycleState = other.getLifecycleState();
        if (this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState)) {
            return false;
        }
        String this$pdbName = this.getPdbName();
        String other$pdbName = other.getPdbName();
        return !(this$pdbName == null ? other$pdbName != null : !this$pdbName.equals(other$pdbName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListPluggableDatabasesRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        String $databaseId = this.getDatabaseId();
        result = result * 59 + ($databaseId == null ? 43 : $databaseId.hashCode());
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        SortBy $sortBy = this.getSortBy();
        result = result * 59 + ($sortBy == null ? 43 : ((Object)((Object)$sortBy)).hashCode());
        SortOrder $sortOrder = this.getSortOrder();
        result = result * 59 + ($sortOrder == null ? 43 : ((Object)((Object)$sortOrder)).hashCode());
        PluggableDatabaseSummary.LifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        String $pdbName = this.getPdbName();
        result = result * 59 + ($pdbName == null ? 43 : $pdbName.hashCode());
        return result;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public PluggableDatabaseSummary.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getPdbName() {
        return this.pdbName;
    }

    public static class Builder
    implements BmcRequest.Builder<ListPluggableDatabasesRequest, Void> {
        private String compartmentId;
        private String databaseId;
        private Integer limit;
        private String page;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private PluggableDatabaseSummary.LifecycleState lifecycleState;
        private String pdbName;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListPluggableDatabasesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.databaseId(o.getDatabaseId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.lifecycleState(o.getLifecycleState());
            this.pdbName(o.getPdbName());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListPluggableDatabasesRequest build() {
            ListPluggableDatabasesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder lifecycleState(PluggableDatabaseSummary.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder pdbName(String pdbName) {
            this.pdbName = pdbName;
            return this;
        }

        public ListPluggableDatabasesRequest buildWithoutInvocationCallback() {
            return new ListPluggableDatabasesRequest(this.compartmentId, this.databaseId, this.limit, this.page, this.sortBy, this.sortOrder, this.lifecycleState, this.pdbName);
        }

        public String toString() {
            return "ListPluggableDatabasesRequest.Builder(compartmentId=" + this.compartmentId + ", databaseId=" + this.databaseId + ", limit=" + this.limit + ", page=" + this.page + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", pdbName=" + this.pdbName + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy {
        Pdbname("PDBNAME"),
        Timecreated("TIMECREATED");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

