/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.server.state;

import java.util.logging.Level;
import org.netbeans.modules.payara.tooling.TaskEvent;
import org.netbeans.modules.payara.tooling.TaskState;
import org.netbeans.modules.payara.tooling.TaskStateListener;
import org.netbeans.modules.payara.tooling.admin.AdminFactory;
import org.netbeans.modules.payara.tooling.admin.Command;
import org.netbeans.modules.payara.tooling.admin.Result;
import org.netbeans.modules.payara.tooling.admin.Runner;
import org.netbeans.modules.payara.tooling.data.PayaraStatusCheck;
import org.netbeans.modules.payara.tooling.logging.Logger;
import org.netbeans.modules.payara.tooling.server.state.AbstractTask;
import org.netbeans.modules.payara.tooling.server.state.StatusJob;

class RunnerTask
extends AbstractTask {
    private static final Logger LOGGER = new Logger(RunnerTask.class);
    private final Command cmd;
    Result result;

    RunnerTask(StatusJob job, StatusJob.RunnerTask task, PayaraStatusCheck type) {
        super(job, task, type);
        this.cmd = task.getCommand();
        this.result = null;
    }

    @Override
    public void run() {
        int i;
        String METHOD = "run";
        if (this.cancelled) {
            LOGGER.log(Level.FINER, "run", "cancelled");
            throw new IllegalStateException(LOGGER.excMsg("run", "cancelled"));
        }
        LOGGER.log(Level.FINER, "run", "started", new String[]{this.job.getStatus().getServer().getName(), this.jobState.toString()});
        TaskStateListener[] listeners = this.task.getListeners();
        AdminFactory af = AdminFactory.getInstance(this.job.getStatus().getServer().getAdminInterface());
        Runner runner = af.getRunner(this.job.getStatus().getServer(), this.cmd);
        if (listeners != null) {
            for (i = 0; i < listeners.length; ++i) {
                if (!(listeners[i] instanceof StatusJob.Listener)) continue;
                ((StatusJob.Listener)listeners[i]).setRunner(runner);
            }
        }
        runner.setStateListeners(new TaskStateListener[]{new RunnerListener(this)});
        runner.setReadyState();
        this.result = runner.call();
        if (listeners != null) {
            for (i = 0; i < listeners.length; ++i) {
                if (!(listeners[i] instanceof StatusJob.Listener)) continue;
                ((StatusJob.Listener)listeners[i]).clearRunner();
            }
        }
    }

    private class RunnerListener
    implements TaskStateListener {
        final RunnerTask runnerTask;

        private RunnerListener(RunnerTask runnerTask2) {
            this.runnerTask = runnerTask2;
        }

        @Override
        public void operationStateChanged(TaskState newState, TaskEvent event, String ... args) {
            this.runnerTask.handleStateChange(newState, event, args);
        }
    }
}

