/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.context;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;

final class TrackingLockFactory
extends LockFactory {
    private final LockFactory delegate;
    private final Set<TrackingLock> emittedLocks;

    TrackingLockFactory(LockFactory delegate) {
        this.delegate = Objects.requireNonNull(delegate);
        this.emittedLocks = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    Set<? extends Lock> getEmittedLocks(String name) {
        HashSet<TrackingLock> result = new HashSet<TrackingLock>();
        for (TrackingLock lock : this.emittedLocks) {
            if (name != null && !name.equals(lock.getName())) continue;
            result.add(lock);
        }
        return result;
    }

    public Lock obtainLock(Directory dir, String lockName) throws IOException {
        TrackingLock lck = new TrackingLock(this.delegate.obtainLock(dir, lockName), lockName);
        this.emittedLocks.add(lck);
        return lck;
    }

    private final class TrackingLock
    extends Lock {
        private final Lock delegate;
        private final String name;

        TrackingLock(Lock delegate, String name) {
            this.delegate = Objects.requireNonNull(delegate);
            this.name = Objects.requireNonNull(name);
        }

        String getName() {
            return this.name;
        }

        public void close() throws IOException {
            try {
                this.delegate.close();
            }
            finally {
                TrackingLockFactory.this.emittedLocks.remove((Object)this);
            }
        }

        public void ensureValid() throws IOException {
            this.delegate.ensureValid();
        }
    }
}

