/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.editor.model.ClassMemberElement;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.EnumScope;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.InterfaceScope;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.HintErrorRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public class ConstantRedeclarationHintError
extends HintErrorRule {
    public String getDisplayName() {
        return Bundle.ConstantRedeclarationHintErrorDisplayName();
    }

    @Override
    public void invoke(PHPRuleContext context, List<Hint> hints) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        FileScope fileScope = context.fileScope;
        FileObject fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileScope != null && fileObject != null) {
            this.checkTypeScopes(ModelUtils.getDeclaredClasses(fileScope), hints, fileObject);
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkTypeScopes(ModelUtils.getDeclaredInterfaces(fileScope), hints, fileObject);
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkTypeScopes(ModelUtils.getDeclaredEnums(fileScope), hints, fileObject);
        }
    }

    private void checkTypeScopes(Collection<? extends TypeScope> typeScopes, List<Hint> hints, FileObject fileObject) {
        for (TypeScope typeScope : typeScopes) {
            for (ClassMemberElement constant : this.getRedeclaredConstants(typeScope)) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                hints.add(new Hint((Rule)this, Bundle.ConstantRedeclarationCustom(constant.getName()), fileObject, constant.getNameRange(), null, 500));
            }
        }
    }

    private Set<ClassMemberElement> getRedeclaredConstants(TypeScope typeScope) {
        ArrayList<ClassMemberElement> declaredConstants = new ArrayList<ClassMemberElement>();
        if (typeScope instanceof ClassScope || typeScope instanceof InterfaceScope) {
            declaredConstants.addAll(typeScope.getDeclaredConstants());
        } else if (typeScope instanceof EnumScope) {
            declaredConstants.addAll(((EnumScope)typeScope).getDeclaredEnumCases());
            declaredConstants.addAll(((EnumScope)typeScope).getDeclaredConstants());
        } else {
            return Collections.emptySet();
        }
        HashSet<ClassMemberElement> redeclaredConstants = new HashSet<ClassMemberElement>();
        HashMap<String, ClassMemberElement> firstDeclaredConstants = new HashMap<String, ClassMemberElement>();
        for (ClassMemberElement declaredConstant : declaredConstants) {
            String constantName = declaredConstant.getName();
            ClassMemberElement firstDeclaredConstant = (ClassMemberElement)firstDeclaredConstants.get(constantName);
            if (firstDeclaredConstant == null) {
                firstDeclaredConstants.put(constantName, declaredConstant);
                continue;
            }
            if (firstDeclaredConstant.getOffset() > declaredConstant.getOffset()) {
                ClassMemberElement oldConstant = firstDeclaredConstants.replace(constantName, declaredConstant);
                redeclaredConstants.add(oldConstant);
                continue;
            }
            redeclaredConstants.add(declaredConstant);
        }
        return redeclaredConstants;
    }
}

