/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.ui.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.web.clientproject.api.network.NetworkException;
import org.netbeans.modules.web.clientproject.api.network.NetworkSupport;
import org.netbeans.modules.web.clientproject.sites.SiteZip;
import org.netbeans.modules.web.clientproject.spi.SiteTemplateImplementation;
import org.netbeans.modules.web.clientproject.ui.wizard.Bundle;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class SiteTemplateWizard
extends JPanel {
    private static final long serialVersionUID = 154768576465454L;
    static final Logger LOGGER = Logger.getLogger(SiteTemplateWizard.class.getName());
    private static final SiteTemplateImplementation NO_SITE_TEMPLATE = new DummySiteTemplateImplementation(null);
    private static final RequestProcessor RP = new RequestProcessor(SiteTemplateWizard.class.getName(), 2);
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final SiteZip archiveSiteTemplate = new SiteZip();
    private final SiteZip.Customizer archiveSiteCustomizer;
    final DefaultListModel onlineTemplatesListModel = new DefaultListModel();
    final Object siteTemplateLock = new Object();
    SiteTemplateImplementation siteTemplate = NO_SITE_TEMPLATE;
    private JPanel archiveTemplatePanel;
    private JRadioButton archiveTemplateRadioButton;
    private JLabel clearCacheLabel;
    private JLabel infoLabel;
    private JRadioButton noTemplateRadioButton;
    private JLabel onlineTemplateDescriptionLabel;
    private JScrollPane onlineTemplateDescriptionScrollPane;
    private JTextPane onlineTemplateDescriptionTextPane;
    private JList onlineTemplateList;
    private JRadioButton onlineTemplateRadioButton;
    private JScrollPane onlineTemplateScrollPane;
    private ButtonGroup templateButtonGroup;

    public SiteTemplateWizard() {
        assert (EventQueue.isDispatchThread());
        this.archiveSiteCustomizer = this.archiveSiteTemplate.getCustomizer();
        assert (this.archiveSiteCustomizer != null) : "Archive template must have a customizer";
        this.initComponents();
        this.initArchiveTemplate();
        this.initOnlineTemplates();
        this.initListeners();
        this.updateSiteTemplate();
    }

    private void initArchiveTemplate() {
        this.archiveTemplatePanel.add((Component)this.archiveSiteCustomizer.getComponent(), "Center");
    }

    private void initOnlineTemplates() {
        assert (EventQueue.isDispatchThread());
        this.updateClearCacheLabel(false);
        this.onlineTemplateList.setCellRenderer(new TemplateListCellRenderer(this.onlineTemplateList.getCellRenderer()));
        this.onlineTemplateList.setModel(this.onlineTemplatesListModel);
        this.onlineTemplatesListModel.addElement(new DummySiteTemplateImplementation(Bundle.SiteTemplateWizard_loading()));
        RP.post(new Runnable(){

            @Override
            public void run() {
                Collection templates = Lookup.getDefault().lookupAll(SiteTemplateImplementation.class);
                SiteTemplateWizard.this.onlineTemplatesListModel.removeAllElements();
                for (SiteTemplateImplementation template : templates) {
                    SiteTemplateWizard.this.onlineTemplatesListModel.addElement(template);
                }
            }
        });
    }

    void updateClearCacheLabel(boolean clearing) {
        assert (EventQueue.isDispatchThread());
        String label = clearing ? Bundle.SiteTemplateWizard_clearCache_running() : Bundle.SiteTemplateWizard_clearCache_ready();
        this.clearCacheLabel.setText(label);
        this.clearCacheLabel.setMaximumSize(this.clearCacheLabel.getPreferredSize());
    }

    private void initListeners() {
        DefaultItemListener defaultItemListener = new DefaultItemListener();
        this.noTemplateRadioButton.addItemListener(defaultItemListener);
        this.archiveTemplateRadioButton.addItemListener(defaultItemListener);
        this.onlineTemplateRadioButton.addItemListener(defaultItemListener);
        this.onlineTemplateList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SiteTemplateWizard.this.setSiteTemplate(SiteTemplateWizard.this.getSelectedOnlineTemplate());
                SiteTemplateWizard.this.fireChange();
                SiteTemplateWizard.this.updateOnlineTemplateDescription();
            }
        });
    }

    final void updateSiteTemplate() {
        this.enableTemplates();
        this.fireChange();
    }

    private void enableTemplates() {
        if (this.noTemplateRadioButton.isSelected()) {
            this.setSiteTemplate(NO_SITE_TEMPLATE);
            this.setArchiveTemplateEnabled(false);
            this.setOnlineTemplateEnabled(false);
        } else if (this.archiveTemplateRadioButton.isSelected()) {
            this.setSiteTemplate(this.archiveSiteTemplate);
            this.setArchiveTemplateEnabled(true);
            this.setOnlineTemplateEnabled(false);
        } else if (this.onlineTemplateRadioButton.isSelected()) {
            this.setSiteTemplate(this.getSelectedOnlineTemplate());
            this.setArchiveTemplateEnabled(false);
            this.setOnlineTemplateEnabled(true);
        } else {
            throw new IllegalStateException("No template radio button selected?!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateOnlineTemplateDescription() {
        String desc;
        Object object = this.siteTemplateLock;
        synchronized (object) {
            desc = this.siteTemplate != null ? this.siteTemplate.getDescription() : "";
        }
        this.onlineTemplateDescriptionTextPane.setText(desc);
    }

    SiteTemplateImplementation getSelectedOnlineTemplate() {
        return (SiteTemplateImplementation)this.onlineTemplateList.getSelectedValue();
    }

    private void setArchiveTemplateEnabled(boolean enabled) {
        for (Component component : this.archiveSiteCustomizer.getComponent().getComponents()) {
            component.setEnabled(enabled);
        }
    }

    private void setOnlineTemplateEnabled(boolean enabled) {
        this.onlineTemplateDescriptionLabel.setEnabled(enabled);
        this.onlineTemplateList.setEnabled(enabled);
        this.onlineTemplateDescriptionTextPane.setEnabled(enabled);
    }

    public void addChangeListener(ChangeListener listener) {
        assert (EventQueue.isDispatchThread());
        this.changeSupport.addChangeListener(listener);
        this.archiveSiteCustomizer.addChangeListener(listener);
    }

    public void removeChangeListener(final ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                assert (EventQueue.isDispatchThread());
                SiteTemplateWizard.this.archiveSiteCustomizer.removeChangeListener(listener);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getErrorMessage() {
        boolean isArchiveSiteTemplate;
        Object object = this.siteTemplateLock;
        synchronized (object) {
            if (this.siteTemplate == null) {
                return Bundle.SiteTemplateWizard_error_noTemplateSelected();
            }
            isArchiveSiteTemplate = this.siteTemplate == this.archiveSiteTemplate;
        }
        if (isArchiveSiteTemplate) {
            this.archiveSiteCustomizer.isValid();
            return this.archiveSiteCustomizer.getErrorMessage();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getWarningMessage() {
        boolean isArchiveSiteTemplate;
        Object object = this.siteTemplateLock;
        synchronized (object) {
            isArchiveSiteTemplate = this.siteTemplate == this.archiveSiteTemplate;
        }
        if (isArchiveSiteTemplate) {
            this.archiveSiteCustomizer.isValid();
            return this.archiveSiteCustomizer.getWarningMessage();
        }
        return null;
    }

    public void lockPanel() {
        this.enablePanel(false);
        this.setArchiveTemplateEnabled(false);
        this.setOnlineTemplateEnabled(false);
    }

    public void unlockPanel() {
        this.enablePanel(true);
        this.enableTemplates();
    }

    private void enablePanel(boolean enable) {
        this.noTemplateRadioButton.setEnabled(enable);
        this.archiveTemplateRadioButton.setEnabled(enable);
        this.onlineTemplateRadioButton.setEnabled(enable);
    }

    void preSelectSiteTemplate(SiteTemplateImplementation impl) {
        if (!"NONE".equals(impl.getId()) && !"ARCHIVE".equals(impl.getId())) {
            this.onlineTemplateRadioButton.setSelected(true);
            this.onlineTemplateList.setSelectedValue(impl, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String prepareTemplate() {
        block17: {
            SiteTemplateImplementation siteTemplateRef;
            String templateName;
            assert (!EventQueue.isDispatchThread());
            Object object = this.siteTemplateLock;
            synchronized (object) {
                if (this.siteTemplate.isPrepared()) {
                    return null;
                }
                templateName = this.siteTemplate.getName();
                siteTemplateRef = this.siteTemplate;
            }
            ProgressHandle progressHandle = ProgressHandle.createHandle((String)Bundle.SiteTemplateWizard_template_preparing(templateName));
            progressHandle.start();
            while (true) {
                try {
                    siteTemplateRef.prepare();
                    break block17;
                }
                catch (NetworkException ex) {
                    LOGGER.log(Level.INFO, null, ex.getCause());
                    if (!NetworkSupport.showNetworkErrorDialog((List)ex.getFailedRequests())) {
                        String string = Bundle.SiteTemplateWizard_error_preparing(templateName);
                        progressHandle.finish();
                        return string;
                    }
                    try {
                    }
                    catch (IOException ex2) {
                        LOGGER.log(Level.INFO, null, ex2);
                        String string = Bundle.SiteTemplateWizard_error_preparing(templateName);
                        return string;
                    }
                    catch (IllegalStateException ex3) {
                        LOGGER.log(Level.INFO, null, ex3);
                        String string = Bundle.SiteTemplateWizard_error_preparing_custom(templateName, ex3.getMessage());
                        return string;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                progressHandle.finish();
            }
        }
        return null;
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SiteTemplateImplementation getSiteTemplate() {
        Object object = this.siteTemplateLock;
        synchronized (object) {
            return this.siteTemplate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSiteTemplate(SiteTemplateImplementation siteTemplate) {
        Object object = this.siteTemplateLock;
        synchronized (object) {
            this.siteTemplate = siteTemplate;
        }
    }

    private void initComponents() {
        this.templateButtonGroup = new ButtonGroup();
        this.infoLabel = new JLabel();
        this.noTemplateRadioButton = new JRadioButton();
        this.archiveTemplateRadioButton = new JRadioButton();
        this.archiveTemplatePanel = new JPanel();
        this.onlineTemplateRadioButton = new JRadioButton();
        this.onlineTemplateScrollPane = new JScrollPane();
        this.onlineTemplateList = new JList();
        this.onlineTemplateDescriptionLabel = new JLabel();
        this.clearCacheLabel = new JLabel();
        this.onlineTemplateDescriptionScrollPane = new JScrollPane();
        this.onlineTemplateDescriptionTextPane = new JTextPane();
        Mnemonics.setLocalizedText((JLabel)this.infoLabel, (String)NbBundle.getMessage(SiteTemplateWizard.class, (String)"SiteTemplateWizard.infoLabel.text"));
        this.templateButtonGroup.add(this.noTemplateRadioButton);
        this.noTemplateRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.noTemplateRadioButton, (String)NbBundle.getMessage(SiteTemplateWizard.class, (String)"SiteTemplateWizard.noTemplateRadioButton.text"));
        this.templateButtonGroup.add(this.archiveTemplateRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.archiveTemplateRadioButton, (String)NbBundle.getMessage(SiteTemplateWizard.class, (String)"SiteTemplateWizard.archiveTemplateRadioButton.text"));
        this.archiveTemplatePanel.setLayout(new BorderLayout());
        this.templateButtonGroup.add(this.onlineTemplateRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.onlineTemplateRadioButton, (String)NbBundle.getMessage(SiteTemplateWizard.class, (String)"SiteTemplateWizard.onlineTemplateRadioButton.text"));
        this.onlineTemplateList.setSelectionMode(0);
        this.onlineTemplateScrollPane.setViewportView(this.onlineTemplateList);
        this.onlineTemplateDescriptionLabel.setLabelFor(this.onlineTemplateDescriptionTextPane);
        Mnemonics.setLocalizedText((JLabel)this.onlineTemplateDescriptionLabel, (String)NbBundle.getMessage(SiteTemplateWizard.class, (String)"SiteTemplateWizard.onlineTemplateDescriptionLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.clearCacheLabel, (String)"CLEAR CACHE");
        this.clearCacheLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SiteTemplateWizard.this.clearCacheLabelMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                SiteTemplateWizard.this.clearCacheLabelMousePressed(evt);
            }
        });
        this.onlineTemplateDescriptionTextPane.setEditable(false);
        this.onlineTemplateDescriptionScrollPane.setViewportView(this.onlineTemplateDescriptionTextPane);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.infoLabel).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.onlineTemplateDescriptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.clearCacheLabel)).addComponent(this.archiveTemplatePanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.onlineTemplateScrollPane).addComponent(this.onlineTemplateDescriptionScrollPane, GroupLayout.Alignment.TRAILING))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noTemplateRadioButton).addComponent(this.archiveTemplateRadioButton).addComponent(this.onlineTemplateRadioButton)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.infoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.noTemplateRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.archiveTemplateRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.archiveTemplatePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.onlineTemplateRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.onlineTemplateScrollPane, -1, 67, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.onlineTemplateDescriptionLabel).addComponent(this.clearCacheLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.onlineTemplateDescriptionScrollPane, -2, 50, -2)));
    }

    private void clearCacheLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void clearCacheLabelMousePressed(MouseEvent evt) {
        this.updateClearCacheLabel(true);
        RP.post(new Runnable(){

            @Override
            public void run() {
                Enumeration templates = SiteTemplateWizard.this.onlineTemplatesListModel.elements();
                while (templates.hasMoreElements()) {
                    SiteTemplateImplementation template = (SiteTemplateImplementation)templates.nextElement();
                    try {
                        template.cleanup();
                    }
                    catch (IOException exc) {
                        LOGGER.log(Level.INFO, "Cannot cleanuop site template: " + template.getId(), exc);
                    }
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SiteTemplateWizard.this.updateClearCacheLabel(false);
                    }
                });
            }
        });
    }

    private final class DefaultItemListener
    implements ItemListener {
        private DefaultItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            if (event.getStateChange() == 1) {
                SiteTemplateWizard.this.updateSiteTemplate();
            }
        }
    }

    private static final class TemplateListCellRenderer
    implements ListCellRenderer {
        private final ListCellRenderer cellRenderer;

        public TemplateListCellRenderer(ListCellRenderer cellRenderer) {
            this.cellRenderer = cellRenderer;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            SiteTemplateImplementation site = (SiteTemplateImplementation)value;
            return this.cellRenderer.getListCellRendererComponent(list, site.getName(), index, isSelected, cellHasFocus);
        }
    }

    private static final class DummySiteTemplateImplementation
    implements SiteTemplateImplementation {
        private final String name;

        public DummySiteTemplateImplementation(String name) {
            this.name = name;
        }

        public String getId() {
            return "NONE";
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public boolean isPrepared() {
            return true;
        }

        public void prepare() {
        }

        public void configure(SiteTemplateImplementation.ProjectProperties properties) {
        }

        public void apply(FileObject projectDir, SiteTemplateImplementation.ProjectProperties projectProperties, ProgressHandle handle) throws IOException {
        }

        public void cleanup() {
        }
    }
}

