/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.breakpoints.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.expr.InvocationExceptionTranslated;
import org.netbeans.modules.debugger.jpda.truffle.access.CurrentPCInfo;
import org.netbeans.modules.debugger.jpda.truffle.access.TruffleEval;
import org.netbeans.modules.debugger.jpda.truffle.breakpoints.TruffleLineBreakpoint;
import org.netbeans.modules.debugger.jpda.truffle.breakpoints.impl.Bundle;
import org.netbeans.modules.debugger.jpda.truffle.breakpoints.impl.HitBreakpointInfo;
import org.netbeans.modules.debugger.jpda.truffle.vars.TruffleVariable;
import org.netbeans.modules.javascript2.debug.breakpoints.JSLineBreakpoint;

public class TruffleBreakpointOutput {
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("\\{=(.*?)\\}");

    private TruffleBreakpointOutput() {
    }

    public static void breakpointsHit(HitBreakpointInfo[] breakpointInfos, CurrentPCInfo cpi) {
        for (HitBreakpointInfo breakpointInfo : breakpointInfos) {
            TruffleBreakpointOutput.breakpointHit(breakpointInfo, cpi);
        }
    }

    private static void breakpointHit(HitBreakpointInfo breakpointInfo, CurrentPCInfo cpi) {
        JSLineBreakpoint breakpoint = breakpointInfo.getBreakpoint();
        if (!(breakpoint instanceof TruffleLineBreakpoint)) {
            return;
        }
        String printText = ((TruffleLineBreakpoint)breakpoint).getPrintText();
        if (printText == null || printText.isEmpty()) {
            return;
        }
        ObjectVariable conditionException = breakpointInfo.getConditionException();
        String exceptionMessage = null;
        if (conditionException != null && conditionException.getUniqueID() != 0L) {
            exceptionMessage = new InvocationExceptionTranslated(conditionException, (JPDADebuggerImpl)breakpointInfo.getDebugger()).getLocalizedMessage();
        }
        TruffleBreakpointOutput.substituteAndPrintText(printText, exceptionMessage, cpi, breakpointInfo.getDebugger());
    }

    private static void substituteAndPrintText(String printText, String exceptionMessage, CurrentPCInfo cpi, JPDADebugger debugger) {
        printText = TruffleBreakpointOutput.substitute(printText, exceptionMessage, cpi, debugger);
        ((JPDADebuggerImpl)debugger).getConsoleIO().println(printText, null);
    }

    private static String substitute(String printText, String exceptionMessage, CurrentPCInfo cpi, JPDADebugger debugger) {
        Matcher m;
        while ((m = EXPRESSION_PATTERN.matcher(printText)).find()) {
            String expression = m.group(1);
            String value = "";
            try {
                Variable varValue = TruffleEval.evaluate(debugger, cpi, expression);
                if (varValue != null) {
                    TruffleVariable tv = TruffleVariable.get(varValue);
                    value = tv != null ? tv.getDisplayValue() : (varValue instanceof ObjectVariable ? ((ObjectVariable)varValue).getToStringValue() : varValue.getValue());
                }
            }
            catch (InvalidExpressionException e) {
                String msg = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
                ((JPDADebuggerImpl)debugger).getConsoleIO().println(Bundle.MSG_EvaluateError(expression, msg), null);
            }
            printText = m.replaceFirst(value);
        }
        if (exceptionMessage != null) {
            printText = printText + "\n***\n" + exceptionMessage + "\n***\n";
        }
        return printText;
    }
}

