/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.shellsupport.doc;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.InheritDocTree;
import com.sun.source.doctree.ParamTree;
import com.sun.source.doctree.ReturnTree;
import com.sun.source.doctree.ThrowsTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.DocSourcePositions;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTreeScanner;
import com.sun.source.util.DocTrees;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Pair;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

public abstract class JavadocHelper
implements AutoCloseable {
    private static final JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();

    public static JavadocHelper create(JavacTask mainTask, Collection<? extends Path> sourceLocations) {
        StandardJavaFileManager fm = compiler.getStandardFileManager(null, null, null);
        try {
            fm.setLocationFromPaths(StandardLocation.SOURCE_PATH, sourceLocations);
            return new OnDemandJavadocHelper(mainTask, fm);
        }
        catch (IOException ex) {
            try {
                fm.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return new JavadocHelper(){

                @Override
                public String getResolvedDocComment(Element forElement) throws IOException {
                    return null;
                }

                @Override
                public Element getSourceElement(Element forElement) throws IOException {
                    return forElement;
                }

                @Override
                public void close() throws IOException {
                }
            };
        }
    }

    public abstract String getResolvedDocComment(Element var1) throws IOException;

    public abstract Element getSourceElement(Element var1) throws IOException;

    @Override
    public abstract void close() throws IOException;

    private static final class OnDemandJavadocHelper
    extends JavadocHelper {
        private final JavacTask mainTask;
        private final JavaFileManager baseFileManager;
        private final StandardJavaFileManager fm;
        private final Map<String, Pair<JavacTask, TreePath>> signature2Source = new HashMap<String, Pair<JavacTask, TreePath>>();

        private OnDemandJavadocHelper(JavacTask mainTask, StandardJavaFileManager fm) {
            this.mainTask = mainTask;
            this.baseFileManager = ((JavacTaskImpl)mainTask).getContext().get(JavaFileManager.class);
            this.fm = fm;
        }

        @Override
        public String getResolvedDocComment(Element forElement) throws IOException {
            Pair<JavacTask, TreePath> sourceElement = this.getSourceElement(this.mainTask, forElement);
            if (sourceElement == null) {
                return null;
            }
            return this.getResolvedDocComment((JavacTask)sourceElement.fst, (TreePath)sourceElement.snd);
        }

        @Override
        public Element getSourceElement(Element forElement) throws IOException {
            Pair<JavacTask, TreePath> sourceElement = this.getSourceElement(this.mainTask, forElement);
            if (sourceElement == null) {
                return forElement;
            }
            Element result = Trees.instance((JavaCompiler.CompilationTask)sourceElement.fst).getElement((TreePath)sourceElement.snd);
            if (result == null) {
                return forElement;
            }
            return result;
        }

        private String getResolvedDocComment(final JavacTask task, final TreePath el) throws IOException {
            DocTrees trees = DocTrees.instance(task);
            final Element element = trees.getElement(el);
            final String docComment = trees.getDocComment(el);
            if (docComment == null && element.getKind() == ElementKind.METHOD) {
                ExecutableElement executableElement = (ExecutableElement)element;
                Iterable superTypes = () -> this.superTypeForInheritDoc(task, element.getEnclosingElement()).iterator();
                for (Element sup : superTypes) {
                    for (ExecutableElement supMethod : ElementFilter.methodsIn(sup.getEnclosedElements())) {
                        String overriddenComment;
                        Pair<JavacTask, TreePath> source;
                        TypeElement clazz = (TypeElement)executableElement.getEnclosingElement();
                        if (!task.getElements().overrides(executableElement, supMethod, clazz) || (source = this.getSourceElement(task, supMethod)) == null || (overriddenComment = this.getResolvedDocComment((JavacTask)source.fst, (TreePath)source.snd)) == null) continue;
                        return overriddenComment;
                    }
                }
            }
            if (docComment == null) {
                return null;
            }
            Pair<DocCommentTree, Integer> parsed = this.parseDocComment(task, docComment);
            final DocCommentTree docCommentTree = (DocCommentTree)parsed.fst;
            final int offset = (Integer)parsed.snd;
            final IOException[] exception = new IOException[1];
            Comparator spanComp = (span1, span2) -> span1[0] != span2[0] ? span2[0] - span1[0] : span2[1] - span1[0];
            final TreeMap replace = new TreeMap(spanComp);
            final DocSourcePositions sp = trees.getSourcePositions();
            new DocTreeScanner<Void, Void>(){
                private Stack<DocTree> interestingParent = new Stack();
                private DocCommentTree dcTree;
                private String inherited;
                private JavacTask inheritedJavacTask;
                private TreePath inheritedTreePath;
                private Map<DocTree, String> syntheticTrees = new IdentityHashMap<DocTree, String>();
                private long insertPos = offset;
                private boolean inSynthetic;
                private final List<DocTree.Kind> tagOrder = Arrays.asList(DocTree.Kind.PARAM, DocTree.Kind.THROWS, DocTree.Kind.RETURN);

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void visitDocComment(DocCommentTree node, Void p) {
                    this.dcTree = node;
                    this.interestingParent.push(node);
                    try {
                        if (node.getFullBody().isEmpty()) {
                            DocCommentTree dc = (DocCommentTree)((OnDemandJavadocHelper)this).parseDocComment((JavacTask)task, (String)"{@inheritDoc}").fst;
                            this.syntheticTrees.put(dc, "*\n");
                            this.interestingParent.push(dc);
                            boolean prevInSynthetic = this.inSynthetic;
                            try {
                                this.inSynthetic = true;
                                this.scan(dc.getFirstSentence(), p);
                                this.scan(dc.getBody(), p);
                            }
                            finally {
                                this.inSynthetic = prevInSynthetic;
                                this.interestingParent.pop();
                            }
                        } else {
                            this.scan(node.getFirstSentence(), p);
                            this.scan(node.getBody(), p);
                        }
                        ArrayList<DocTree> augmentedBlockTags = new ArrayList<DocTree>(node.getBlockTags());
                        if (element.getKind() == ElementKind.METHOD) {
                            DocTree syntheticTag;
                            ExecutableElement executableElement = (ExecutableElement)element;
                            List<String> parameters = executableElement.getParameters().stream().map(param -> param.getSimpleName().toString()).collect(Collectors.toList());
                            List<String> throwsList = executableElement.getThrownTypes().stream().map(TypeMirror::toString).collect(Collectors.toList());
                            HashSet missingParams = new HashSet(parameters);
                            HashSet missingThrows = new HashSet(throwsList);
                            boolean hasReturn = false;
                            for (DocTree dt : augmentedBlockTags) {
                                switch (dt.getKind()) {
                                    case PARAM: {
                                        missingParams.remove(((ParamTree)dt).getName().getName().toString());
                                        break;
                                    }
                                    case THROWS: {
                                        missingThrows.remove(this.getThrownException(task, el, docCommentTree, (ThrowsTree)dt));
                                        break;
                                    }
                                    case RETURN: {
                                        hasReturn = true;
                                    }
                                }
                            }
                            for (String missingParam : missingParams) {
                                syntheticTag = this.parseBlockTag(task, "@param " + missingParam + " {@inheritDoc}");
                                this.syntheticTrees.put(syntheticTag, "@param " + missingParam + " *\n");
                                this.insertTag(augmentedBlockTags, syntheticTag, parameters, throwsList);
                            }
                            for (String missingThrow : missingThrows) {
                                syntheticTag = this.parseBlockTag(task, "@throws " + missingThrow + " {@inheritDoc}");
                                this.syntheticTrees.put(syntheticTag, "@throws " + missingThrow + " *\n");
                                this.insertTag(augmentedBlockTags, syntheticTag, parameters, throwsList);
                            }
                            if (!hasReturn) {
                                DocTree syntheticTag2 = this.parseBlockTag(task, "@return {@inheritDoc}");
                                this.syntheticTrees.put(syntheticTag2, "@return *\n");
                                this.insertTag(augmentedBlockTags, syntheticTag2, parameters, throwsList);
                            }
                        }
                        this.scan(augmentedBlockTags, p);
                        Void void_ = null;
                        return void_;
                    }
                    finally {
                        this.interestingParent.pop();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void visitParam(ParamTree node, Void p) {
                    this.interestingParent.push(node);
                    try {
                        Void void_ = (Void)super.visitParam(node, p);
                        return void_;
                    }
                    finally {
                        this.interestingParent.pop();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void visitThrows(ThrowsTree node, Void p) {
                    this.interestingParent.push(node);
                    try {
                        Void void_ = (Void)super.visitThrows(node, p);
                        return void_;
                    }
                    finally {
                        this.interestingParent.pop();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void visitReturn(ReturnTree node, Void p) {
                    this.interestingParent.push(node);
                    try {
                        Void void_ = (Void)super.visitReturn(node, p);
                        return void_;
                    }
                    finally {
                        this.interestingParent.pop();
                    }
                }

                @Override
                public Void visitInheritDoc(InheritDocTree node, Void p) {
                    block15: {
                        if (this.inherited == null) {
                            try {
                                if (element.getKind() != ElementKind.METHOD) break block15;
                                ExecutableElement executableElement = (ExecutableElement)element;
                                Iterable superMethods = () -> this.superMethodsForInheritDoc(task, executableElement).iterator();
                                for (Element supMethod : superMethods) {
                                    String overriddenComment;
                                    Pair source = this.getSourceElement(task, supMethod);
                                    if (source == null || (overriddenComment = this.getResolvedDocComment((JavacTask)source.fst, (TreePath)source.snd)) == null) continue;
                                    this.inheritedJavacTask = (JavacTask)source.fst;
                                    this.inheritedTreePath = (TreePath)source.snd;
                                    this.inherited = overriddenComment;
                                    break;
                                }
                            }
                            catch (IOException ex) {
                                exception[0] = ex;
                                return null;
                            }
                        }
                    }
                    if (this.inherited == null) {
                        return null;
                    }
                    Pair parsed = this.parseDocComment(this.inheritedJavacTask, this.inherited);
                    final DocCommentTree inheritedDocTree = (DocCommentTree)parsed.fst;
                    int offset2 = (Integer)parsed.snd;
                    final ArrayList<List<? extends DocTree>> inheritedText = new ArrayList<List<? extends DocTree>>();
                    DocTree parent = this.interestingParent.peek();
                    switch (parent.getKind()) {
                        case DOC_COMMENT: {
                            inheritedText.add(inheritedDocTree.getFullBody());
                            break;
                        }
                        case PARAM: {
                            final String paramName = ((ParamTree)parent).getName().getName().toString();
                            new DocTreeScanner<Void, Void>(){

                                @Override
                                public Void visitParam(ParamTree node, Void p) {
                                    if (node.getName().getName().contentEquals(paramName)) {
                                        inheritedText.add(node.getDescription());
                                    }
                                    return (Void)super.visitParam(node, p);
                                }
                            }.scan(inheritedDocTree, null);
                            break;
                        }
                        case THROWS: {
                            final String thrownName = this.getThrownException(task, el, docCommentTree, (ThrowsTree)parent);
                            new DocTreeScanner<Void, Void>(){

                                @Override
                                public Void visitThrows(ThrowsTree node, Void p) {
                                    if (Objects.equals(this.getThrownException(inheritedJavacTask, inheritedTreePath, inheritedDocTree, node), thrownName)) {
                                        inheritedText.add(node.getDescription());
                                    }
                                    return (Void)super.visitThrows(node, p);
                                }
                            }.scan(inheritedDocTree, null);
                            break;
                        }
                        case RETURN: {
                            new DocTreeScanner<Void, Void>(){

                                @Override
                                public Void visitReturn(ReturnTree node, Void p) {
                                    inheritedText.add(node.getDescription());
                                    return (Void)super.visitReturn(node, p);
                                }
                            }.scan(inheritedDocTree, null);
                        }
                    }
                    if (!inheritedText.isEmpty()) {
                        String text;
                        long start = Long.MAX_VALUE;
                        long end = Long.MIN_VALUE;
                        for (DocTree t : (List)inheritedText.get(0)) {
                            start = Math.min(start, sp.getStartPosition(null, inheritedDocTree, t) - (long)offset2);
                            end = Math.max(end, sp.getEndPosition(null, inheritedDocTree, t) - (long)offset2);
                        }
                        String string = text = end >= 0L ? this.inherited.substring((int)start, (int)end) : "";
                        if (this.syntheticTrees.containsKey(parent)) {
                            int[] span = new int[]{(int)this.insertPos, (int)this.insertPos};
                            replace.computeIfAbsent(span, s -> new ArrayList()).add(this.syntheticTrees.get(parent).replace("*", text));
                        } else {
                            long inheritedStart = sp.getStartPosition(null, this.dcTree, node);
                            long inheritedEnd = sp.getEndPosition(null, this.dcTree, node);
                            int[] span = new int[]{(int)inheritedStart, (int)inheritedEnd};
                            replace.computeIfAbsent(span, s -> new ArrayList()).add(text);
                        }
                    }
                    return (Void)super.visitInheritDoc(node, p);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void scan(DocTree tree, Void p) {
                    if (exception[0] != null) {
                        return null;
                    }
                    boolean prevInSynthetic = this.inSynthetic;
                    try {
                        this.inSynthetic |= this.syntheticTrees.containsKey(tree);
                        Void void_ = (Void)super.scan(tree, p);
                        return void_;
                    }
                    finally {
                        long endPos;
                        if (!this.inSynthetic && tree != null && (endPos = sp.getEndPosition(null, this.dcTree, tree)) >= (long)offset) {
                            if (endPos - (long)offset + 1L < (long)docComment.length() && docComment.charAt((int)(endPos - (long)offset + 1L)) == '\n') {
                                ++endPos;
                            }
                            this.insertPos = endPos - (long)offset < (long)docComment.length() ? endPos + 1L : endPos;
                        }
                        this.inSynthetic = prevInSynthetic;
                    }
                }

                private void insertTag(List<DocTree> tags, DocTree toInsert, List<String> parameters, List<String> throwsTypes) {
                    Comparator comp = (tag1, tag2) -> {
                        if (tag1.getKind() == tag2.getKind()) {
                            switch (toInsert.getKind()) {
                                case PARAM: {
                                    ParamTree p1 = (ParamTree)tag1;
                                    ParamTree p2 = (ParamTree)tag2;
                                    int i1 = parameters.indexOf(p1.getName().getName().toString());
                                    int i2 = parameters.indexOf(p2.getName().getName().toString());
                                    return i1 - i2;
                                }
                                case THROWS: {
                                    ThrowsTree t1 = (ThrowsTree)tag1;
                                    ThrowsTree t2 = (ThrowsTree)tag2;
                                    int i1 = throwsTypes.indexOf(this.getThrownException(task, el, docCommentTree, t1));
                                    int i2 = throwsTypes.indexOf(this.getThrownException(task, el, docCommentTree, t2));
                                    return i1 - i2;
                                }
                            }
                        }
                        int i1 = this.tagOrder.indexOf((Object)tag1.getKind());
                        int i2 = this.tagOrder.indexOf((Object)tag2.getKind());
                        return i1 - i2;
                    };
                    for (int i = 0; i < tags.size(); ++i) {
                        if (comp.compare(tags.get(i), toInsert) < 0) continue;
                        tags.add(i, toInsert);
                        return;
                    }
                    tags.add(toInsert);
                }
            }.scan((DocTree)docCommentTree, (Void)null);
            if (replace.isEmpty()) {
                return docComment;
            }
            StringBuilder replacedInheritDoc = new StringBuilder(docComment);
            for (Map.Entry e : replace.entrySet()) {
                replacedInheritDoc.delete(((int[])e.getKey())[0] - offset, ((int[])e.getKey())[1] - offset);
                replacedInheritDoc.insert(((int[])e.getKey())[0] - offset, ((List)e.getValue()).stream().collect(Collectors.joining("")));
            }
            return replacedInheritDoc.toString();
        }

        private Stream<ExecutableElement> superMethodsForInheritDoc(JavacTask task, ExecutableElement method) {
            TypeElement type = (TypeElement)method.getEnclosingElement();
            return this.superTypeForInheritDoc(task, type).flatMap(sup -> ElementFilter.methodsIn(sup.getEnclosedElements()).stream()).filter(supMethod -> task.getElements().overrides(method, (ExecutableElement)supMethod, type));
        }

        private Stream<Element> superTypeForInheritDoc(JavacTask task, Element type) {
            TypeElement clazz = (TypeElement)type;
            Stream<Element> result = this.interfaces(clazz);
            result = Stream.concat(result, this.interfaces(clazz).flatMap(el -> this.superTypeForInheritDoc(task, (Element)el)));
            if (clazz.getSuperclass().getKind() == TypeKind.DECLARED) {
                Element superClass = ((DeclaredType)clazz.getSuperclass()).asElement();
                result = Stream.concat(result, Stream.of(superClass));
                result = Stream.concat(result, this.superTypeForInheritDoc(task, superClass));
            }
            return result;
        }

        private Stream<Element> interfaces(TypeElement clazz) {
            return clazz.getInterfaces().stream().filter(tm -> tm.getKind() == TypeKind.DECLARED).map(tm -> ((DeclaredType)tm).asElement());
        }

        private DocTree parseBlockTag(JavacTask task, String blockTag) {
            DocCommentTree dc = (DocCommentTree)this.parseDocComment((JavacTask)task, (String)blockTag).fst;
            return dc.getBlockTags().get(0);
        }

        private Pair<DocCommentTree, Integer> parseDocComment(JavacTask task, final String javadoc) {
            DocTrees trees = DocTrees.instance(task);
            try {
                SimpleJavaFileObject fo = new SimpleJavaFileObject(new URI("mem://doc.html"), JavaFileObject.Kind.HTML){

                    @Override
                    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
                        return "<body>" + javadoc + "</body>";
                    }
                };
                DocCommentTree tree = trees.getDocCommentTree(fo);
                int offset = (int)trees.getSourcePositions().getStartPosition(null, tree, tree);
                return Pair.of(tree, offset += "<body>".length());
            }
            catch (URISyntaxException ex) {
                throw new IllegalStateException(ex);
            }
        }

        private String getThrownException(JavacTask task, TreePath rootOn, DocCommentTree comment, ThrowsTree tt) {
            DocTrees trees = DocTrees.instance(task);
            Element exc = trees.getElement(new DocTreePath(new DocTreePath(rootOn, comment), tt.getExceptionName()));
            return exc != null ? exc.toString() : null;
        }

        private Pair<JavacTask, TreePath> getSourceElement(JavacTask origin, Element el) throws IOException {
            String handle = this.elementSignature(el);
            Pair<JavacTask, TreePath> cached = this.signature2Source.get(handle);
            if (cached != null) {
                return cached.fst != null ? cached : null;
            }
            TypeElement type = this.topLevelType(el);
            if (type == null) {
                return null;
            }
            Elements elements = origin.getElements();
            String binaryName = elements.getBinaryName(type).toString();
            ModuleElement module = elements.getModuleOf(type);
            String moduleName = module == null || module.isUnnamed() ? null : module.getQualifiedName().toString();
            Pair<JavacTask, CompilationUnitTree> source = this.findSource(moduleName, binaryName);
            if (source == null) {
                return null;
            }
            this.fillElementCache((JavacTask)source.fst, (CompilationUnitTree)source.snd);
            cached = this.signature2Source.get(handle);
            if (cached != null) {
                return cached;
            }
            this.signature2Source.put(handle, Pair.of(null, null));
            return null;
        }

        private String elementSignature(Element el) {
            switch (el.getKind()) {
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: 
                case RECORD: {
                    return ((TypeElement)el).getQualifiedName().toString();
                }
                case FIELD: {
                    return this.elementSignature(el.getEnclosingElement()) + "." + el.getSimpleName() + ":" + el.asType();
                }
                case ENUM_CONSTANT: {
                    return this.elementSignature(el.getEnclosingElement()) + "." + el.getSimpleName();
                }
                case EXCEPTION_PARAMETER: 
                case LOCAL_VARIABLE: 
                case PARAMETER: 
                case RESOURCE_VARIABLE: {
                    return el.getSimpleName() + ":" + el.asType();
                }
                case CONSTRUCTOR: 
                case METHOD: {
                    StringBuilder header = new StringBuilder();
                    header.append(this.elementSignature(el.getEnclosingElement()));
                    if (el.getKind() == ElementKind.METHOD) {
                        header.append(".");
                        header.append(el.getSimpleName());
                    }
                    header.append("(");
                    String sep = "";
                    ExecutableElement method = (ExecutableElement)el;
                    for (VariableElement variableElement : method.getParameters()) {
                        header.append(sep);
                        header.append(variableElement.asType());
                        sep = ", ";
                    }
                    header.append(")");
                    return header.toString();
                }
                case PACKAGE: 
                case STATIC_INIT: 
                case INSTANCE_INIT: 
                case TYPE_PARAMETER: 
                case OTHER: 
                case MODULE: 
                case RECORD_COMPONENT: 
                case BINDING_VARIABLE: {
                    return el.toString();
                }
            }
            throw Assert.error(el.getKind().name());
        }

        private TypeElement topLevelType(Element el) {
            if (el.getKind() == ElementKind.PACKAGE) {
                return null;
            }
            while (el != null && el.getEnclosingElement().getKind() != ElementKind.PACKAGE) {
                el = el.getEnclosingElement();
            }
            return el != null && (el.getKind().isClass() || el.getKind().isInterface()) ? (TypeElement)el : null;
        }

        private void fillElementCache(final JavacTask task, CompilationUnitTree cut) throws IOException {
            final Trees trees = Trees.instance(task);
            new TreePathScanner<Void, Void>(){

                @Override
                public Void visitMethod(MethodTree node, Void p) {
                    this.handleDeclaration();
                    return null;
                }

                @Override
                public Void visitClass(ClassTree node, Void p) {
                    this.handleDeclaration();
                    return (Void)super.visitClass(node, p);
                }

                @Override
                public Void visitVariable(VariableTree node, Void p) {
                    this.handleDeclaration();
                    return (Void)super.visitVariable(node, p);
                }

                private void handleDeclaration() {
                    Element currentElement = trees.getElement(this.getCurrentPath());
                    if (currentElement != null) {
                        signature2Source.put(this.elementSignature(currentElement), Pair.of(task, this.getCurrentPath()));
                    }
                }
            }.scan(cut, null);
        }

        private Pair<JavacTask, CompilationUnitTree> findSource(String moduleName, String binaryName) throws IOException {
            JavaFileObject jfo = this.fm.getJavaFileForInput(StandardLocation.SOURCE_PATH, binaryName, JavaFileObject.Kind.SOURCE);
            if (jfo == null) {
                return null;
            }
            List<JavaFileObject> jfos = Arrays.asList(jfo);
            JavaFileManager patchFM = moduleName != null ? new PatchModuleFileManager(this.baseFileManager, jfo, moduleName) : this.baseFileManager;
            JavacTaskImpl task = (JavacTaskImpl)compiler.getTask(null, patchFM, d -> {}, null, null, jfos);
            Iterable<? extends CompilationUnitTree> cuts = task.parse();
            task.enter();
            return Pair.of(task, cuts.iterator().next());
        }

        @Override
        public void close() throws IOException {
            this.fm.close();
        }

        private static final class PatchModuleFileManager
        extends ForwardingJavaFileManager<JavaFileManager> {
            private final JavaFileObject file;
            private final String moduleName;
            private static final JavaFileManager.Location PATCH_LOCATION = new JavaFileManager.Location(){

                @Override
                public String getName() {
                    return "PATCH_LOCATION";
                }

                @Override
                public boolean isOutputLocation() {
                    return false;
                }

                @Override
                public boolean isModuleOrientedLocation() {
                    return false;
                }
            };

            public PatchModuleFileManager(JavaFileManager fileManager, JavaFileObject file, String moduleName) {
                super(fileManager);
                this.file = file;
                this.moduleName = moduleName;
            }

            @Override
            public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, JavaFileObject fo) throws IOException {
                return fo == this.file ? PATCH_LOCATION : super.getLocationForModule(location, fo);
            }

            @Override
            public String inferModuleName(JavaFileManager.Location location) throws IOException {
                return location == PATCH_LOCATION ? this.moduleName : super.inferModuleName(location);
            }

            @Override
            public boolean hasLocation(JavaFileManager.Location location) {
                return location == StandardLocation.PATCH_MODULE_PATH || super.hasLocation(location);
            }
        }
    }
}

