/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phpunit.ui.options;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.phpunit.commands.PhpUnit;
import org.netbeans.modules.php.phpunit.commands.SkeletonGenerator;
import org.netbeans.modules.php.phpunit.ui.options.Bundle;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class PhpUnitOptionsPanel
extends JPanel {
    private static final long serialVersionUID = -846796509345860L;
    private static final String PHP_UNIT_LAST_FOLDER_SUFFIX = ".phpUnit";
    private static final String SKELETON_GENERATOR_LAST_FOLDER_SUFFIX = ".skeletonGenerator";
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JLabel errorLabel;
    private JLabel installationInfoLabel;
    private JLabel noteLabel;
    private JLabel phpUnit370InfoLabel;
    private JButton phpUnitBrowseButton;
    private JLabel phpUnitHintLabel;
    private JLabel phpUnitInfoLabel;
    private JLabel phpUnitLabel;
    private JLabel phpUnitLearnMoreLabel;
    private JLabel phpUnitPhp53InfoLabel;
    private JButton phpUnitSearchButton;
    private JTextField phpUnitTextField;
    private JLabel skelGenAbandonedLabel;
    private JButton skelGenBrowseButton;
    private JLabel skelGenHintLabel;
    private JLabel skelGenLabel;
    private JLabel skelGenLearnMoreLabel;
    private JButton skelGenSearchButton;
    private JTextField skelGenTextField;

    public PhpUnitOptionsPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.errorLabel.setText(" ");
        this.phpUnitHintLabel.setText(Bundle.PhpUnitOptionsPanel_phpUnit_hint("phpunit", PhpUnit.SCRIPT_NAME_LONG, "phpunit.phar"));
        this.skelGenHintLabel.setText(Bundle.PhpUnitOptionsPanel_skelGen_hint("phpunit-skelgen", SkeletonGenerator.SCRIPT_NAME_LONG, "phpunit-skelgen.phar"));
        DefaultDocumentListener defaultDocumentListener = new DefaultDocumentListener();
        this.phpUnitTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.skelGenTextField.getDocument().addDocumentListener(defaultDocumentListener);
    }

    public String getPhpUnit() {
        return this.phpUnitTextField.getText();
    }

    public void setPhpUnit(String phpUnit) {
        this.phpUnitTextField.setText(phpUnit);
    }

    public String getPhpUnitSkelGen() {
        return this.skelGenTextField.getText();
    }

    public void setPhpUnitSkelGen(String phpUnitSkelGen) {
        this.skelGenTextField.setText(phpUnitSkelGen);
    }

    public void setError(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.errorLabel.setText(message);
    }

    public void setWarning(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.warningForeground"));
        this.errorLabel.setText(message);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.phpUnitLabel = new JLabel();
        this.phpUnitTextField = new JTextField();
        this.phpUnitBrowseButton = new JButton();
        this.phpUnitSearchButton = new JButton();
        this.phpUnitHintLabel = new JLabel();
        this.skelGenLabel = new JLabel();
        this.skelGenTextField = new JTextField();
        this.skelGenBrowseButton = new JButton();
        this.skelGenSearchButton = new JButton();
        this.skelGenHintLabel = new JLabel();
        this.noteLabel = new JLabel();
        this.phpUnitInfoLabel = new JLabel();
        this.phpUnitPhp53InfoLabel = new JLabel();
        this.phpUnit370InfoLabel = new JLabel();
        this.skelGenAbandonedLabel = new JLabel();
        this.installationInfoLabel = new JLabel();
        this.phpUnitLearnMoreLabel = new JLabel();
        this.skelGenLearnMoreLabel = new JLabel();
        this.errorLabel = new JLabel();
        this.phpUnitLabel.setLabelFor(this.phpUnitBrowseButton);
        Mnemonics.setLocalizedText((JLabel)this.phpUnitLabel, (String)NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.phpUnitLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.phpUnitBrowseButton, (String)NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.phpUnitBrowseButton.text"));
        this.phpUnitBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhpUnitOptionsPanel.this.phpUnitBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.phpUnitSearchButton, (String)NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.phpUnitSearchButton.text"));
        this.phpUnitSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhpUnitOptionsPanel.this.phpUnitSearchButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.phpUnitHintLabel, (String)"HINT");
        this.skelGenLabel.setLabelFor(this.skelGenTextField);
        Mnemonics.setLocalizedText((JLabel)this.skelGenLabel, (String)NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.skelGenLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.skelGenBrowseButton, (String)NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.skelGenBrowseButton.text"));
        this.skelGenBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhpUnitOptionsPanel.this.skelGenBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.skelGenSearchButton, (String)NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.skelGenSearchButton.text"));
        this.skelGenSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhpUnitOptionsPanel.this.skelGenSearchButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.skelGenHintLabel, (String)"HINT");
        Mnemonics.setLocalizedText((JLabel)this.noteLabel, (String)NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.noteLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.phpUnitInfoLabel, (String)NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.phpUnitInfoLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.phpUnitPhp53InfoLabel, (String)NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.phpUnitPhp53InfoLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.phpUnit370InfoLabel, (String)NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.phpUnit370InfoLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.skelGenAbandonedLabel, (String)NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.skelGenAbandonedLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.installationInfoLabel, (String)NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.installationInfoLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.phpUnitLearnMoreLabel, (String)NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.phpUnitLearnMoreLabel.text"));
        this.phpUnitLearnMoreLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                PhpUnitOptionsPanel.this.phpUnitLearnMoreLabelMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                PhpUnitOptionsPanel.this.phpUnitLearnMoreLabelMousePressed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.skelGenLearnMoreLabel, (String)NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.skelGenLearnMoreLabel.text"));
        this.skelGenLearnMoreLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                PhpUnitOptionsPanel.this.skelGenLearnMoreLabelMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                PhpUnitOptionsPanel.this.skelGenLearnMoreLabelMousePressed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)"ERROR");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.phpUnitLabel).addComponent(this.skelGenLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.skelGenTextField, GroupLayout.Alignment.TRAILING).addComponent(this.phpUnitTextField, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.phpUnitBrowseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.phpUnitSearchButton)).addGroup(layout.createSequentialGroup().addComponent(this.skelGenBrowseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.skelGenSearchButton)))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.skelGenHintLabel).addComponent(this.phpUnitHintLabel)).addGap(0, 0, Short.MAX_VALUE)))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.errorLabel).addComponent(this.noteLabel, -2, -1, -2).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.phpUnitInfoLabel, -2, -1, -2).addComponent(this.phpUnitPhp53InfoLabel).addComponent(this.installationInfoLabel).addComponent(this.phpUnitLearnMoreLabel, -2, -1, -2).addComponent(this.skelGenLearnMoreLabel, -2, -1, -2).addComponent(this.phpUnit370InfoLabel)))).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.skelGenAbandonedLabel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(0, this.phpUnitBrowseButton, this.phpUnitSearchButton, this.skelGenBrowseButton, this.skelGenSearchButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.phpUnitLabel).addComponent(this.phpUnitTextField, -2, -1, -2).addComponent(this.phpUnitSearchButton).addComponent(this.phpUnitBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.phpUnitHintLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.skelGenTextField, -2, -1, -2).addComponent(this.skelGenLabel).addComponent(this.skelGenSearchButton).addComponent(this.skelGenBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.skelGenHintLabel).addGap(18, 18, 18).addComponent(this.noteLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.phpUnitInfoLabel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.phpUnitPhp53InfoLabel).addGap(18, 18, 18).addComponent(this.phpUnit370InfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.skelGenAbandonedLabel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.installationInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.phpUnitLearnMoreLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.skelGenLearnMoreLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.errorLabel).addGap(0, 0, 0)));
        this.phpUnitLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.phpUnitLabel.AccessibleContext.accessibleName_1"));
        this.phpUnitLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.phpUnitLabel.AccessibleContext.accessibleDescription_1"));
        this.phpUnitTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.phpUnitTextField.AccessibleContext.accessibleName_1"));
        this.phpUnitTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.phpUnitTextField.AccessibleContext.accessibleDescription_1"));
        this.phpUnitBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.phpUnitBrowseButton.AccessibleContext.accessibleName_1"));
        this.phpUnitBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.phpUnitBrowseButton.AccessibleContext.accessibleDescription_1"));
        this.phpUnitSearchButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.phpUnitSearchButton.AccessibleContext.accessibleName_1"));
        this.phpUnitSearchButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.phpUnitSearchButton.AccessibleContext.accessibleDescription_1"));
        this.phpUnitHintLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.scriptInfoLabel.AccessibleContext.accessibleName"));
        this.phpUnitHintLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.scriptInfoLabel.AccessibleContext.accessibleDescription"));
        this.noteLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.noteLabel.AccessibleContext.accessibleName"));
        this.noteLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.noteLabel.AccessibleContext.accessibleDescription"));
        this.phpUnitInfoLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.phpUnitInfoLabel.AccessibleContext.accessibleName"));
        this.phpUnitInfoLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.phpUnitInfoLabel.AccessibleContext.accessibleDescription"));
        this.phpUnitPhp53InfoLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.phpUnitPhp53InfoLabel.AccessibleContext.accessibleName"));
        this.phpUnitPhp53InfoLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.phpUnitPhp53InfoLabel.AccessibleContext.accessibleDescription"));
        this.installationInfoLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.installationInfoLabel.AccessibleContext.accessibleName"));
        this.installationInfoLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.installationInfoLabel.AccessibleContext.accessibleDescription"));
        this.phpUnitLearnMoreLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.learnMoreLabel.AccessibleContext.accessibleName"));
        this.phpUnitLearnMoreLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.learnMoreLabel.AccessibleContext.accessibleDescription"));
        this.errorLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.errorLabel.AccessibleContext.accessibleName"));
        this.errorLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.errorLabel.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.AccessibleContext.accessibleDescription"));
    }

    private void phpUnitBrowseButtonActionPerformed(ActionEvent evt) {
        File file = new FileChooserBuilder(PhpUnitOptionsPanel.class.getName() + PHP_UNIT_LAST_FOLDER_SUFFIX).setFilesOnly(true).setTitle(Bundle.PhpUnitOptionsPanel_phpunit_browse_title()).showOpenDialog();
        if (file != null) {
            this.phpUnitTextField.setText(file.getAbsolutePath());
        }
    }

    private void phpUnitSearchButtonActionPerformed(ActionEvent evt) {
        String phpUnit = UiUtils.SearchWindow.search((UiUtils.SearchWindow.SearchWindowSupport)new UiUtils.SearchWindow.SearchWindowSupport(){

            public List<String> detect() {
                return FileUtils.findFileOnUsersPath((String[])new String[]{"phpunit", PhpUnit.SCRIPT_NAME_LONG, "phpunit.phar"});
            }

            public String getWindowTitle() {
                return Bundle.PhpUnitOptionsPanel_phpUnit_search_title();
            }

            public String getListTitle() {
                return Bundle.PhpUnitOptionsPanel_phpUnit_search_scripts();
            }

            public String getPleaseWaitPart() {
                return Bundle.PhpUnitOptionsPanel_phpUnit_search_pleaseWaitPart();
            }

            public String getNoItemsFound() {
                return Bundle.PhpUnitOptionsPanel_phpUnit_search_notFound();
            }
        });
        if (phpUnit != null) {
            this.phpUnitTextField.setText(phpUnit);
        }
    }

    private void phpUnitLearnMoreLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void phpUnitLearnMoreLabelMousePressed(MouseEvent evt) {
        try {
            URL url = new URL("http://phpunit.de/");
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void skelGenLearnMoreLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void skelGenLearnMoreLabelMousePressed(MouseEvent evt) {
        try {
            URL url = new URL("https://github.com/VitexSoftware/phpunit-skeleton-generator");
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void skelGenBrowseButtonActionPerformed(ActionEvent evt) {
        File skelGen = new FileChooserBuilder(PhpUnitOptionsPanel.class.getName() + SKELETON_GENERATOR_LAST_FOLDER_SUFFIX).setTitle(Bundle.PhpUnitOptionsPanel_skelGen_browse()).setFilesOnly(true).showOpenDialog();
        if (skelGen != null) {
            skelGen = FileUtil.normalizeFile((File)skelGen);
            this.skelGenTextField.setText(skelGen.getAbsolutePath());
        }
    }

    private void skelGenSearchButtonActionPerformed(ActionEvent evt) {
        String skelGen = UiUtils.SearchWindow.search((UiUtils.SearchWindow.SearchWindowSupport)new UiUtils.SearchWindow.SearchWindowSupport(){

            public List<String> detect() {
                return FileUtils.findFileOnUsersPath((String[])new String[]{"phpunit-skelgen", SkeletonGenerator.SCRIPT_NAME_LONG, "phpunit-skelgen.phar"});
            }

            public String getWindowTitle() {
                return Bundle.PhpUnitOptionsPanel_skelGen_search_title();
            }

            public String getListTitle() {
                return Bundle.PhpUnitOptionsPanel_skelGen_search_scripts();
            }

            public String getPleaseWaitPart() {
                return Bundle.PhpUnitOptionsPanel_skelGen_search_pleaseWaitPart();
            }

            public String getNoItemsFound() {
                return Bundle.PhpUnitOptionsPanel_skelGen_search_notFound();
            }
        });
        if (skelGen != null) {
            this.skelGenTextField.setText(skelGen);
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            PhpUnitOptionsPanel.this.fireChange();
        }
    }
}

