/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.disco;

import eu.hansolo.jdktools.Architecture;
import eu.hansolo.jdktools.OperatingSystem;
import java.io.File;
import org.netbeans.modules.java.disco.DiscoPlatformInstall;
import org.openide.util.Utilities;

public class OS {
    public static OperatingSystem getOperatingSystem() {
        if (Utilities.isMac()) {
            return OperatingSystem.MACOS;
        }
        if (Utilities.isWindows()) {
            return OperatingSystem.WINDOWS;
        }
        if (Utilities.isUnix()) {
            String os = System.getProperty("os.name").toLowerCase();
            if (os.contains("sunos")) {
                return OperatingSystem.SOLARIS;
            }
            return OperatingSystem.LINUX;
        }
        return OperatingSystem.NONE;
    }

    public static Architecture getArchitecture() {
        Architecture arch = Architecture.fromText(System.getProperty("os.arch"));
        if (arch == Architecture.NOT_FOUND) {
            return Architecture.NONE;
        }
        return arch;
    }

    public static File getDefaultDownloadFolder() {
        return DiscoPlatformInstall.getDefaultDownloadFolder();
    }
}

