/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.validator;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.ValidatorResources;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ModuleConfig;
import org.xml.sax.SAXException;

public class ValidatorPlugIn
implements PlugIn {
    private static Log log = LogFactory.getLog((Class)ValidatorPlugIn.class);
    private static final String RESOURCE_DELIM = ",";
    public static final String VALIDATOR_KEY = "org.apache.commons.validator.VALIDATOR_RESOURCES";
    public static final String STOP_ON_ERROR_KEY = "org.apache.struts.validator.STOP_ON_ERROR";
    private ModuleConfig config = null;
    private ActionServlet servlet = null;
    protected ValidatorResources resources = null;
    private String pathnames = null;
    private boolean stopOnFirstError = true;

    public String getPathnames() {
        return this.pathnames;
    }

    public void setPathnames(String pathnames) {
        this.pathnames = pathnames;
    }

    public boolean isStopOnFirstError() {
        return this.stopOnFirstError;
    }

    public void setStopOnFirstError(boolean stopOnFirstError) {
        this.stopOnFirstError = stopOnFirstError;
    }

    public void init(ActionServlet servlet, ModuleConfig config) throws ServletException {
        this.config = config;
        this.servlet = servlet;
        try {
            this.initResources();
            servlet.getServletContext().setAttribute(VALIDATOR_KEY + config.getPrefix(), (Object)this.resources);
            servlet.getServletContext().setAttribute("org.apache.struts.validator.STOP_ON_ERROR." + config.getPrefix(), (Object)(this.stopOnFirstError ? Boolean.TRUE : Boolean.FALSE));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UnavailableException("Cannot load a validator resource from '" + this.pathnames + "'");
        }
    }

    public void destroy() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Destroying ValidatorPlugin");
        }
        this.servlet = null;
        this.config = null;
        this.destroyResources();
    }

    protected void initResources() throws IOException, ServletException {
        if (this.pathnames == null || this.pathnames.length() <= 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(this.pathnames, RESOURCE_DELIM);
        ArrayList<URL> urlList = new ArrayList<URL>();
        try {
            while (st.hasMoreTokens()) {
                URL input;
                String validatorRules = st.nextToken().trim();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Loading validation rules file from '" + validatorRules + "'"));
                }
                if ((input = this.servlet.getServletContext().getResource(validatorRules)) == null) {
                    input = this.getClass().getResource(validatorRules);
                }
                if (input != null) {
                    urlList.add(input);
                    continue;
                }
                throw new ServletException("Skipping validation rules file from '" + validatorRules + "'.  No url could be located.");
            }
            int urlSize = urlList.size();
            URL[] urlArray = new URL[urlSize];
            for (int urlIndex = 0; urlIndex < urlSize; ++urlIndex) {
                urlArray[urlIndex] = (URL)urlList.get(urlIndex);
            }
            this.resources = new ValidatorResources(urlArray);
        }
        catch (SAXException sex) {
            log.error((Object)"Skipping all validation", (Throwable)sex);
            throw new ServletException((Throwable)sex);
        }
    }

    protected void destroyResources() {
        this.resources = null;
    }
}

