/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.database.model.UpdateHistoryEntry;
import com.oracle.bmc.database.requests.GetCloudVmClusterUpdateHistoryEntryRequest;
import com.oracle.bmc.database.responses.GetCloudVmClusterUpdateHistoryEntryResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetCloudVmClusterUpdateHistoryEntryConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetCloudVmClusterUpdateHistoryEntryConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetCloudVmClusterUpdateHistoryEntryRequest interceptRequest(GetCloudVmClusterUpdateHistoryEntryRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetCloudVmClusterUpdateHistoryEntryRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getCloudVmClusterId(), (String)"cloudVmClusterId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getUpdateHistoryEntryId(), (String)"updateHistoryEntryId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("cloudVmClusters").path(HttpUtils.encodePathSegment((String)request.getCloudVmClusterId())).path("updateHistoryEntries").path(HttpUtils.encodePathSegment((String)request.getUpdateHistoryEntryId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, GetCloudVmClusterUpdateHistoryEntryResponse> fromResponse() {
        Function<Response, GetCloudVmClusterUpdateHistoryEntryResponse> transformer = new Function<Response, GetCloudVmClusterUpdateHistoryEntryResponse>(){

            public GetCloudVmClusterUpdateHistoryEntryResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.database.responses.GetCloudVmClusterUpdateHistoryEntryResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(UpdateHistoryEntry.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetCloudVmClusterUpdateHistoryEntryResponse.Builder builder = GetCloudVmClusterUpdateHistoryEntryResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.updateHistoryEntry((UpdateHistoryEntry)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetCloudVmClusterUpdateHistoryEntryResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

