/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.metadata.model;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

public class MetadataUtilities {
    private MetadataUtilities() {
    }

    public static <V> V find(String key, Map<String, ? extends V> map) {
        V value = map.get(key);
        if (value != null) {
            return value;
        }
        for (Map.Entry<String, V> entry : map.entrySet()) {
            if (!MetadataUtilities.equals(key, entry.getKey(), true)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static boolean equals(String str1, String str2) {
        return MetadataUtilities.equals(str1, str2, false);
    }

    private static boolean equals(String str1, String str2, boolean ignoreCase) {
        if (str1 == null) {
            return str2 == null;
        }
        return ignoreCase ? str1.equalsIgnoreCase(str2) : str1.equals(str2);
    }

    public static String trimmed(String input) {
        if (input == null) {
            return input;
        }
        return input.trim();
    }

    public static ResultSet getColumns(DatabaseMetaData dmd, String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        try {
            return dmd.getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new SQLException(t);
        }
    }

    public static ResultSet getIndexInfo(DatabaseMetaData dmd, String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        try {
            return dmd.getIndexInfo(catalog, schema, table, unique, approximate);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new SQLException(t);
        }
    }

    public static ResultSet getImportedKeys(DatabaseMetaData dmd, String catalog, String schema, String table) throws SQLException {
        try {
            return dmd.getImportedKeys(catalog, schema, table);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new SQLException(t);
        }
    }

    public static ResultSet getPrimaryKeys(DatabaseMetaData dmd, String catalog, String schema, String table) throws SQLException {
        try {
            return dmd.getPrimaryKeys(catalog, schema, table);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new SQLException(t);
        }
    }

    public static ResultSet getTables(DatabaseMetaData dmd, String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        try {
            return dmd.getTables(catalog, schemaPattern, tableNamePattern, types);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new SQLException(t);
        }
    }

    public static ResultSet getProcedures(DatabaseMetaData dmd, String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        try {
            return dmd.getProcedures(catalog, schemaPattern, procedureNamePattern);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new SQLException(t);
        }
    }

    public static ResultSet getFunctions(DatabaseMetaData dmd, String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        try {
            return dmd.getFunctions(catalog, schemaPattern, functionNamePattern);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new SQLException(t);
        }
    }
}

