/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.wizards;

import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.web.jsf.JSFFrameworkProvider;
import org.netbeans.modules.web.jsf.JSFUtils;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFVersion;
import org.netbeans.modules.web.jsf.palette.JSFPaletteUtilities;
import org.netbeans.modules.web.jsf.wizards.TemplateClientPanel;
import org.netbeans.modules.web.jsf.wizards.TemplateClientPanelVisual;
import org.netbeans.modules.web.jsf.wizards.TemplateIterator;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;

public class TemplateClientIterator
implements TemplateWizard.Iterator {
    private static final long serialVersionUID = 1L;
    private int index;
    private transient WizardDescriptor.Panel[] panels;
    private TemplateClientPanel templateClientPanel;
    private static final String ENCODING = "UTF-8";
    private static String END_LINE = System.getProperty("line.separator");

    public Set instantiate(final TemplateWizard wiz) throws IOException {
        FileObject dir = Templates.getTargetFolder((WizardDescriptor)wiz);
        final String targetName = Templates.getTargetName((WizardDescriptor)wiz);
        final DataFolder df = DataFolder.findFolder((FileObject)dir);
        df.getPrimaryFile().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                InputStream is = TemplateClientIterator.this.templateClientPanel.getTemplateClient();
                String content = JSFFrameworkProvider.readResource(is, TemplateClientIterator.ENCODING);
                FileObject target = df.getPrimaryFile().createData(targetName, "xhtml");
                TemplateClientPanel.TemplateEntry templateEntry = TemplateClientIterator.this.templateClientPanel.getTemplate();
                String relativePath = TemplateClientIterator.getTemplatePath(target, templateEntry);
                String definedTags = TemplateClientIterator.this.createDefineTags(TemplateClientIterator.this.templateClientPanel.getTemplateDataToGenerate(), content.indexOf("<html") == -1 ? 1 : 3);
                Project project = Templates.getProject((WizardDescriptor)wiz);
                JSFVersion jsfVersion = JSFVersion.forProject(project);
                String namespaceLocation = jsfVersion != null && jsfVersion.isAtLeast(JSFVersion.JSF_2_2) ? "http://xmlns.jcp.org" : "http://java.sun.com";
                HashMap<String, String> args = new HashMap<String, String>();
                args.put("TEMPLATE", relativePath);
                args.put("DEFINE_TAGS", definedTags);
                args.put("NS_LOCATION", namespaceLocation);
                MapFormat formater = new MapFormat(args);
                formater.setLeftBrace("__");
                formater.setRightBrace("__");
                formater.setExactMatch(false);
                content = formater.format((Object)content);
                JSFFrameworkProvider.createFile(target, content, TemplateClientIterator.ENCODING);
            }
        });
        FileObject target = df.getPrimaryFile().getFileObject(targetName, "xhtml");
        DataObject dob = DataObject.find((FileObject)target);
        if (dob != null) {
            JSFPaletteUtilities.reformat(dob);
        }
        return Collections.singleton(dob);
    }

    private static String getTemplatePath(FileObject target, TemplateClientPanel.TemplateEntry templateEntry) {
        if (!templateEntry.isResourceLibraryContract()) {
            return JSFUtils.getRelativePath(target, templateEntry.getTemplate());
        }
        String fullpath = templateEntry.getTemplate().getPath();
        return TemplateClientPanelVisual.getRelativePathInsideResourceLibrary(fullpath);
    }

    public void initialize(TemplateWizard wiz) {
        this.index = 0;
        Project project = Templates.getProject((WizardDescriptor)wiz);
        this.panels = this.createPanels(project, wiz);
        Object prop = wiz.getProperty("WizardPanel_contentData");
        String[] beforeSteps = null;
        if (prop != null && prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        String[] steps = this.createSteps(beforeSteps, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(TemplateWizard wiz) {
        this.panels = null;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public String name() {
        return NbBundle.getMessage(TemplateIterator.class, (String)"TITLE_x_of_y", (Object)(this.index + 1), (Object)this.panels.length);
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    protected WizardDescriptor.Panel[] createPanels(Project project, TemplateWizard wiz) {
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] docSourceGroups = sources.getSourceGroups("doc_root");
        SourceGroup[] sourceGroups = docSourceGroups.length == 0 ? sources.getSourceGroups("java") : docSourceGroups;
        this.templateClientPanel = new TemplateClientPanel((WizardDescriptor)wiz);
        return new WizardDescriptor.Panel[]{Templates.buildSimpleTargetChooser((Project)project, (SourceGroup[])sourceGroups).bottomPanel((WizardDescriptor.Panel)this.templateClientPanel).create()};
    }

    private String[] createSteps(String[] before, WizardDescriptor.Panel[] panels) {
        int diff = 0;
        if (before == null) {
            before = new String[]{};
        } else if (before.length > 0) {
            diff = "...".equals(before[before.length - 1]) ? 1 : 0;
        }
        String[] res = new String[before.length - diff + panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < before.length - diff ? before[i] : panels[i - before.length + diff].getComponent().getName();
        }
        return res;
    }

    private String createDefineTags(Collection<String> data, int indent) {
        StringBuffer sb = new StringBuffer();
        String basicIndent = "    ";
        for (String temp : data) {
            int i;
            sb.append(END_LINE);
            for (i = 0; i < indent; ++i) {
                sb.append("    ");
            }
            sb.append("<ui:define name=\"").append(temp).append("\">");
            sb.append(END_LINE);
            for (i = 0; i < indent + 1; ++i) {
                sb.append("    ");
            }
            sb.append(temp);
            sb.append(END_LINE);
            for (i = 0; i < indent; ++i) {
                sb.append("    ");
            }
            sb.append("</ui:define>");
            sb.append(END_LINE);
        }
        return sb.toString();
    }
}

