/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.weblogic.common.api;

import java.util.Locale;
import java.util.Objects;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;

public final class DeploymentTarget {
    private final String name;
    private final Type type;

    DeploymentTarget(String name, Type type) {
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public int hashCode() {
        int hash = 3;
        hash = 83 * hash + Objects.hashCode(this.name);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeploymentTarget other = (DeploymentTarget)obj;
        return Objects.equals(this.name, other.name);
    }

    public static enum Type {
        SERVER,
        CLUSTER,
        JMS_SERVER;


        @CheckForNull
        public static Type parse(@NonNull String text) {
            String upper = text.toUpperCase(Locale.ENGLISH);
            for (Type t : Type.values()) {
                if (!t.name().equals(upper)) continue;
                return t;
            }
            if ("JMSSERVER".equals(upper)) {
                return JMS_SERVER;
            }
            return null;
        }
    }
}

