/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common.wizards;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileFilter;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.payara.common.PayaraPlatformDetails;
import org.netbeans.modules.payara.common.ui.IpComboBox;
import org.netbeans.modules.payara.spi.Utils;
import org.netbeans.modules.payara.tooling.data.PayaraPlatformVersionAPI;
import org.netbeans.modules.payara.tooling.utils.NetUtils;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class AddDomainLocationVisualPanel
extends JPanel {
    private final transient List<ChangeListener> listeners = new CopyOnWriteArrayList<ChangeListener>();
    Set<? extends InetAddress> ips = NetUtils.getHostIP4s();
    private boolean isLocal;
    private int defaultDasPort;
    private int defaultHttpPort;
    private JTextField containerPathField;
    private JLabel containerPathLabel;
    private JTextField dasPortField;
    private JLabel dasPortFieldLabel;
    private JCheckBox dockerVolumeCheckBox;
    private JComboBox domainLocalField;
    private JLabel domainLocalLabel;
    private JTextField domainRemoteField;
    private JLabel domainRemoteLabel;
    private JComboBox hostLocalField;
    private JLabel hostLocalLabel;
    private JTextField hostPathField;
    private JLabel hostPathLabel;
    private JTextField hostRemoteField;
    private JLabel hostRemoteLabel;
    private JTextField httpPortField;
    private JLabel httpPortFieldLabel;
    private JCheckBox localIpCB;
    private JPasswordField passwordField;
    private JLabel passwordLabel;
    private JLabel remoteLink;
    private JPanel remotePanel;
    private JTextField targetValueField;
    private JLabel targetValueLabel;
    private JCheckBox useDefaultPortsCB;
    private JTextField userNameField;
    private JLabel userNameLabel;

    public AddDomainLocationVisualPanel() {
        this.initComponents();
        this.dasPortField.setEnabled(false);
        this.httpPortField.setEnabled(false);
        this.defaultDasPort = 4848;
        this.defaultHttpPort = 8080;
        this.setName(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"TITLE_DomainLocation"));
    }

    void initModels(String gfRoot, boolean isLocal) {
        if (isLocal) {
            this.domainLocalLabel.setVisible(true);
            this.domainLocalField.setVisible(true);
            this.hostLocalLabel.setVisible(true);
            this.hostLocalField.setVisible(true);
            this.localIpCB.setVisible(true);
            this.domainRemoteLabel.setVisible(false);
            this.domainRemoteField.setVisible(false);
            this.hostRemoteLabel.setVisible(false);
            this.hostRemoteField.setVisible(false);
            this.remoteLink.setVisible(false);
            this.dockerVolumeCheckBox.setVisible(false);
        } else {
            this.domainLocalLabel.setVisible(false);
            this.domainLocalField.setVisible(false);
            this.hostLocalLabel.setVisible(false);
            this.hostLocalField.setVisible(false);
            this.localIpCB.setVisible(false);
            this.domainRemoteLabel.setVisible(true);
            this.domainRemoteField.setVisible(true);
            this.hostRemoteLabel.setVisible(true);
            this.hostRemoteField.setVisible(true);
            this.remoteLink.setVisible(true);
            this.dockerVolumeCheckBox.setVisible(true);
        }
        this.hostPathLabel.setVisible(this.dockerVolumeCheckBox.isSelected());
        this.hostPathField.setVisible(this.dockerVolumeCheckBox.isSelected());
        this.containerPathLabel.setVisible(this.dockerVolumeCheckBox.isSelected());
        this.containerPathField.setVisible(this.dockerVolumeCheckBox.isSelected());
        MyKeyListener kl = new MyKeyListener();
        if (isLocal) {
            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
            File domainsDir = new File(gfRoot, "domains");
            File[] candidates = domainsDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File dir) {
                    File logsDir = new File(dir, "logs");
                    return Utils.canWrite(logsDir);
                }
            });
            if (null != candidates) {
                for (File f : candidates) {
                    model.addElement(f.getName());
                }
            }
            if (model.getSize() == 0) {
                FileObject userHome = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(System.getProperty("user.home"))));
                String defaultItem = FileUtil.findFreeFolderName((FileObject)userHome, (String)"personal_domain");
                model.addElement(System.getProperty("user.home") + File.separator + defaultItem);
            }
            this.domainLocalField.setModel(model);
            this.domainLocalField.getEditor().getEditorComponent().addKeyListener(kl);
            this.domainLocalField.addActionListener(arg0 -> {
                this.domainLocalField.getEditor().setItem(this.domainLocalField.getSelectedItem());
                this.fireChangeEvent();
            });
            this.localIpCB.addActionListener(e -> {
                this.updateLocalIpsCombobox();
                this.fireChangeEvent();
            });
            this.updateLocalIpsCombobox();
        } else {
            this.domainRemoteField.addKeyListener(kl);
            this.hostRemoteField.addKeyListener(kl);
        }
        this.useDefaultPortsCB.addActionListener(e -> {
            this.updatePortsFields();
            this.fireChangeEvent();
        });
        this.dasPortField.addKeyListener(kl);
        this.httpPortField.addKeyListener(kl);
        this.initPortsFields();
        Optional<PayaraPlatformVersionAPI> serverDetails = PayaraPlatformDetails.getVersionFromInstallDirectory(new File(gfRoot));
        if (serverDetails.isPresent() && !serverDetails.get().isMinimumSupportedVersion()) {
            this.targetValueField.setText("");
            this.targetValueField.setEnabled(false);
        } else {
            this.targetValueField.setText("");
            this.targetValueField.setEnabled(true);
        }
        this.targetValueField.addKeyListener(kl);
        this.userNameField.addKeyListener(kl);
        this.passwordField.addKeyListener(kl);
        this.hostPathField.addKeyListener(kl);
        this.containerPathField.addKeyListener(kl);
    }

    String getAdminPortValue() {
        return this.dasPortField.getText().trim();
    }

    void setAdminPortValue(String port) {
        this.dasPortField.setText(port);
    }

    String getHttpPortValue() {
        return this.httpPortField.getText().trim();
    }

    void setHttpPortValue(String port) {
        this.httpPortField.setText(port);
    }

    String getTargetValue() {
        return this.targetValueField.getText().trim();
    }

    String getUserNameValue() {
        return this.userNameField.getText().trim();
    }

    boolean getDockerValue() {
        return this.dockerVolumeCheckBox.isSelected();
    }

    String getHostPathValue() {
        return this.hostPathField.getText().trim();
    }

    String getContainerPathValue() {
        return this.containerPathField.getText().trim();
    }

    String getPasswordValue() {
        return new String(this.passwordField.getPassword());
    }

    boolean getUseDefaultPorts() {
        return this.useDefaultPortsCB.isEnabled() && this.useDefaultPortsCB.isSelected();
    }

    Object getLocalHost() {
        return this.hostLocalField.getEditor().getItem();
    }

    String getRemoteHost() {
        return this.hostRemoteField.getText().trim();
    }

    String getLocalDomain() {
        return (String)this.domainLocalField.getEditor().getItem();
    }

    String getRemoteDomain() {
        return this.domainRemoteField.getText().trim();
    }

    private String initAdminPortValue() {
        return Integer.toString(this.defaultDasPort);
    }

    private String initHttpPortValue() {
        return Integer.toString(this.defaultHttpPort);
    }

    private String initUserNameValue() {
        return "";
    }

    private String initPasswordValue() {
        return "";
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    private void fireChangeEvent() {
        ChangeEvent ev = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(ev);
        }
    }

    private void updateLocalIpsCombobox() {
        ((IpComboBox)this.hostLocalField).updateModel(this.ips, this.localIpCB.isSelected());
    }

    private void initPortsFields() {
        this.dasPortField.setText(this.initAdminPortValue());
        this.httpPortField.setText(this.initHttpPortValue());
        if (this.useDefaultPortsCB.isSelected()) {
            this.dasPortField.setEnabled(false);
            this.httpPortField.setEnabled(false);
        } else {
            this.dasPortField.setEnabled(true);
            this.httpPortField.setEnabled(true);
        }
    }

    private void updatePortsFields() {
        if (this.useDefaultPortsCB.isSelected()) {
            this.dasPortField.setText(this.initAdminPortValue());
            this.httpPortField.setText(this.initHttpPortValue());
            this.dasPortField.setEnabled(false);
            this.httpPortField.setEnabled(false);
        } else {
            this.dasPortField.setEnabled(true);
            this.httpPortField.setEnabled(true);
        }
    }

    void setPortsFields(int dasPort, int httpPort, boolean localExistindDomain) {
        if (localExistindDomain) {
            this.useDefaultPortsCB.setSelected(true);
            this.useDefaultPortsCB.setEnabled(false);
            if (dasPort >= 0) {
                this.defaultDasPort = dasPort;
            }
            if (httpPort >= 0) {
                this.defaultHttpPort = httpPort;
            }
        } else {
            this.useDefaultPortsCB.setEnabled(true);
            this.defaultDasPort = 4848;
            this.defaultHttpPort = 8080;
        }
        this.updatePortsFields();
    }

    void setPortsFields(boolean localExistindDomain) {
        this.setPortsFields(-1, -1, localExistindDomain);
    }

    private void initComponents() {
        this.targetValueLabel = new JLabel();
        this.targetValueField = new JTextField();
        this.userNameLabel = new JLabel();
        this.userNameField = new JTextField();
        this.passwordLabel = new JLabel();
        this.passwordField = new JPasswordField();
        this.dasPortFieldLabel = new JLabel();
        this.dasPortField = new JTextField();
        this.httpPortFieldLabel = new JLabel();
        this.httpPortField = new JTextField();
        this.useDefaultPortsCB = new JCheckBox();
        this.remotePanel = new JPanel();
        this.domainLocalLabel = new JLabel();
        this.domainLocalField = new JComboBox();
        this.hostLocalLabel = new JLabel();
        this.localIpCB = new JCheckBox();
        this.hostLocalField = new IpComboBox(this.ips, this.localIpCB.isSelected());
        this.hostRemoteField = new JTextField();
        this.hostRemoteLabel = new JLabel();
        this.domainRemoteLabel = new JLabel();
        this.domainRemoteField = new JTextField();
        this.remoteLink = new JLabel();
        this.hostPathLabel = new JLabel();
        this.containerPathLabel = new JLabel();
        this.dockerVolumeCheckBox = new JCheckBox();
        this.hostPathField = new JTextField();
        this.containerPathField = new JTextField();
        this.setPreferredSize(new Dimension(438, 353));
        this.targetValueLabel.setLabelFor(this.dasPortField);
        Mnemonics.setLocalizedText((JLabel)this.targetValueLabel, (String)NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.targetValueLabel.text"));
        this.targetValueField.setText(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.targetValueField.text"));
        Mnemonics.setLocalizedText((JLabel)this.userNameLabel, (String)NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.userNameLabel.text"));
        this.userNameField.setText(this.initUserNameValue());
        Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.passwordLabel.text"));
        this.passwordField.setText(this.initPasswordValue());
        this.dasPortFieldLabel.setLabelFor(this.dasPortField);
        Mnemonics.setLocalizedText((JLabel)this.dasPortFieldLabel, (String)NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.dasPortFieldLabel.text"));
        this.dasPortField.setColumns(5);
        this.dasPortField.setText(this.initAdminPortValue());
        this.httpPortFieldLabel.setLabelFor(this.httpPortField);
        this.httpPortFieldLabel.setText(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.httpPortFieldLabel.text"));
        this.httpPortField.setColumns(5);
        this.httpPortField.setText(this.initHttpPortValue());
        Mnemonics.setLocalizedText((AbstractButton)this.useDefaultPortsCB, (String)NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.useDefaultPortsCB.text"));
        this.useDefaultPortsCB.setToolTipText(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.useDefaultPortsCB.toolTipText"));
        GroupLayout remotePanelLayout = new GroupLayout(this.remotePanel);
        this.remotePanel.setLayout(remotePanelLayout);
        remotePanelLayout.setHorizontalGroup(remotePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        remotePanelLayout.setVerticalGroup(remotePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.domainLocalLabel.setLabelFor(this.domainLocalField);
        Mnemonics.setLocalizedText((JLabel)this.domainLocalLabel, (String)NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.domainLocalLabel.text"));
        this.domainLocalField.setEditable(true);
        this.hostLocalLabel.setLabelFor(this.hostLocalField);
        this.hostLocalLabel.setText(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.hostLocalLabel.text"));
        this.hostLocalLabel.setMaximumSize(new Dimension(62, 16));
        this.hostLocalLabel.setMinimumSize(new Dimension(62, 16));
        this.hostLocalLabel.setPreferredSize(new Dimension(62, 16));
        this.localIpCB.setSelected(true);
        this.localIpCB.setText(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.localIpCB.text"));
        this.hostLocalField.setEditable(true);
        this.hostRemoteField.setText(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.hostRemoteField.text"));
        this.hostRemoteField.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.hostRemoteLabel.setLabelFor(this.hostRemoteField);
        Mnemonics.setLocalizedText((JLabel)this.hostRemoteLabel, (String)NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.hostRemoteLabel.text"));
        this.hostRemoteLabel.setMaximumSize(new Dimension(62, 16));
        this.hostRemoteLabel.setMinimumSize(new Dimension(62, 16));
        this.hostRemoteLabel.setPreferredSize(new Dimension(62, 16));
        this.domainRemoteLabel.setLabelFor(this.domainLocalField);
        Mnemonics.setLocalizedText((JLabel)this.domainRemoteLabel, (String)NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.domainRemoteLabel.text"));
        this.domainRemoteField.setText(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.domainRemoteField.text"));
        this.domainRemoteField.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.remoteLink.setText(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.remoteLink.text"));
        this.remoteLink.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AddDomainLocationVisualPanel.this.remoteLinkMouseClicked(evt);
            }
        });
        this.hostPathLabel.setText(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.hostPathLabel.text"));
        this.hostPathLabel.setMinimumSize(new Dimension(75, 14));
        this.containerPathLabel.setText(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.containerPathLabel.text"));
        this.containerPathLabel.setMinimumSize(new Dimension(100, 14));
        this.dockerVolumeCheckBox.setText(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.dockerVolumeCheckBox.text"));
        this.dockerVolumeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddDomainLocationVisualPanel.this.dockerVolumeCheckBoxActionPerformed(evt);
            }
        });
        this.hostPathField.setColumns(5);
        this.hostPathField.setText(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.hostPathField.text"));
        this.containerPathField.setColumns(5);
        this.containerPathField.setText(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.containerPathField.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.remoteLink, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.domainLocalLabel, -1, -1, Short.MAX_VALUE).addComponent(this.domainRemoteLabel, -1, -1, Short.MAX_VALUE).addComponent(this.hostLocalLabel, -1, -1, Short.MAX_VALUE).addComponent(this.hostRemoteLabel, -1, -1, Short.MAX_VALUE).addComponent(this.dasPortFieldLabel, -1, -1, Short.MAX_VALUE).addComponent(this.targetValueLabel, -1, -1, Short.MAX_VALUE).addComponent(this.userNameLabel, -1, -1, Short.MAX_VALUE).addComponent(this.passwordLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.hostLocalField, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.localIpCB)).addComponent(this.domainRemoteField, -1, -1, Short.MAX_VALUE).addComponent(this.domainLocalField, 0, -1, Short.MAX_VALUE).addComponent(this.hostRemoteField, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.passwordField).addComponent(this.userNameField, GroupLayout.Alignment.LEADING).addComponent(this.targetValueField, GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.dasPortField, -1, 7, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.httpPortFieldLabel))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.httpPortField, -1, 7, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.useDefaultPortsCB)).addGroup(layout.createSequentialGroup().addGap(112, 112, 112).addComponent(this.remotePanel, -1, -1, Short.MAX_VALUE)))))).addComponent(this.dockerVolumeCheckBox).addGroup(layout.createSequentialGroup().addComponent(this.hostPathLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hostPathField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.containerPathLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.containerPathField)))));
        layout.linkSize(0, this.dasPortFieldLabel, this.domainLocalLabel, this.domainRemoteLabel, this.hostLocalLabel, this.hostRemoteLabel, this.httpPortFieldLabel, this.passwordLabel, this.targetValueLabel, this.userNameLabel);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.domainLocalLabel).addComponent(this.domainLocalField, -2, -1, -2)).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.domainRemoteLabel).addComponent(this.domainRemoteField, -2, -1, -2)).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.hostLocalLabel, -2, -1, -2).addComponent(this.hostLocalField, -2, -1, -2).addComponent(this.localIpCB)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.hostRemoteLabel, -2, -1, -2).addComponent(this.hostRemoteField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dasPortField, -2, -1, -2).addComponent(this.useDefaultPortsCB).addComponent(this.dasPortFieldLabel).addComponent(this.httpPortFieldLabel).addComponent(this.httpPortField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.targetValueLabel).addComponent(this.targetValueField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.userNameLabel).addComponent(this.userNameField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.passwordLabel).addComponent(this.passwordField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dockerVolumeCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.hostPathLabel, -2, -1, -2).addComponent(this.containerPathLabel, -2, -1, -2).addComponent(this.hostPathField, -2, -1, -2).addComponent(this.containerPathField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.remoteLink).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.remotePanel, -2, -1, -2)));
        this.dasPortField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.dasPortField.AccessibleContext.accessibleDescription"));
        this.useDefaultPortsCB.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.useDefaultPortsCB.AccessibleContext.accessibleDescription"));
        this.domainLocalField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.domainLocalField.AccessibleContext.accessibleDescription"));
        this.hostRemoteField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddDomainLocationVisualPanel.class, (String)"AddDomainLocationVisualPanel.hostRemoteField.AccessibleContext.accessibleDescription"));
    }

    private void remoteLinkMouseClicked(MouseEvent evt) {
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("http://wiki.netbeans.org/RemoteGlassFish4"));
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void dockerVolumeCheckBoxActionPerformed(ActionEvent evt) {
        this.hostPathLabel.setVisible(this.dockerVolumeCheckBox.isSelected());
        this.hostPathField.setVisible(this.dockerVolumeCheckBox.isSelected());
        this.containerPathLabel.setVisible(this.dockerVolumeCheckBox.isSelected());
        this.containerPathField.setVisible(this.dockerVolumeCheckBox.isSelected());
    }

    class MyKeyListener
    implements KeyListener {
        MyKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent arg0) {
        }

        @Override
        public void keyPressed(KeyEvent arg0) {
        }

        @Override
        public void keyReleased(KeyEvent arg0) {
            AddDomainLocationVisualPanel.this.fireChangeEvent();
        }
    }
}

