/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.openjdk.jtreg;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.swing.text.Document;
import org.netbeans.api.lsp.CodeLens;
import org.netbeans.api.lsp.Command;
import org.netbeans.api.lsp.Range;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.java.openjdk.jtreg.Bundle;
import org.netbeans.modules.java.openjdk.jtreg.Tag;
import org.netbeans.modules.java.openjdk.jtreg.TagParser;
import org.netbeans.modules.java.openjdk.jtreg.TestRootDescription;
import org.netbeans.spi.lsp.CodeLensProvider;
import org.openide.filesystems.FileObject;

public class CodeLensProviderImpl
implements CodeLensProvider {
    public CompletableFuture<List<? extends CodeLens>> codeLens(Document doc) {
        CompletableFuture<List<? extends CodeLens>> result = new CompletableFuture<List<? extends CodeLens>>();
        result.complete(this.doComputeCodeLens(doc));
        return result;
    }

    private List<? extends CodeLens> doComputeCodeLens(Document doc) {
        TestRootDescription rootDesc;
        FileObject file = NbEditorUtilities.getFileObject((Document)doc);
        TestRootDescription testRootDescription = rootDesc = file != null ? TestRootDescription.findRootDescriptionFor(file) : null;
        if (rootDesc == null) {
            return Collections.emptyList();
        }
        TagParser.Result tags = TagParser.parseTags(doc);
        List testTags = tags.getName2Tag().getOrDefault("test", Collections.emptyList());
        if (testTags.isEmpty()) {
            return Collections.emptyList();
        }
        Tag testTag = (Tag)testTags.get(0);
        Range lenSpan = new Range(testTag.getTagStart(), testTag.getTagEnd());
        List<String> params = Collections.singletonList(file.toURI().toString());
        return Collections.unmodifiableList(Arrays.asList(new CodeLens(lenSpan, new Command(Bundle.DN_RunTest(), "java.run.test", params), null), new CodeLens(lenSpan, new Command(Bundle.DN_DebugTest(), "java.debug.test", params), null)));
    }
}

