/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.PrimitiveArrayInstance;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.heapwalk.details.api.ExportAction;
import org.netbeans.modules.profiler.heapwalk.details.api.StringDecoder;
import org.netbeans.modules.profiler.heapwalk.details.basic.Bundle;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsProvider;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsUtils;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;

final class ArrayValueView
extends DetailsProvider.View
implements Scrollable,
ExportAction.ExportProvider {
    private static final int MAX_PREVIEW_LENGTH = 256;
    private static final int MAX_ARRAY_ITEMS = 1000;
    private static final int MAX_CHARARRAY_ITEMS = 500000;
    private static final String TRUNCATED = Bundle.ArrayValueView_Truncated();
    private final String className;
    private JTextArea view;
    private JButton all;
    private String caption;
    private Heap heap;
    private List<String> values;
    private byte coder = (byte)-1;
    private String separator;
    private int offset;
    private int count;
    private boolean truncated;
    private boolean chararray;
    private boolean bytearray;
    private String instanceIdentifier;
    private Type type;

    protected ArrayValueView(String className, Instance instance, Heap heap) {
        super(instance, heap);
        this.className = className;
    }

    @Override
    protected void computeView(Instance instance, Heap h) {
        if ("java.lang.String".equals(this.className)) {
            this.separator = "";
            this.offset = DetailsUtils.getIntFieldValue(instance, "offset", 0);
            this.count = DetailsUtils.getIntFieldValue(instance, "count", -1);
            this.coder = DetailsUtils.getByteFieldValue(instance, "coder", (byte)-1);
            this.values = DetailsUtils.getPrimitiveArrayFieldValues(instance, "value");
            this.caption = Bundle.ArrayValueView_Value();
            this.heap = h;
            this.type = Type.STRING;
        } else if ("java.lang.AbstractStringBuilder+".equals(this.className)) {
            this.separator = "";
            this.offset = 0;
            this.count = DetailsUtils.getIntFieldValue(instance, "count", -1);
            this.coder = DetailsUtils.getByteFieldValue(instance, "coder", (byte)-1);
            this.values = DetailsUtils.getPrimitiveArrayFieldValues(instance, "value");
            this.caption = Bundle.ArrayValueView_Value();
            this.heap = h;
            this.type = Type.STRING_BUILDER;
        } else if (instance instanceof PrimitiveArrayInstance) {
            this.chararray = "char[]".equals(instance.getJavaClass().getName());
            this.bytearray = "byte[]".equals(instance.getJavaClass().getName());
            this.separator = this.chararray ? "" : ", ";
            this.offset = 0;
            this.values = DetailsUtils.getPrimitiveArrayValues(instance);
            this.count = this.values == null ? 0 : this.values.size();
            this.caption = Bundle.ArrayValueView_Items();
            this.type = Type.PRIMITIVE_ARRAY;
        }
        this.instanceIdentifier = instance.getJavaClass().getName() + "#" + instance.getInstanceNumber();
        final String preview = this.getString(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ArrayValueView.this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                ArrayValueView.this.setBackground(UIUtils.getProfilerResultsBackground());
                ArrayValueView.this.setOpaque(true);
                ArrayValueView.this.removeAll();
                JLabel l = new JLabel(ArrayValueView.this.caption, 10);
                l.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 0));
                ArrayValueView.this.add((Component)l, "North");
                ArrayValueView.this.view = new JTextArea();
                l.setLabelFor(ArrayValueView.this.view);
                ArrayValueView.this.view.setEditable(false);
                ArrayValueView.this.view.setLineWrap(true);
                ArrayValueView.this.view.setWrapStyleWord(true);
                ArrayValueView.this.view.setText(preview);
                try {
                    ArrayValueView.this.view.setCaretPosition(0);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                JScrollPane viewScroll = new JScrollPane(ArrayValueView.this.view, 20, 31);
                ArrayValueView.this.add((Component)viewScroll, "Center");
                JPanel p = new JPanel(new GridBagLayout());
                p.setOpaque(false);
                ArrayValueView.this.all = ArrayValueView.htmlButton(Bundle.ArrayValueView_All(), ArrayValueView.this.truncated && ArrayValueView.this.count < (ArrayValueView.this.chararray ? 500000 : 1000), new Runnable(){

                    @Override
                    public void run() {
                        ArrayValueView.this.showAll();
                    }
                });
                GridBagConstraints c = new GridBagConstraints();
                c.gridx = 0;
                c.insets = new Insets(3, 0, 0, 5);
                p.add((Component)ArrayValueView.this.all, c);
                JButton save = ArrayValueView.htmlButton(Bundle.ArrayValueView_Save(), !preview.isEmpty(), new Runnable(){

                    @Override
                    public void run() {
                        new ExportAction(ArrayValueView.this).actionPerformed(null);
                    }
                });
                c = new GridBagConstraints();
                c.gridx = 1;
                c.insets = new Insets(3, 0, 0, 0);
                p.add((Component)save, c);
                JPanel f = new JPanel(null);
                f.setOpaque(false);
                c = new GridBagConstraints();
                c.gridx = 2;
                c.weightx = 1.0;
                c.fill = 2;
                p.add((Component)f, c);
                ArrayValueView.this.add((Component)p, "South");
                ArrayValueView.this.revalidate();
                ArrayValueView.this.doLayout();
                ArrayValueView.this.repaint();
            }
        });
    }

    private void showAll() {
        this.all.setEnabled(false);
        this.view.setEnabled(false);
        BrowserUtils.performTask(new Runnable(){

            @Override
            public void run() {
                String _preview = null;
                try {
                    _preview = ArrayValueView.this.getString(false);
                }
                catch (OutOfMemoryError e) {
                    ProfilerDialogs.displayError((String)Bundle.ArrayValueView_OutOfMemory());
                    return;
                }
                final String preview = _preview;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ArrayValueView.this.view.setText(preview);
                            try {
                                ArrayValueView.this.view.setCaretPosition(0);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                            ArrayValueView.this.view.setEnabled(true);
                        }
                        catch (OutOfMemoryError e) {
                            ProfilerDialogs.displayError((String)Bundle.ArrayValueView_OutOfMemory());
                        }
                    }
                });
            }
        });
    }

    private String getString(boolean preview) {
        if (this.values == null) {
            return "";
        }
        StringDecoder decoder = new StringDecoder(this.heap, this.coder, this.values);
        int valuesCount = this.count < 0 ? decoder.getStringLength() - this.offset : this.count;
        int separatorLength = this.separator == null ? 0 : this.separator.length();
        int estimatedSize = (int)Math.min((long)valuesCount * (long)(2 + separatorLength), (long)(256 + TRUNCATED.length()));
        StringBuilder value = new StringBuilder(estimatedSize);
        int lastValue = this.offset + valuesCount - 1;
        for (int i = this.offset; i <= lastValue; ++i) {
            value.append(decoder.getValueAt(i));
            if (preview && value.length() >= 256) {
                value.append(TRUNCATED);
                this.truncated = true;
                break;
            }
            if (this.separator == null || i >= lastValue) continue;
            value.append(this.separator);
        }
        return value.toString();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return null;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        Container parent = this.getParent();
        if (parent == null || !(parent instanceof JViewport)) {
            return 50;
        }
        return (int)((float)((JViewport)parent).getHeight() * 0.95f);
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        Container parent = this.getParent();
        if (parent == null || !(parent instanceof JViewport)) {
            return false;
        }
        return this.getMinimumSize().height < ((JViewport)parent).getHeight();
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        Container parent = this.getParent();
        if (parent == null || !(parent instanceof JViewport)) {
            return false;
        }
        return this.getMinimumSize().width < ((JViewport)parent).getWidth();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 20;
    }

    private static JButton htmlButton(final String text, boolean enabled, final Runnable handler) {
        JButton b = new JButton(){

            @Override
            public void setEnabled(boolean b) {
                this.setText(!b ? text : "<html><nobr><a href='#'>" + text + "</a></nobr></html>");
                this.setCursor(!b ? Cursor.getDefaultCursor() : Cursor.getPredefinedCursor(12));
                super.setEnabled(b);
            }
        };
        b.setOpaque(false);
        b.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
        b.setBorderPainted(false);
        b.setContentAreaFilled(false);
        b.setEnabled(enabled);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                handler.run();
            }
        });
        return b;
    }

    @Override
    public void exportData(int exportedFileType, ExportDataDumper eDD) {
        String comma = ",";
        if (this.values != null) {
            StringDecoder decoder = new StringDecoder(this.heap, this.coder, this.values);
            int valuesCount = this.count < 0 ? decoder.getStringLength() - this.offset : this.count;
            int lastValue = this.offset + valuesCount - 1;
            block5: for (int i = this.offset; i <= lastValue; ++i) {
                String value = decoder.getValueAt(i);
                switch (exportedFileType) {
                    case 1: {
                        eDD.dumpData((CharSequence)value);
                        eDD.dumpData((CharSequence)comma);
                        continue block5;
                    }
                    case 2: {
                        eDD.dumpData((CharSequence)value);
                        continue block5;
                    }
                    case 3: {
                        byte b = Byte.valueOf(value);
                        eDD.dumpByte(b);
                        continue block5;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
        }
        eDD.close();
    }

    @Override
    public String getViewName() {
        return this.instanceIdentifier;
    }

    @Override
    public boolean hasRawData() {
        return this.type.equals((Object)Type.PRIMITIVE_ARRAY);
    }

    @Override
    public boolean hasBinaryData() {
        return this.bytearray;
    }

    @Override
    public boolean hasText() {
        switch (this.type) {
            case STRING: 
            case STRING_BUILDER: {
                return true;
            }
            case PRIMITIVE_ARRAY: {
                return this.chararray;
            }
        }
        throw new IllegalArgumentException(this.type.toString());
    }

    @Override
    public boolean isExportable() {
        return this.hasText() || this.hasBinaryData() || this.hasRawData();
    }

    static enum Type {
        STRING,
        STRING_BUILDER,
        PRIMITIVE_ARRAY;

    }
}

