/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.jsp.lexer.JspTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.web.indent.api.LexUtilities;
import org.netbeans.spi.editor.typinghooks.TypedBreakInterceptor;

public class JspTypedBreakInterceptor
implements TypedBreakInterceptor {
    public boolean beforeInsert(TypedBreakInterceptor.Context context) throws BadLocationException {
        return false;
    }

    public void insert(TypedBreakInterceptor.MutableContext context) throws BadLocationException {
        int caretOffset;
        BaseDocument doc = (BaseDocument)context.getDocument();
        TokenSequence ts = LexUtilities.getTokenSequence((BaseDocument)doc, (int)(caretOffset = context.getCaretOffset()), (Language)JspTokenId.language());
        if (ts == null) {
            return;
        }
        ts.move(caretOffset);
        String closingTagName = null;
        int end = -1;
        if (ts.moveNext() && ts.token().id() == JspTokenId.SYMBOL && ts.token().text().toString().equals("</") && ts.moveNext() && ts.token().id() == JspTokenId.ENDTAG) {
            closingTagName = ts.token().text().toString();
            end = ts.offset() + ts.token().text().length();
            ts.movePrevious();
            ts.movePrevious();
        }
        if (closingTagName == null) {
            return;
        }
        boolean foundOpening = false;
        if (ts.token().id() == JspTokenId.SYMBOL && ts.token().text().toString().equals(">")) {
            while (ts.movePrevious()) {
                if (ts.token().id() != JspTokenId.TAG) continue;
                if (!ts.token().text().toString().equals(closingTagName)) break;
                foundOpening = true;
                break;
            }
        }
        if (foundOpening) {
            int indent = GsfUtilities.getLineIndent((BaseDocument)doc, (int)caretOffset);
            StringBuilder text = new StringBuilder();
            text.append("\n");
            text.append(IndentUtils.createIndentString((Document)doc, (int)(indent + IndentUtils.indentLevelSize((Document)doc))));
            int caret = text.length();
            text.append("\n");
            text.append(IndentUtils.createIndentString((Document)doc, (int)indent));
            context.setText(text.toString(), caret, caret, new int[0]);
        }
    }

    public void afterInsert(TypedBreakInterceptor.Context context) throws BadLocationException {
    }

    public void cancelled(TypedBreakInterceptor.Context context) {
    }

    public static class JspFactory
    implements TypedBreakInterceptor.Factory {
        public TypedBreakInterceptor createTypedBreakInterceptor(MimePath mimePath) {
            return new JspTypedBreakInterceptor();
        }
    }
}

