/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.BasedSequenceImpl;
import com.vladsch.flexmark.util.sequence.Range;
import com.vladsch.flexmark.util.sequence.RepeatedCharSequence;

public final class PrefixedSubSequence
extends BasedSequenceImpl {
    private final String prefix;
    private final int prefixLength;
    private final BasedSequence base;

    @Override
    public Object getBase() {
        return this.base.getBase();
    }

    @Override
    public BasedSequence getBaseSequence() {
        return this.base.getBaseSequence();
    }

    @Override
    public int getStartOffset() {
        return this.base.getStartOffset();
    }

    @Override
    public int getEndOffset() {
        return this.base.getEndOffset();
    }

    @Override
    public Range getSourceRange() {
        return this.base.getSourceRange();
    }

    @Override
    public BasedSequence baseSubSequence(int start, int end) {
        return this.base.baseSubSequence(start, end);
    }

    private PrefixedSubSequence(String prefix, BasedSequence baseSeq, int start, int end, boolean replaceChar) {
        this.prefix = replaceChar ? prefix.replace('\u0000', '\ufffd') : prefix;
        this.prefixLength = prefix.length();
        this.base = PrefixedSubSequence.of(baseSeq, start, end);
    }

    @Override
    public int length() {
        return this.prefixLength + this.base.length();
    }

    @Override
    public int getIndexOffset(int index) {
        if (index < this.prefixLength) {
            return -1;
        }
        return this.base.getIndexOffset(index - this.prefixLength);
    }

    @Override
    public char charAt(int index) {
        if (index >= 0 && index < this.base.length() + this.prefixLength) {
            if (index < this.prefixLength) {
                return this.prefix.charAt(index);
            }
            return this.base.charAt(index - this.prefixLength);
        }
        throw new StringIndexOutOfBoundsException("String index out of range: " + index);
    }

    @Override
    public BasedSequence subSequence(int start, int end) {
        if (start >= 0 && end <= this.base.length() + this.prefixLength) {
            if (start < this.prefixLength) {
                if (end <= this.prefixLength) {
                    return new PrefixedSubSequence(this.prefix.substring(start, end), (BasedSequence)this.base.subSequence(0, 0), 0, 0, false);
                }
                return new PrefixedSubSequence(this.prefix.substring(start), this.base, 0, end - this.prefixLength, false);
            }
            return (BasedSequence)this.base.subSequence(start - this.prefixLength, end - this.prefixLength);
        }
        if (start < 0 || start > this.base.length() + this.prefixLength) {
            throw new StringIndexOutOfBoundsException("String index out of range: " + start);
        }
        throw new StringIndexOutOfBoundsException("String index out of range: " + end);
    }

    @Override
    public String toString() {
        return this.prefix + this.base;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof CharSequence && this.toString().equals(obj.toString());
    }

    public static PrefixedSubSequence repeatOf(CharSequence prefix, int count, BasedSequence baseSeq) {
        return PrefixedSubSequence.of(RepeatedCharSequence.of(prefix, count).toString(), baseSeq, 0, baseSeq.length());
    }

    public static PrefixedSubSequence repeatOf(char prefix, int count, BasedSequence baseSeq) {
        return PrefixedSubSequence.of(RepeatedCharSequence.of(prefix, count).toString(), baseSeq, 0, baseSeq.length());
    }

    public static PrefixedSubSequence of(String prefix, BasedSequence baseSeq) {
        return PrefixedSubSequence.of(prefix, baseSeq, 0, baseSeq.length());
    }

    public static PrefixedSubSequence of(String prefix, BasedSequence baseSeq, int start) {
        return PrefixedSubSequence.of(prefix, baseSeq, start, baseSeq.length());
    }

    public static PrefixedSubSequence of(String prefix, BasedSequence baseSeq, int start, int end) {
        return new PrefixedSubSequence(prefix, baseSeq, start, end, true);
    }
}

