/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.imagecompare;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.imagecompare.ImageCompare;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class ImageCompareRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ImageCompare compare = (ImageCompare)component;
        this.encodeMarkup(context, compare);
        this.encodeScript(context, compare);
    }

    protected void encodeScript(FacesContext context, ImageCompare compare) throws IOException {
        String clientId = compare.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("ImageCompare", compare.resolveWidgetVar(), clientId, "imagecompare").attr("handle", this.getResourceRequestPath(context, "imagecompare/handle.gif")).attr("lt", this.getResourceRequestPath(context, "imagecompare/lt-small.png")).attr("rt", this.getResourceRequestPath(context, "imagecompare/rt-small.png"));
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, ImageCompare compare) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", (UIComponent)compare);
        writer.writeAttribute("id", (Object)compare.getClientId(context), "id");
        this.renderImage(context, compare, "before", compare.getLeftImage());
        this.renderImage(context, compare, "fter", compare.getRightImage());
        writer.endElement("div");
    }

    private void renderImage(FacesContext context, ImageCompare compare, String type, String src) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", (UIComponent)compare);
        writer.startElement("img", null);
        writer.writeAttribute("alt", (Object)type, null);
        writer.writeAttribute("src", (Object)this.getResourceURL(context, src), null);
        writer.writeAttribute("width", (Object)compare.getWidth(), null);
        writer.writeAttribute("height", (Object)compare.getHeight(), null);
        writer.endElement("img");
        writer.endElement("div");
    }
}

